/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.jres;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.jres.JREMessages;
import org.eclipse.jdt.internal.launching.MacInstalledJREs;
import org.eclipse.jdt.launching.AbstractVMInstallType;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMStandin;
import org.eclipse.osgi.util.NLS;

public class MacVMSearch {
    public VMStandin[] search(IProgressMonitor monitor) {
        MacInstalledJREs.JREDescriptor[] descriptors = null;
        try {
            descriptors = new MacInstalledJREs().getInstalledJREs();
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.log(e.getStatus());
            return new VMStandin[0];
        }
        SubMonitor localmonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)JREMessages.MacVMSearch_0, (int)descriptors.length);
        IVMInstallType macVMType = JavaRuntime.getVMInstallType((String)"org.eclipse.jdt.internal.launching.macosx.MacOSXType");
        ArrayList<VMStandin> vms = new ArrayList<VMStandin>();
        if (macVMType != null) {
            int i = 0;
            while (i < descriptors.length) {
                MacInstalledJREs.JREDescriptor descriptor = descriptors[i];
                String name = descriptor.getName();
                String id = descriptor.getId();
                try {
                    File home = descriptor.getHome();
                    if (home.exists()) {
                        String arguments;
                        boolean isDefault = i == 0;
                        VMStandin vm = new VMStandin(macVMType, id);
                        vm.setInstallLocation(home);
                        String format = isDefault ? JREMessages.MacVMSearch_1 : JREMessages.MacVMSearch_2;
                        vm.setName(NLS.bind((String)format, (Object[])new Object[]{name}));
                        vm.setLibraryLocations(macVMType.getDefaultLibraryLocations(home));
                        URL doc = ((AbstractVMInstallType)macVMType).getDefaultJavadocLocation(home);
                        if (doc != null) {
                            vm.setJavadocLocation(doc);
                        }
                        if ((arguments = ((AbstractVMInstallType)macVMType).getDefaultVMArguments(home)) != null) {
                            vm.setVMArgs(arguments);
                        }
                        vms.add(vm);
                    }
                    if (localmonitor.isCanceled()) break;
                    localmonitor.worked(1);
                }
                finally {
                    localmonitor.done();
                }
                ++i;
            }
        }
        return vms.toArray(new VMStandin[vms.size()]);
    }
}

