/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.editor;

import com.google.inject.Inject;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.xtext.LanguageInfo;
import org.eclipse.xtext.generator.trace.ILocationInResource;
import org.eclipse.xtext.generator.trace.ITrace;
import org.eclipse.xtext.generator.trace.ITraceInformation;
import org.eclipse.xtext.resource.ILocationInFileProvider;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.XtextReadonlyEditorInput;
import org.eclipse.xtext.util.Files;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.ITextRegionWithLineInformation;
import org.eclipse.xtext.util.TextRegion;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociations;
import org.eclipse.xtext.xbase.ui.editor.DocumentProviderStub;
import org.eclipse.xtext.xbase.ui.editor.StacktraceBasedEditorDecider;

public class XbaseEditor
extends XtextEditor {
    private static final Logger log = Logger.getLogger(XbaseEditor.class);
    protected static final String TAG_ASSOCIATED_JAVA_RESOURCE = "javaResourcePath";
    @Inject
    private ITraceInformation traceInformation;
    @Inject
    private IJvmModelAssociations associations;
    @Inject
    private ILocationInFileProvider locationProvider;
    @Inject
    private IWorkspace workspace;
    @Inject
    private LanguageInfo languageInfo;
    @Inject
    private StacktraceBasedEditorDecider calleeAnalyzer;
    private IResource javaResource = null;
    private int expectJavaSelection = 0;
    private boolean expectLineSelection = false;
    private boolean isIgnoreCall = false;
    private Exception lastCall = null;
    int reentrantCallFromSelf = 0;

    public void saveState(IMemento memento) {
        super.saveState(memento);
        if (this.javaResource != null && this.javaResource.getFullPath() != null) {
            memento.putString(TAG_ASSOCIATED_JAVA_RESOURCE, this.javaResource.getFullPath().toPortableString());
        }
    }

    protected void doRestoreState(IMemento memento) {
        super.doRestoreState(memento);
        String pathString = memento.getString(TAG_ASSOCIATED_JAVA_RESOURCE);
        if (pathString != null) {
            IPath path = Path.fromPortableString((String)pathString);
            IResource foundResource = this.workspace.getRoot().findMember(path);
            if (foundResource != null && foundResource.exists()) {
                this.javaResource = foundResource;
            }
        }
    }

    protected boolean containsSavedState(IMemento memento) {
        boolean result = super.containsSavedState(memento);
        if (!result) {
            return memento.getString(TAG_ASSOCIATED_JAVA_RESOURCE) != null;
        }
        return result;
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        try {
            IFile resource = ResourceUtil.getFile((IEditorInput)input);
            ITrace trace = this.traceInformation.getTraceToSource((IStorage)resource);
            if (trace == null) {
                super.doSetInput(input);
                return;
            }
            Iterator allLocations = trace.getAllAssociatedLocations().iterator();
            ILocationInResource sourceInformation = null;
            while (allLocations.hasNext() && sourceInformation == null) {
                ILocationInResource candidate = (ILocationInResource)allLocations.next();
                if (!this.languageInfo.equals((Object)candidate.getLanguage())) continue;
                sourceInformation = candidate;
            }
            if (sourceInformation == null) {
                super.doSetInput(input);
                return;
            }
            IStorage originalStorage = sourceInformation.getStorage();
            if (originalStorage instanceof IFile) {
                super.doSetInput((IEditorInput)new FileEditorInput((IFile)originalStorage));
            } else {
                super.doSetInput((IEditorInput)new XtextReadonlyEditorInput(originalStorage));
            }
            if (JavaCore.isJavaLikeFileName((String)resource.getName())) {
                this.markNextSelectionAsJavaOffset((IResource)resource);
            }
            return;
        }
        catch (CoreException coreException) {
            super.doSetInput(input);
            return;
        }
    }

    public void markNextSelectionAsJavaOffset(IResource javaResource) {
        if (this.expectJavaSelection > 0) {
            if (!this.isIgnoreCall) {
                if (this.lastCall != null) {
                    log.warn((Object)"The editor is already awaiting a select and reveal call from : ", (Throwable)this.lastCall);
                    log.warn((Object)"Now called from : ", (Throwable)new Exception());
                }
                this.expectJavaSelection = 0;
            } else {
                this.expectJavaSelection = 0;
            }
        }
        this.lastCall = new Exception();
        ++this.expectJavaSelection;
        this.isIgnoreCall = this.calleeAnalyzer.isEditorUtilityIsOpenInEditor() || this.calleeAnalyzer.isOpenEditorAction();
        if (this.calleeAnalyzer.isCalledFromFindReferences()) {
            ++this.expectJavaSelection;
        }
        this.javaResource = javaResource;
    }

    protected void safelySanityCheckState(IEditorInput input) {
        try {
            ++this.reentrantCallFromSelf;
            super.safelySanityCheckState(input);
        }
        finally {
            --this.reentrantCallFromSelf;
        }
    }

    public boolean isDirty() {
        try {
            ++this.reentrantCallFromSelf;
            boolean bl = super.isDirty();
            return bl;
        }
        finally {
            --this.reentrantCallFromSelf;
        }
    }

    public IDocumentProvider getDocumentProvider() {
        if (this.expectJavaSelection > 0 && this.reentrantCallFromSelf == 0 && this.calleeAnalyzer.isLineBasedOpenEditorAction()) {
            this.expectLineSelection = true;
            return new DocumentProviderStub(){

                public IDocument getDocument(Object element) {
                    try {
                        String string = Files.readStreamIntoString((InputStream)((IStorage)XbaseEditor.this.javaResource).getContents());
                        Document document = new Document(string);
                        return document;
                    }
                    catch (CoreException e) {
                        return XbaseEditor.super.getDocumentProvider().getDocument(element);
                    }
                }

                public void connect(Object element) throws CoreException {
                }

                public void disconnect(Object element) {
                }
            };
        }
        return super.getDocumentProvider();
    }

    protected void selectAndReveal(int selectionStart, int selectionLength, int revealStart, int revealLength) {
        block20: {
            block18: {
                ITextRegionWithLineInformation fixedSelection;
                ITrace traceToSource;
                block19: {
                    ITextRegionWithLineInformation textRegion;
                    ILocationInResource bestSelection;
                    int startOffsetOfContents;
                    ++this.reentrantCallFromSelf;
                    if (this.expectJavaSelection <= 0) break block18;
                    traceToSource = this.traceInformation.getTraceToSource((IStorage)this.javaResource);
                    if (traceToSource == null) break block18;
                    if (!this.expectLineSelection || !(this.javaResource instanceof IStorage)) break block19;
                    String string2 = Files.readStreamIntoString((InputStream)((IStorage)this.javaResource).getContents());
                    Document javaDocument = new Document(string2);
                    int line = this.getLineInJavaDocument(javaDocument, selectionStart, selectionLength);
                    if (line == -1 || (startOffsetOfContents = this.getStartOffsetOfContentsInJava(javaDocument, line)) == -1 || (bestSelection = traceToSource.getBestAssociatedLocation((ITextRegion)new TextRegion(startOffsetOfContents, 0))) == null || (textRegion = bestSelection.getTextRegion()) == null) break block18;
                    int lineToSelect = textRegion.getLineNumber();
                    try {
                        IRegion lineInfo = this.getDocument().getLineInformation(lineToSelect);
                        super.selectAndReveal(lineInfo.getOffset(), lineInfo.getLength(), lineInfo.getOffset(), lineInfo.getLength());
                        return;
                    }
                    catch (BadLocationException e) {
                        try {
                            log.error((Object)e);
                        }
                        catch (BadLocationException string2) {
                        }
                        catch (CoreException string2) {}
                        break block18;
                    }
                }
                ILocationInResource bestSelection = traceToSource.getBestAssociatedLocation((ITextRegion)new TextRegion(selectionStart, selectionLength));
                if (bestSelection == null) break block18;
                ILocationInResource bestReveal = bestSelection;
                if ((selectionStart != revealStart || selectionLength != revealLength) && (bestReveal = traceToSource.getBestAssociatedLocation((ITextRegion)new TextRegion(revealStart, revealLength))) == null) {
                    bestReveal = bestSelection;
                }
                if ((fixedSelection = bestSelection.getTextRegion()) != null) {
                    ITextRegionWithLineInformation fixedReveal = bestReveal.getTextRegion();
                    if (fixedReveal == null) {
                        fixedReveal = fixedSelection;
                    }
                    super.selectAndReveal(fixedSelection.getOffset(), fixedSelection.getLength(), fixedReveal.getOffset(), fixedReveal.getLength());
                    return;
                }
            }
            super.selectAndReveal(selectionStart, selectionLength, revealStart, revealLength);
            break block20;
            {
                finally {
                    this.expectLineSelection = false;
                    --this.expectJavaSelection;
                }
            }
            finally {
                --this.reentrantCallFromSelf;
            }
        }
    }

    protected int getLineInJavaDocument(Document document, int selectionStart, int selectionLength) throws BadLocationException {
        int line = document.getLineOfOffset(selectionStart);
        int length = document.getLineLength(line);
        int lineOffset = document.getLineOffset(line);
        if (lineOffset == selectionStart && length == selectionLength) {
            return line;
        }
        IRegion region = document.getLineInformation(line);
        if (region.getOffset() == selectionStart || region.getLength() == selectionLength) {
            return line;
        }
        return -1;
    }

    protected int getStartOffsetOfContentsInJava(Document document, int line) throws BadLocationException {
        IRegion lineInformation = document.getLineInformation(line);
        String lineText = document.get(lineInformation.getOffset(), lineInformation.getLength());
        String contents = lineText.trim();
        if (contents.length() == 0) {
            log.warn((Object)"selection points to an empty line!", (Throwable)new IllegalStateException());
            return -1;
        }
        int contentsStarts = lineText.indexOf(contents);
        return lineInformation.getOffset() + contentsStarts;
    }

    public void reveal(int offset, int length) {
        super.reveal(offset, length);
    }
}

