/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.model.ui.wizards;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.stem.model.metamodel.Compartment;
import org.eclipse.stem.model.metamodel.CompartmentGroup;
import org.eclipse.stem.model.metamodel.MetamodelFactory;
import org.eclipse.stem.model.metamodel.Model;
import org.eclipse.stem.model.ui.wizards.InheritedColumnLabelProvider;
import org.eclipse.stem.model.ui.wizards.ModelCompartmentEditorDialog;
import org.eclipse.stem.model.ui.wizards.WizardHelper;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class ModelCompartmentsPage
extends WizardPage {
    protected Composite container;
    protected ComboViewer parentLabelComboViewer;
    protected TableViewer compartmentViewer;
    protected Label modelParamInformationLabel;
    protected Button addCompartmentButton;
    protected Button editCompartmentButton;
    protected Button removeCompartmentButton;
    protected Model model;

    public ModelCompartmentsPage(Model model) {
        super("Model Compartments Page");
        this.setTitle("Model Compartments");
        this.setDescription("Define the compartments for your model");
        this.model = model;
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        this.container.setLayout((Layout)new GridLayout(3, false));
        this.modelParamInformationLabel = new Label(this.container, 0);
        this.modelParamInformationLabel.setText("Select compartments for your model");
        GridData labelGridData = new GridData(4);
        labelGridData.horizontalSpan = 3;
        this.modelParamInformationLabel.setLayoutData((Object)labelGridData);
        this.createParentLabelList(this.container);
        this.createModelParamsTable(this.container);
        this.setControl((Control)this.container);
    }

    private void createParentLabelList(Composite container) {
        Label dataTypeLabel = new Label(container, 0);
        dataTypeLabel.setText("Parent Compartment Group");
        this.parentLabelComboViewer = new ComboViewer(container, 8);
        this.parentLabelComboViewer.getCombo().setLayoutData((Object)new GridData(768));
        this.parentLabelComboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.parentLabelComboViewer.setLabelProvider((IBaseLabelProvider)new CompartmentGroupNameLabelProvider());
        this.parentLabelComboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object obj = ((StructuredSelection)ModelCompartmentsPage.this.parentLabelComboViewer.getSelection()).getFirstElement();
                if (obj instanceof CompartmentGroup) {
                    ModelCompartmentsPage.this.model.getCompartments().setParentGroup((CompartmentGroup)obj);
                    ModelCompartmentsPage.this.compartmentViewer.refresh();
                    ModelCompartmentsPage.this.validatePage();
                }
            }
        });
    }

    private Compartment openCompartmentsEditorDialog(Compartment compartment) {
        Compartment compartmentToUse = null;
        compartmentToUse = compartment == null ? MetamodelFactory.eINSTANCE.createCompartment() : (Compartment)EcoreUtil.copy((EObject)compartment);
        ModelCompartmentEditorDialog editorDialog = new ModelCompartmentEditorDialog(this.getShell(), 0, this.model.getCompartments(), compartmentToUse, compartment);
        if (editorDialog.open() == 0) {
            return compartmentToUse;
        }
        return null;
    }

    private void addCompartment() {
        Compartment compartment = this.openCompartmentsEditorDialog(null);
        if (compartment != null) {
            this.model.getCompartments().getCompartments().add((Object)compartment);
            this.compartmentViewer.refresh();
        }
    }

    private void editCompartment() {
        Compartment selected = this.getSelectedCompartment();
        if (selected != null) {
            if (!this.inherited(selected)) {
                Compartment previousCompartment = selected;
                Compartment compartment = this.openCompartmentsEditorDialog(previousCompartment);
                if (compartment != null) {
                    Collections.replaceAll(this.model.getCompartments().getCompartments(), previousCompartment, compartment);
                    this.compartmentViewer.refresh();
                }
            } else {
                MessageDialog.openWarning((Shell)this.getShell(), (String)"Edit Compartment", (String)"You cannot edit a compartment inherited from another model.");
            }
        }
    }

    private void removeCompartment() {
        Compartment selected = this.getSelectedCompartment();
        if (selected != null && !this.inherited(selected)) {
            this.model.getCompartments().getCompartments().remove((Object)selected);
            this.compartmentViewer.refresh();
        }
    }

    private Compartment getSelectedCompartment() {
        return (Compartment)((StructuredSelection)this.compartmentViewer.getSelection()).getFirstElement();
    }

    private void toggleButtons(boolean forceDisable) {
        boolean toggle = false;
        if (!forceDisable) {
            Compartment selected = this.getSelectedCompartment();
            toggle = selected != null && !this.inherited(selected);
        }
        this.editCompartmentButton.setEnabled(toggle);
        this.removeCompartmentButton.setEnabled(toggle);
    }

    private void createModelParamsTable(Composite container) {
        this.compartmentViewer = new TableViewer(container, 68352);
        this.compartmentViewer.setUseHashlookup(true);
        this.compartmentViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ModelCompartmentsPage.this.toggleButtons(false);
            }
        });
        this.compartmentViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ModelCompartmentsPage.this.editCompartment();
            }
        });
        Table table = this.compartmentViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 3;
        this.compartmentViewer.getControl().setLayoutData((Object)gridData);
        this.compartmentViewer.setContentProvider((IContentProvider)new CompartmentContentProvider());
        TableViewerColumn viewerColumn = null;
        TableColumn column = null;
        viewerColumn = new TableViewerColumn(this.compartmentViewer, 0);
        column = viewerColumn.getColumn();
        column.setText("Name");
        column.setWidth(175);
        column.setResizable(true);
        column.setMoveable(false);
        viewerColumn.setLabelProvider((CellLabelProvider)new ModelCompartmentColumnLabelProvider(){

            public String getText(Object element) {
                return ((Compartment)element).getName();
            }
        });
        viewerColumn = new TableViewerColumn(this.compartmentViewer, 0);
        column = viewerColumn.getColumn();
        column.setText("Compartment Type");
        column.setWidth(130);
        column.setResizable(true);
        column.setMoveable(false);
        viewerColumn.setLabelProvider((CellLabelProvider)new ModelCompartmentColumnLabelProvider(){

            public String getText(Object element) {
                return ((Compartment)element).getType().getLiteral();
            }
        });
        viewerColumn = new TableViewerColumn(this.compartmentViewer, 0);
        column = viewerColumn.getColumn();
        column.setText("Inherited From");
        column.setWidth(250);
        column.setResizable(true);
        column.setMoveable(false);
        viewerColumn.setLabelProvider((CellLabelProvider)new ModelCompartmentColumnLabelProvider(){

            public String getText(Object element) {
                Compartment compartment = (Compartment)element;
                if (compartment.getContainerGroup() != null) {
                    String name = compartment.getContainerGroup().getName();
                    name = name.replace("LabelValue", "");
                    return name;
                }
                return "";
            }
        });
        this.compartmentViewer.setComparator(new ViewerComparator(){

            public void sort(Viewer viewer, Object[] elements) {
                Arrays.sort(elements, new Comparator<Object>(){

                    @Override
                    public int compare(Object o1, Object o2) {
                        if (o1 instanceof Compartment && o2 instanceof Compartment) {
                            Compartment c1 = (Compartment)o1;
                            Compartment c2 = (Compartment)o2;
                            if (ModelCompartmentsPage.this.inherited(c1) && !ModelCompartmentsPage.this.inherited(c2)) {
                                return 1;
                            }
                            if (!ModelCompartmentsPage.this.inherited(c1) && ModelCompartmentsPage.this.inherited(c2)) {
                                return -1;
                            }
                        }
                        return 0;
                    }
                });
            }
        });
        Composite buttonBarComposite = new Composite(container, 0);
        GridData buttonBarGridData = new GridData(768);
        buttonBarGridData.horizontalSpan = 3;
        buttonBarComposite.setLayoutData((Object)buttonBarGridData);
        buttonBarComposite.setLayout((Layout)new GridLayout(3, false));
        this.addCompartmentButton = new Button(buttonBarComposite, 8);
        this.addCompartmentButton.setEnabled(true);
        this.addCompartmentButton.setText("Add Compartment");
        this.addCompartmentButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModelCompartmentsPage.this.addCompartment();
            }
        });
        this.editCompartmentButton = new Button(buttonBarComposite, 8);
        this.editCompartmentButton.setEnabled(false);
        this.editCompartmentButton.setText("Edit Compartment");
        this.editCompartmentButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModelCompartmentsPage.this.editCompartment();
            }
        });
        this.removeCompartmentButton = new Button(buttonBarComposite, 8);
        this.removeCompartmentButton.setEnabled(false);
        this.removeCompartmentButton.setText("Remove Compartment");
        this.removeCompartmentButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModelCompartmentsPage.this.removeCompartment();
            }
        });
        this.compartmentViewer.setInput((Object)this.model);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.compartmentViewer.setInput((Object)this.model);
            this.compartmentViewer.refresh();
            this.parentLabelComboViewer.setInput((Object)WizardHelper.getCompartmentGroupsForModelType(this.model.getModelType(), false, (IProgressMonitor)new NullProgressMonitor()).toArray());
            this.parentLabelComboViewer.refresh();
            if (this.model.getCompartments().getParentGroup() != null) {
                this.parentLabelComboViewer.setSelection((ISelection)new StructuredSelection((Object)this.model.getCompartments().getParentGroup()));
            }
            this.validatePage();
        }
        super.setVisible(visible);
    }

    boolean validatePage() {
        boolean valid = true;
        String errorMessage = null;
        if (this.model.getCompartments() != null && this.model.getCompartments().getParentGroup() == null) {
            valid = false;
            errorMessage = "Select a parent compartment group for this model";
        }
        this.setPageComplete(valid);
        this.setErrorMessage(errorMessage);
        return valid;
    }

    private boolean inherited(Compartment compartment) {
        return compartment.getContainerGroup() != this.model.getCompartments();
    }

    private class CompartmentContentProvider
    implements IStructuredContentProvider {
        private CompartmentContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return WizardHelper.getAllCompartmentsForModel((Model)inputElement).toArray();
        }
    }

    private static class CompartmentGroupNameLabelProvider
    extends LabelProvider {
        private CompartmentGroupNameLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof CompartmentGroup) {
                return ((CompartmentGroup)element).getName().replace("Label", "");
            }
            return "";
        }
    }

    private class ModelCompartmentColumnLabelProvider
    extends InheritedColumnLabelProvider {
        ModelCompartmentColumnLabelProvider() {
            super(16, 0);
        }

        @Override
        protected Shell getShell() {
            return ModelCompartmentsPage.this.getShell();
        }

        @Override
        protected boolean isInherited(Object obj) {
            if (obj instanceof Compartment) {
                return ModelCompartmentsPage.this.inherited((Compartment)obj);
            }
            return false;
        }
    }
}

