/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.interventions.impl;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.stem.core.STEMURI;
import org.eclipse.stem.core.common.DublinCore;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.graph.GraphFactory;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.definitions.LocationUtility;
import org.eclipse.stem.definitions.labels.PopulationLabel;
import org.eclipse.stem.definitions.labels.PopulationLabelValue;
import org.eclipse.stem.graphgenerators.impl.GraphGeneratorImpl;
import org.eclipse.stem.interventions.ControlGraphGenerator;
import org.eclipse.stem.interventions.InterventionsFactory;
import org.eclipse.stem.interventions.InterventionsPackage;
import org.eclipse.stem.interventions.StandardInterventionLabel;
import org.eclipse.stem.interventions.StandardInterventionLabelValue;

public class ControlGraphGeneratorImpl
extends GraphGeneratorImpl
implements ControlGraphGenerator {
    public static final String CONTROL_GRAPH_TYPE = "Control Graph";
    public static final String INTERVENTION_LABEL_URI_SEGMENT = "intervention";
    protected static final double VACCINATION_FRACTION_EDEFAULT = 0.0;
    protected double vaccinationFraction = 0.0;
    protected static final double ISOLATION_FRACTION_EDEFAULT = 0.0;
    protected double isolationFraction = 0.0;
    protected static final String POPULATION_IDENTIFIER_EDEFAULT = "human";
    protected String populationIdentifier = "human";
    protected static final URI LOCATION_EDEFAULT = null;
    protected URI location = LOCATION_EDEFAULT;
    private IProject project;

    public IProject getProject() {
        return this.project;
    }

    @Override
    public void setProject(IProject p) {
        this.project = p;
    }

    public Graph getGraph() {
        Graph graph = GraphFactory.eINSTANCE.createGraph();
        DublinCore dc = graph.getDublinCore();
        dc.populate();
        dc.setTitle(CONTROL_GRAPH_TYPE);
        dc.setSource(this.getClass().getSimpleName());
        Calendar c = Calendar.getInstance();
        SimpleDateFormat formatter = new SimpleDateFormat("E yyyy.MM.dd 'at' hh:mm:ss a zzz");
        String valid = formatter.format(c.getTime());
        dc.setValid(valid);
        Set allNodes = LocationUtility.getNodes((IProject)this.project, (URI)this.getLocation());
        Iterator iter = allNodes.iterator();
        while (iter != null && iter.hasNext()) {
            Node n = (Node)iter.next();
            StandardInterventionLabel scl = InterventionsFactory.eINSTANCE.createStandardInterventionLabel();
            scl.setURIOfIdentifiableToBeLabeled(n.getURI());
            scl.setPopulationIdentifier(this.getPopulationIdentifier());
            StandardInterventionLabelValue currentValue = InterventionsFactory.eINSTANCE.createStandardInterventionLabelValue();
            scl.setCurrentValue(currentValue);
            scl.setURI(STEMURI.createURI((String)("intervention/" + n.getURI().lastSegment())));
            double population = 0.0;
            for (NodeLabel lab : n.getLabels()) {
                if (!(lab instanceof PopulationLabel)) continue;
                PopulationLabelValue plv = ((PopulationLabel)lab).getCurrentPopulationValue();
                population = plv.getCount();
                break;
            }
            currentValue.setIsolations(this.getIsolationFraction() * population);
            currentValue.setVaccinations(this.getVaccinationFraction() * population);
            graph.putNodeLabel((NodeLabel)scl);
        }
        assert (graph.sane());
        return graph;
    }

    protected EClass eStaticClass() {
        return InterventionsPackage.Literals.CONTROL_GRAPH_GENERATOR;
    }

    @Override
    public double getVaccinationFraction() {
        return this.vaccinationFraction;
    }

    @Override
    public void setVaccinationFraction(double newVaccinationFraction) {
        double oldVaccinationFraction = this.vaccinationFraction;
        this.vaccinationFraction = newVaccinationFraction;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, oldVaccinationFraction, this.vaccinationFraction));
        }
    }

    @Override
    public double getIsolationFraction() {
        return this.isolationFraction;
    }

    @Override
    public void setIsolationFraction(double newIsolationFraction) {
        double oldIsolationFraction = this.isolationFraction;
        this.isolationFraction = newIsolationFraction;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, oldIsolationFraction, this.isolationFraction));
        }
    }

    @Override
    public String getPopulationIdentifier() {
        return this.populationIdentifier;
    }

    @Override
    public void setPopulationIdentifier(String newPopulationIdentifier) {
        String oldPopulationIdentifier = this.populationIdentifier;
        this.populationIdentifier = newPopulationIdentifier;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldPopulationIdentifier, (Object)this.populationIdentifier));
        }
    }

    @Override
    public URI getLocation() {
        return this.location;
    }

    @Override
    public void setLocation(URI newLocation) {
        URI oldLocation = this.location;
        this.location = newLocation;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, (Object)oldLocation, (Object)this.location));
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 3: {
                return this.getVaccinationFraction();
            }
            case 4: {
                return this.getIsolationFraction();
            }
            case 5: {
                return this.getPopulationIdentifier();
            }
            case 6: {
                return this.getLocation();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 3: {
                this.setVaccinationFraction((Double)newValue);
                return;
            }
            case 4: {
                this.setIsolationFraction((Double)newValue);
                return;
            }
            case 5: {
                this.setPopulationIdentifier((String)newValue);
                return;
            }
            case 6: {
                this.setLocation((URI)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 3: {
                this.setVaccinationFraction(0.0);
                return;
            }
            case 4: {
                this.setIsolationFraction(0.0);
                return;
            }
            case 5: {
                this.setPopulationIdentifier(POPULATION_IDENTIFIER_EDEFAULT);
                return;
            }
            case 6: {
                this.setLocation(LOCATION_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 3: {
                return this.vaccinationFraction != 0.0;
            }
            case 4: {
                return this.isolationFraction != 0.0;
            }
            case 5: {
                return POPULATION_IDENTIFIER_EDEFAULT == null ? this.populationIdentifier != null : !POPULATION_IDENTIFIER_EDEFAULT.equals(this.populationIdentifier);
            }
            case 6: {
                return LOCATION_EDEFAULT == null ? this.location != null : !LOCATION_EDEFAULT.equals((Object)this.location);
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (vaccinationFraction: ");
        result.append(this.vaccinationFraction);
        result.append(", isolationFraction: ");
        result.append(this.isolationFraction);
        result.append(", populationIdentifier: ");
        result.append(this.populationIdentifier);
        result.append(", location: ");
        result.append(this.location);
        result.append(')');
        return result.toString();
    }
}

