/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.access.impl;

import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.common.types.JvmArrayType;
import org.eclipse.xtext.common.types.JvmComponentType;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericArrayTypeReference;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.common.types.access.impl.IClassMirror;
import org.eclipse.xtext.resource.IFragmentProvider;
import org.eclipse.xtext.util.Strings;

public abstract class AbstractClassMirror
implements IClassMirror {
    private static final Logger logger = Logger.getLogger(AbstractClassMirror.class);

    public String getFragment(EObject obj, IFragmentProvider.Fallback fallback) {
        if (obj instanceof JvmTypeParameter) {
            return String.valueOf(this.getFragment(obj.eContainer(), fallback)) + "/" + ((JvmTypeParameter)obj).getName();
        }
        if (obj instanceof JvmTypeReference || obj instanceof JvmFormalParameter) {
            return fallback.getFragment(obj);
        }
        if (obj instanceof JvmIdentifiableElement) {
            if (obj instanceof JvmArrayType && obj.eContainer() instanceof JvmGenericArrayTypeReference) {
                return fallback.getFragment(obj);
            }
            return ((JvmIdentifiableElement)obj).getIdentifier();
        }
        return fallback.getFragment(obj);
    }

    public EObject getEObject(Resource resource, String fragment, IFragmentProvider.Fallback fallback) {
        if (fragment.endsWith("[]")) {
            return this.getArrayEObject(resource, fragment, fallback);
        }
        int slash = fragment.indexOf(47);
        if (slash != -1) {
            if (slash == 0) {
                return fallback.getEObject(fragment);
            }
            String containerFragment = fragment.substring(0, slash);
            EObject container = this.getEObject(resource, containerFragment, fallback);
            if (container != null) {
                String parameterName = fragment.substring(slash + 1);
                if (container instanceof JvmTypeParameterDeclarator) {
                    JvmTypeParameterDeclarator executable = (JvmTypeParameterDeclarator)container;
                    for (JvmTypeParameter parameter : executable.getTypeParameters()) {
                        if (!parameter.getName().equals(parameterName)) continue;
                        return parameter;
                    }
                }
            }
        } else {
            EObject member;
            if (this.getTypeName().equals(fragment)) {
                if (resource.getContents().isEmpty()) {
                    logger.error((Object)("resource is empty: " + resource.getURI()));
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)this.getClass().getName(), (Throwable)new Exception());
                    }
                    return null;
                }
                return (EObject)resource.getContents().get(0);
            }
            if (fragment.startsWith(this.getTypeName()) && (member = this.findMember((EObject)resource.getContents().get(0), fragment)) != null) {
                return member;
            }
        }
        return fallback.getEObject(fragment);
    }

    protected EObject findMember(EObject container, String fragment) {
        if (container instanceof JvmDeclaredType) {
            EList<JvmMember> members = ((JvmDeclaredType)container).getMembers();
            for (JvmMember member : members) {
                EObject match;
                String name = member.getIdentifier();
                if (Strings.equal((String)fragment, (String)name)) {
                    return member;
                }
                if (!fragment.startsWith(name) || (match = this.findMember(member, fragment)) == null) continue;
                return match;
            }
        }
        return null;
    }

    protected EObject getArrayEObject(Resource resource, String fragment, IFragmentProvider.Fallback fallback) {
        JvmComponentType component = (JvmComponentType)this.getEObject(resource, fragment.substring(0, fragment.length() - 2), fallback);
        if (component == null) {
            return null;
        }
        if (component.getArrayType() == null) {
            JvmArrayType arrayType = TypesFactory.eINSTANCE.createJvmArrayType();
            arrayType.setComponentType(component);
        }
        return component.getArrayType();
    }

    protected abstract String getTypeName();
}

