/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.model.ui.editor;

import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.stem.model.common.MetamodelUtils;
import org.eclipse.stem.model.metamodel.Compartment;
import org.eclipse.stem.model.metamodel.Model;
import org.eclipse.stem.model.metamodel.Package;
import org.eclipse.stem.model.metamodel.Transition;
import org.eclipse.stem.model.ui.editor.VisualModelUtils;
import org.eclipse.stem.model.ui.editor.vismodel.CanvasPackage;
import org.eclipse.stem.model.ui.editor.vismodel.CompartmentElement;
import org.eclipse.stem.model.ui.editor.vismodel.ModelElement;
import org.eclipse.stem.model.ui.editor.vismodel.TransitionElement;
import org.eclipse.stem.model.ui.editor.vismodel.VisualMetamodelFactory;

public class VisualModelReconciler {
    static final VisualMetamodelFactory FACTORY = VisualMetamodelFactory.eINSTANCE;
    public static int DEFAULT_X_MARGIN = 5;
    public static int DEFAULT_Y_MARGIN = 5;
    public static int DEFAULT_WIDTH = 75;
    public static int DEFAULT_HEIGHT = 75;
    public static int DEFAULT_X_SPACING = DEFAULT_WIDTH + 30;
    public static int DEFAULT_Y_SPACING = 0;
    private Package metamodel;
    private CanvasPackage vismodel;
    private boolean vismodelChanged = false;

    public VisualModelReconciler(Package metamodel, CanvasPackage vismodel) {
        this.metamodel = metamodel;
        this.vismodel = vismodel;
    }

    private void flagVismodelChange() {
        this.vismodelChanged = true;
    }

    public boolean isVismodelChanged() {
        return this.vismodelChanged;
    }

    public void reconcile() {
        this.reconcileMetamodel();
        this.reconcileVismodel();
    }

    private ModelElement findElementForModel(Model m) {
        for (ModelElement me : this.vismodel.getModelElements()) {
            if (me.getModel() != m) continue;
            return me;
        }
        return null;
    }

    private CompartmentElement findElementForCompartment(ModelElement me, Compartment c) {
        for (CompartmentElement ce : me.getCompartmentElements()) {
            if (ce.getCompartment() != c) continue;
            return ce;
        }
        return null;
    }

    private TransitionElement findElementForTransition(ModelElement me, Transition t) {
        for (TransitionElement te : me.getTransitionElements()) {
            if (te.getTransition() != t) continue;
            return te;
        }
        return null;
    }

    private void reconcileVismodel() {
        Iterator iter = this.vismodel.getModelElements().iterator();
        while (iter.hasNext()) {
            ModelElement me = (ModelElement)iter.next();
            if (me.getModel() != null) {
                this.reconcileModelElement(me);
                continue;
            }
            iter.remove();
            this.flagVismodelChange();
        }
    }

    private void reconcileModelElement(ModelElement me) {
        this.reconcileCompartmentElements(me);
        this.reconcileTransitionElements(me);
    }

    private void reconcileCompartmentElements(ModelElement me) {
        Iterator iter = me.getCompartmentElements().iterator();
        while (iter.hasNext()) {
            CompartmentElement ce = (CompartmentElement)iter.next();
            if (ce.getCompartment() != null && !ce.getCompartment().eIsProxy()) continue;
            iter.remove();
            this.flagVismodelChange();
        }
    }

    private void reconcileTransitionElements(ModelElement me) {
        Iterator iter = me.getTransitionElements().iterator();
        while (iter.hasNext()) {
            TransitionElement te = (TransitionElement)iter.next();
            if (te.getTransition() != null) continue;
            iter.remove();
            this.flagVismodelChange();
        }
    }

    private void reconcileMetamodel() {
        for (Model m : this.metamodel.getModels()) {
            this.reconcileModel(m);
        }
    }

    private void reconcileModel(Model m) {
        ModelElement me = this.findElementForModel(m);
        if (me == null) {
            me = VisualModelReconciler.initializeModelElement(m);
            this.vismodel.getModelElements().add((Object)me);
            this.flagVismodelChange();
        }
        this.reconcileCompartments(me, m);
        this.reconcileTransitions(me, m);
    }

    private void reconcileCompartments(ModelElement me, Model m) {
        int x = DEFAULT_X_MARGIN;
        int y = DEFAULT_Y_MARGIN;
        List compartments = MetamodelUtils.getAllCompartmentsForModel((Model)m);
        for (Compartment compartment : compartments) {
            CompartmentElement ce = this.findElementForCompartment(me, compartment);
            if (ce != null) continue;
            ce = VisualModelReconciler.createCompartmentElement(me, compartment, x, y);
            me.getCompartmentElements().add((Object)ce);
            this.flagVismodelChange();
            x += DEFAULT_X_SPACING;
            y += DEFAULT_Y_SPACING;
        }
    }

    private void reconcileTransitions(ModelElement me, Model m) {
        for (Transition transition : m.getTransitions()) {
            TransitionElement te = this.findElementForTransition(me, transition);
            if (te != null) continue;
            te = VisualModelReconciler.createTransitionElement(me, transition);
            me.getTransitionElements().add((Object)te);
            this.flagVismodelChange();
        }
    }

    public static CanvasPackage initializeForMetamodel(Package metamodel) {
        CanvasPackage canvasPackage = FACTORY.createCanvasPackage();
        canvasPackage.setMetamodel(metamodel);
        for (Model model : metamodel.getModels()) {
            canvasPackage.getModelElements().add((Object)VisualModelReconciler.initializeModelElement(model));
        }
        return canvasPackage;
    }

    public static ModelElement initializeModelElement(Model model) {
        ModelElement me = FACTORY.createModelElement();
        me.setModel(model);
        VisualModelReconciler.initializeCompartments(me);
        VisualModelReconciler.initializeTransitions(me);
        return me;
    }

    private static void initializeCompartments(ModelElement me) {
        int x = DEFAULT_X_MARGIN;
        int y = DEFAULT_Y_MARGIN;
        List compartments = MetamodelUtils.getAllCompartmentsForModel((Model)me.getModel());
        for (Compartment compartment : compartments) {
            CompartmentElement ce = VisualModelReconciler.createCompartmentElement(me, compartment, x, y);
            me.getCompartmentElements().add((Object)ce);
            x += DEFAULT_X_SPACING;
            y += DEFAULT_Y_SPACING;
        }
    }

    private static void initializeTransitions(ModelElement me) {
        EList transitions = me.getModel().getTransitions();
        for (Transition transition : transitions) {
            me.getTransitionElements().add((Object)VisualModelReconciler.createTransitionElement(me, transition));
        }
    }

    private static CompartmentElement createCompartmentElement(ModelElement me, Compartment compartment, int x, int y) {
        CompartmentElement ce = FACTORY.createCompartmentElement();
        ce.setCompartment(compartment);
        ce.setWidth(DEFAULT_WIDTH);
        ce.setHeight(DEFAULT_HEIGHT);
        ce.setX(x);
        ce.setY(y);
        return ce;
    }

    private static TransitionElement createTransitionElement(ModelElement me, Transition transition) {
        TransitionElement te = FACTORY.createTransitionElement();
        te.setTransition(transition);
        te.setSource(VisualModelUtils.findCompartmentElementForCompartment(transition.getSource(), me));
        te.setTarget(VisualModelUtils.findCompartmentElementForCompartment(transition.getTarget(), me));
        if (te.getSource() == null || te.getTarget() == null) {
            System.err.println("Could not find compartment element for source or target in transition " + me.getModel().getName() + "/" + transition.getName());
            return null;
        }
        return te;
    }
}

