/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typing;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.JvmArrayType;
import org.eclipse.xtext.common.types.JvmGenericArrayTypeReference;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.common.types.JvmWildcardTypeReference;
import org.eclipse.xtext.common.types.util.Primitives;
import org.eclipse.xtext.common.types.util.TypeReferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class SynonymTypesProvider {
    @Inject
    private Primitives primitives;
    @Inject
    private TypeReferences typeRefs;

    public Set<JvmTypeReference> getSynonymTypes(JvmTypeReference type, boolean ignoreBoxing) {
        if (type == null || this.typeRefs.is(type, Void.class) || this.typeRefs.is(type, Void.TYPE)) {
            return Collections.emptySet();
        }
        if (!ignoreBoxing && this.primitives.isPrimitive(type)) {
            return this.singletonOrEmpty(this.primitives.asWrapperTypeIfPrimitive(type));
        }
        if (!ignoreBoxing && this.primitives.isWrapperType(type)) {
            return this.singletonOrEmpty(this.primitives.asPrimitiveIfWrapperType(type));
        }
        if (this.typeRefs.isArray(type)) {
            if (type instanceof JvmGenericArrayTypeReference) {
                JvmTypeReference componentType = ((JvmGenericArrayTypeReference)type).getComponentType();
                JvmTypeReference typeArg = this.primitives.asWrapperTypeIfPrimitive(componentType);
                JvmTypeReference iterable = this.typeRefs.getTypeForName(List.class, (Notifier)this.findContext(type.getType()), new JvmTypeReference[]{typeArg});
                return this.singletonOrEmpty(iterable);
            }
            JvmArrayType array = (JvmArrayType)type.getType();
            JvmTypeReference typeArg = this.primitives.asWrapperTypeIfPrimitive((JvmTypeReference)this.typeRefs.createTypeRef((JvmType)array.getComponentType(), new JvmTypeReference[0]));
            JvmTypeReference iterable = this.typeRefs.getTypeForName(List.class, (Notifier)this.findContext((JvmType)array), new JvmTypeReference[]{typeArg});
            return this.singletonOrEmpty(iterable);
        }
        if (this.isList(type)) {
            JvmTypeReference jvmTypeReference;
            EList arguments;
            JvmTypeReference componentType = null;
            if (type instanceof JvmParameterizedTypeReference && (arguments = ((JvmParameterizedTypeReference)type).getArguments()).size() == 1 && (componentType = (jvmTypeReference = (JvmTypeReference)arguments.get(0))) instanceof JvmWildcardTypeReference) {
                EList list = ((JvmWildcardTypeReference)componentType).getConstraints();
                componentType = this.typeRefs.getTypeForName(Object.class, (Notifier)this.findContext(type.getType()), new JvmTypeReference[0]);
                for (JvmTypeConstraint constraint : list) {
                    if (!(constraint instanceof JvmUpperBound)) continue;
                    componentType = constraint.getTypeReference();
                }
            }
            if (componentType == null) {
                componentType = this.typeRefs.getTypeForName(Object.class, (Notifier)type.getType(), new JvmTypeReference[0]);
            }
            if (componentType != null) {
                if (this.primitives.isPrimitive(componentType)) {
                    JvmGenericArrayTypeReference primitive = this.typeRefs.createArrayType(componentType);
                    JvmGenericArrayTypeReference wrapper = this.typeRefs.createArrayType(this.primitives.asWrapperTypeIfPrimitive(componentType));
                    return ImmutableSet.of((Object)primitive, (Object)wrapper);
                }
                if (this.primitives.isWrapperType(componentType)) {
                    JvmGenericArrayTypeReference wrapper = this.typeRefs.createArrayType(componentType);
                    JvmGenericArrayTypeReference primitive = this.typeRefs.createArrayType(this.primitives.asPrimitiveIfWrapperType(componentType));
                    return ImmutableSet.of((Object)wrapper, (Object)primitive);
                }
                JvmGenericArrayTypeReference result = this.typeRefs.createArrayType(componentType);
                return this.singletonOrEmpty((JvmTypeReference)result);
            }
        }
        return Collections.emptySet();
    }

    private Set<JvmTypeReference> singletonOrEmpty(JvmTypeReference reference) {
        if (reference == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(reference);
    }

    protected boolean isList(JvmTypeReference type) {
        return this.typeRefs.isInstanceOf(type, Iterable.class);
    }

    protected EObject findContext(JvmType type) {
        return type;
    }

    public boolean hasSynonymTypes(JvmTypeReference toBeConverted) {
        Set<JvmTypeReference> synonymTypes = this.getSynonymTypes(toBeConverted, false);
        return !synonymTypes.isEmpty();
    }
}

