/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.scoping.batch;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.scoping.batch.AbstractStaticImportsScope;
import org.eclipse.xtext.xbase.scoping.batch.BucketedEObjectDescription;
import org.eclipse.xtext.xbase.scoping.batch.IFeatureScopeSession;
import org.eclipse.xtext.xbase.scoping.batch.TypeBucket;
import org.eclipse.xtext.xbase.scoping.featurecalls.OperatorMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticExtensionImportsScope
extends AbstractStaticImportsScope {
    private final OperatorMapping operatorMapping;
    private final XExpression receiver;
    private final JvmTypeReference receiverType;

    public StaticExtensionImportsScope(IScope parent, IFeatureScopeSession session, XExpression receiver, JvmTypeReference receiverType, XAbstractFeatureCall context, OperatorMapping operatorMapping) {
        super(parent, session, context);
        this.receiver = receiver;
        this.receiverType = receiverType;
        this.operatorMapping = operatorMapping;
    }

    @Override
    protected List<TypeBucket> getBuckets() {
        return this.getSession().getStaticallyImportedExtensionTypes();
    }

    @Override
    protected String getFeatureName(QualifiedName name) {
        QualifiedName methodName = this.operatorMapping.getMethodName(name);
        String simpleName = methodName == null ? name.toString() : methodName.toString();
        return simpleName;
    }

    @Override
    protected BucketedEObjectDescription createNamedDescription(QualifiedName name, JvmFeature feature, TypeBucket bucket) {
        return new BucketedEObjectDescription(name, (EObject)feature, this.receiver, this.receiverType, bucket.getId());
    }

    @Override
    protected void addDescriptions(JvmFeature feature, TypeBucket bucket, List<IEObjectDescription> result) {
        QualifiedName featureName = QualifiedName.create((String)feature.getSimpleName());
        result.add((IEObjectDescription)new BucketedEObjectDescription(featureName, (EObject)feature, this.receiver, this.receiverType, bucket.getId()));
        QualifiedName operator = this.operatorMapping.getOperator(featureName);
        if (operator != null) {
            result.add((IEObjectDescription)new BucketedEObjectDescription(operator, (EObject)feature, this.receiver, this.receiverType, bucket.getId()));
        }
    }
}

