/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.impl;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.resource.LinkingAssumptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class FeatureCallToJavaMapping {
    @Inject
    private LinkingAssumptions linkingAssumptions;

    protected boolean isStaticJavaFeature(JvmIdentifiableElement feature) {
        if (feature instanceof JvmOperation) {
            return ((JvmOperation)feature).isStatic();
        }
        return false;
    }

    public XExpression getActualReceiver(XAbstractFeatureCall call) {
        return this.getActualReceiver(call, this.getFeature(call), this.getImplicitReceiver(call));
    }

    public XExpression getActualReceiver(XAbstractFeatureCall featureCall, JvmIdentifiableElement feature, XExpression implicitReceiver) {
        if (this.isStaticJavaFeature(feature) || feature instanceof JvmConstructor) {
            return null;
        }
        if (implicitReceiver != null) {
            return implicitReceiver;
        }
        EList<XExpression> allArguments = featureCall.getExplicitArguments();
        if (allArguments.isEmpty()) {
            return null;
        }
        return (XExpression)allArguments.get(0);
    }

    protected JvmIdentifiableElement getFeature(XAbstractFeatureCall expr) {
        return this.linkingAssumptions.getFeature(expr, true);
    }

    protected XExpression getImplicitReceiver(XAbstractFeatureCall expr) {
        return this.linkingAssumptions.getImplicitReceiver(expr);
    }

    protected XExpression getImplicitFirstArgument(XAbstractFeatureCall expr) {
        return this.linkingAssumptions.getImplicitFirstArgument(expr);
    }

    public List<XExpression> getActualArguments(XAbstractFeatureCall featureCall) {
        return this.getActualArguments(featureCall, this.getFeature(featureCall), this.getImplicitReceiver(featureCall), this.getImplicitFirstArgument(featureCall));
    }

    public List<XExpression> getActualArguments(XAbstractFeatureCall featureCall, JvmIdentifiableElement feature, XExpression implicitReceiver, XExpression implicitFirstArgument) {
        EList<XExpression> explicitArguments = featureCall.getExplicitArguments();
        if (this.isStaticJavaFeature(feature)) {
            if (implicitReceiver == null || explicitArguments.contains(implicitReceiver)) {
                return Lists.newArrayList(explicitArguments);
            }
            ArrayList result = Lists.newArrayList((Object[])new XExpression[]{implicitReceiver});
            result.addAll(explicitArguments);
            return result;
        }
        if (implicitReceiver != null) {
            if (implicitFirstArgument != null) {
                ArrayList result = Lists.newArrayList((Object[])new XExpression[]{implicitFirstArgument});
                result.addAll(explicitArguments);
                return result;
            }
            return Lists.newArrayList(explicitArguments);
        }
        if (feature instanceof JvmConstructor) {
            return explicitArguments;
        }
        if (explicitArguments.size() <= 1) {
            return Collections.emptyList();
        }
        return Lists.newArrayList(explicitArguments.subList(1, explicitArguments.size()));
    }

    public boolean isTargetsMemberSyntaxCall(XAbstractFeatureCall featureCall, JvmIdentifiableElement feature, XExpression implicitReceiver) {
        return !this.isStaticJavaFeature(feature);
    }
}

