/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.compiler;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.common.types.util.ITypeArgumentContext;
import org.eclipse.xtext.common.types.util.TypeArgumentContextProvider;
import org.eclipse.xtext.generator.trace.ILocationData;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.util.Tuples;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.XCasePart;
import org.eclipse.xtext.xbase.XCastedExpression;
import org.eclipse.xtext.xbase.XCatchClause;
import org.eclipse.xtext.xbase.XClosure;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XDoWhileExpression;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XForLoopExpression;
import org.eclipse.xtext.xbase.XIfExpression;
import org.eclipse.xtext.xbase.XInstanceOfExpression;
import org.eclipse.xtext.xbase.XReturnExpression;
import org.eclipse.xtext.xbase.XSwitchExpression;
import org.eclipse.xtext.xbase.XThrowExpression;
import org.eclipse.xtext.xbase.XTryCatchFinallyExpression;
import org.eclipse.xtext.xbase.XVariableDeclaration;
import org.eclipse.xtext.xbase.XWhileExpression;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.compiler.FeatureCallCompiler;
import org.eclipse.xtext.xbase.compiler.Later;
import org.eclipse.xtext.xbase.compiler.output.ITreeAppendable;
import org.eclipse.xtext.xbase.controlflow.IEarlyExitComputer;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.typing.Closures;

@NonNullByDefault
public class XbaseCompiler
extends FeatureCallCompiler {
    @Inject
    private IEarlyExitComputer earlyExitComputer;
    @Inject
    private Closures closures;
    @Inject
    private TypeArgumentContextProvider ctxProvider;

    protected void internalToConvertedExpression(XExpression obj, ITreeAppendable appendable) {
        if (obj instanceof XBlockExpression) {
            this._toJavaExpression((XBlockExpression)obj, appendable);
        } else if (obj instanceof XCastedExpression) {
            this._toJavaExpression((XCastedExpression)obj, appendable);
        } else if (obj instanceof XClosure) {
            this._toJavaExpression((XClosure)obj, appendable);
        } else if (obj instanceof XConstructorCall) {
            this._toJavaExpression((XConstructorCall)obj, appendable);
        } else if (obj instanceof XIfExpression) {
            this._toJavaExpression((XIfExpression)obj, appendable);
        } else if (obj instanceof XInstanceOfExpression) {
            this._toJavaExpression((XInstanceOfExpression)obj, appendable);
        } else if (obj instanceof XSwitchExpression) {
            this._toJavaExpression((XSwitchExpression)obj, appendable);
        } else if (obj instanceof XTryCatchFinallyExpression) {
            this._toJavaExpression((XTryCatchFinallyExpression)obj, appendable);
        } else {
            super.internalToConvertedExpression(obj, appendable);
        }
    }

    protected void doInternalToJavaStatement(XExpression obj, ITreeAppendable appendable, boolean isReferenced) {
        if (obj instanceof XBlockExpression) {
            this._toJavaStatement((XBlockExpression)obj, appendable, isReferenced);
        } else if (obj instanceof XCastedExpression) {
            this._toJavaStatement((XCastedExpression)obj, appendable, isReferenced);
        } else if (obj instanceof XClosure) {
            this._toJavaStatement((XClosure)obj, appendable, isReferenced);
        } else if (obj instanceof XConstructorCall) {
            this._toJavaStatement((XConstructorCall)obj, appendable, isReferenced);
        } else if (obj instanceof XDoWhileExpression) {
            this._toJavaStatement((XDoWhileExpression)obj, appendable, isReferenced);
        } else if (obj instanceof XForLoopExpression) {
            this._toJavaStatement((XForLoopExpression)obj, appendable, isReferenced);
        } else if (obj instanceof XIfExpression) {
            this._toJavaStatement((XIfExpression)obj, appendable, isReferenced);
        } else if (obj instanceof XInstanceOfExpression) {
            this._toJavaStatement((XInstanceOfExpression)obj, appendable, isReferenced);
        } else if (obj instanceof XReturnExpression) {
            this._toJavaStatement((XReturnExpression)obj, appendable, isReferenced);
        } else if (obj instanceof XSwitchExpression) {
            this._toJavaStatement((XSwitchExpression)obj, appendable, isReferenced);
        } else if (obj instanceof XThrowExpression) {
            this._toJavaStatement((XThrowExpression)obj, appendable, isReferenced);
        } else if (obj instanceof XTryCatchFinallyExpression) {
            this._toJavaStatement((XTryCatchFinallyExpression)obj, appendable, isReferenced);
        } else if (obj instanceof XVariableDeclaration) {
            this._toJavaStatement((XVariableDeclaration)obj, appendable, isReferenced);
        } else if (obj instanceof XWhileExpression) {
            this._toJavaStatement((XWhileExpression)obj, appendable, isReferenced);
        } else {
            super.doInternalToJavaStatement(obj, appendable, isReferenced);
        }
    }

    protected void _toJavaStatement(XBlockExpression expr, ITreeAppendable b, boolean isReferenced) {
        boolean needsBraces;
        b = b.trace(expr, false);
        if (expr.getExpressions().isEmpty()) {
            return;
        }
        if (expr.getExpressions().size() == 1) {
            this.internalToJavaStatement((XExpression)expr.getExpressions().get(0), b, isReferenced);
            return;
        }
        if (isReferenced) {
            this.declareSyntheticVariable(expr, b);
        }
        boolean bl = needsBraces = isReferenced || !this.bracesAreAddedByOuterStructure(expr);
        if (needsBraces) {
            b.newLine().append("{").increaseIndentation();
            b.openPseudoScope();
        }
        EList<XExpression> expressions = expr.getExpressions();
        int i = 0;
        while (i < expressions.size()) {
            XExpression ex = (XExpression)expressions.get(i);
            if (i < expressions.size() - 1) {
                this.internalToJavaStatement(ex, b, false);
            } else {
                this.internalToJavaStatement(ex, b, isReferenced);
                if (isReferenced) {
                    b.newLine().append(this.getVarName(expr, b)).append(" = (");
                    this.internalToConvertedExpression(ex, b, null);
                    b.append(");");
                }
            }
            ++i;
        }
        if (needsBraces) {
            b.closeScope();
            b.decreaseIndentation().newLine().append("}");
        }
    }

    protected boolean bracesAreAddedByOuterStructure(XBlockExpression block) {
        EObject container = block.eContainer();
        if (container instanceof XTryCatchFinallyExpression || container instanceof XIfExpression || container instanceof XClosure) {
            return true;
        }
        return !(container instanceof XExpression);
    }

    protected void _toJavaExpression(XBlockExpression expr, ITreeAppendable b) {
        if (expr.getExpressions().isEmpty()) {
            b.append("null");
            return;
        }
        if (expr.getExpressions().size() == 1) {
            this.internalToConvertedExpression((XExpression)expr.getExpressions().get(0), b, null);
            return;
        }
        b = b.trace(expr, false);
        b.append(this.getVarName(expr, b));
    }

    protected void _toJavaStatement(XTryCatchFinallyExpression expr, ITreeAppendable outerAppendable, boolean isReferenced) {
        ITreeAppendable b = outerAppendable.trace(expr, false);
        if (isReferenced && !this.isPrimitiveVoid(expr)) {
            this.declareSyntheticVariable(expr, b);
        }
        b.newLine().append("try {").increaseIndentation();
        boolean canBeReferenced = isReferenced && !this.isPrimitiveVoid(expr.getExpression());
        this.internalToJavaStatement(expr.getExpression(), b, canBeReferenced);
        if (canBeReferenced) {
            b.newLine().append(this.getVarName(expr, b)).append(" = ");
            this.internalToConvertedExpression(expr.getExpression(), b, null);
            b.append(";");
        }
        b.decreaseIndentation().newLine().append("}");
        this.appendCatchAndFinally(expr, b, isReferenced);
    }

    protected void appendCatchAndFinally(XTryCatchFinallyExpression expr, ITreeAppendable b, boolean isReferenced) {
        XExpression finallyExp;
        EList<XCatchClause> catchClauses = expr.getCatchClauses();
        if (!catchClauses.isEmpty()) {
            String variable = b.declareSyntheticVariable(Tuples.pair((Object)expr, (Object)"_catchedThrowable"), "_t");
            b.append(" catch (final Throwable ").append(variable).append(") ");
            b.append("{").increaseIndentation();
            b.newLine();
            Iterator iterator = catchClauses.iterator();
            while (iterator.hasNext()) {
                XCatchClause catchClause = (XCatchClause)iterator.next();
                ITreeAppendable catchClauseAppendable = b.trace(catchClause);
                JvmTypeReference type = catchClause.getDeclaredParam().getParameterType();
                String declaredParamName = this.makeJavaIdentifier(catchClause.getDeclaredParam().getName());
                String name = catchClauseAppendable.declareVariable(catchClause.getDeclaredParam(), declaredParamName);
                catchClauseAppendable.append("if (").append(variable).append(" instanceof ");
                this.serialize(type, expr, catchClauseAppendable);
                catchClauseAppendable.append(") ").append("{");
                catchClauseAppendable.increaseIndentation();
                ITreeAppendable withDebugging = catchClauseAppendable.trace(catchClause, true);
                ITreeAppendable parameterAppendable = withDebugging.trace((EObject)catchClause.getDeclaredParam());
                parameterAppendable.newLine().append("final ");
                this.serialize(type, expr, parameterAppendable);
                parameterAppendable.append(" ");
                parameterAppendable.trace((EObject)catchClause.getDeclaredParam(), (EStructuralFeature)TypesPackage.Literals.JVM_FORMAL_PARAMETER__NAME, 0).append(name);
                withDebugging.append(" = (");
                this.serialize(type, expr, withDebugging);
                withDebugging.append(")").append(variable).append(";");
                boolean canBeReferenced = isReferenced && !this.isPrimitiveVoid(catchClause.getExpression());
                this.internalToJavaStatement(catchClause.getExpression(), withDebugging, canBeReferenced);
                if (canBeReferenced) {
                    catchClauseAppendable.newLine().append(this.getVarName(expr, catchClauseAppendable)).append(" = ");
                    this.internalToConvertedExpression(catchClause.getExpression(), catchClauseAppendable, null);
                    catchClauseAppendable.append(";");
                }
                catchClauseAppendable.decreaseIndentation();
                catchClauseAppendable.newLine().append("}");
                if (!iterator.hasNext()) continue;
                b.append(" else ");
            }
            b.append(" else {");
            b.increaseIndentation();
            JvmType sneakyThrowType = this.getTypeReferences().findDeclaredType(Exceptions.class, (Notifier)expr);
            if (sneakyThrowType == null) {
                b.append("COMPILE ERROR : '" + Exceptions.class.getCanonicalName() + "' could not be found on the classpath!");
            } else {
                b.newLine().append("throw ");
                b.append(sneakyThrowType);
                b.append(".sneakyThrow(");
                b.append(variable);
                b.append(");");
            }
            b.decreaseIndentation();
            b.newLine().append("}");
            b.decreaseIndentation();
            b.newLine().append("}");
        }
        if ((finallyExp = expr.getFinallyExpression()) != null) {
            b.append(" finally {").increaseIndentation();
            this.internalToJavaStatement(finallyExp, b, false);
            b.decreaseIndentation().newLine().append("}");
        }
    }

    protected void _toJavaExpression(XTryCatchFinallyExpression expr, ITreeAppendable b) {
        b.trace(expr, false).append(this.getVarName(expr, b));
    }

    protected void _toJavaStatement(XThrowExpression expr, ITreeAppendable b, boolean isReferenced) {
        this.internalToJavaStatement(expr.getExpression(), b, true);
        b.newLine().append("throw ");
        this.internalToJavaExpression(expr.getExpression(), b);
        b.append(";");
    }

    protected void _toJavaExpression(XInstanceOfExpression expr, ITreeAppendable b) {
        b.append("(");
        this.internalToJavaExpression(expr.getExpression(), b);
        b.append(" instanceof ");
        this.serialize(expr.getType(), expr, b);
        b.append(")");
    }

    protected void _toJavaStatement(XInstanceOfExpression expr, ITreeAppendable b, boolean isReferenced) {
        this.internalToJavaStatement(expr.getExpression(), b, true);
    }

    protected void _toJavaStatement(XVariableDeclaration varDeclaration, ITreeAppendable b, boolean isReferenced) {
        if (varDeclaration.getRight() != null) {
            this.internalToJavaStatement(varDeclaration.getRight(), b, true);
        }
        b.newLine();
        if (!varDeclaration.isWriteable()) {
            b.append("final ");
        }
        JvmTypeReference type = null;
        type = varDeclaration.getType() != null ? varDeclaration.getType() : this.getTypeProvider().getType(varDeclaration.getRight());
        this.serialize(type, varDeclaration, b);
        b.append(" ");
        b.append(b.declareVariable(varDeclaration, this.makeJavaIdentifier(varDeclaration.getName())));
        b.append(" = ");
        if (varDeclaration.getRight() != null) {
            this.internalToConvertedExpression(varDeclaration.getRight(), b, type);
        } else {
            this.appendDefaultLiteral(b, type);
        }
        b.append(";");
    }

    protected void _toJavaStatement(XWhileExpression expr, ITreeAppendable b, boolean isReferenced) {
        this.internalToJavaStatement(expr.getPredicate(), b, true);
        String varName = b.declareSyntheticVariable(expr, "_while");
        b.newLine().append("boolean ").append(varName).append(" = ");
        this.internalToJavaExpression(expr.getPredicate(), b);
        b.append(";");
        b.newLine().append("while (");
        b.append(varName);
        b.append(") {").increaseIndentation();
        b.openPseudoScope();
        this.internalToJavaStatement(expr.getBody(), b, false);
        this.internalToJavaStatement(expr.getPredicate(), b, true);
        b.newLine();
        if (!this.earlyExitComputer.isEarlyExit(expr.getBody())) {
            b.append(varName).append(" = ");
            this.internalToJavaExpression(expr.getPredicate(), b);
            b.append(";");
        }
        b.closeScope();
        b.decreaseIndentation().newLine().append("}");
    }

    protected void _toJavaStatement(XDoWhileExpression expr, ITreeAppendable b, boolean isReferenced) {
        String variable = b.declareSyntheticVariable(expr, "_dowhile");
        b.newLine().append("boolean ").append(variable).append(" = false;");
        b.newLine().append("do {").increaseIndentation();
        this.internalToJavaStatement(expr.getBody(), b, false);
        this.internalToJavaStatement(expr.getPredicate(), b, true);
        b.newLine();
        if (!this.earlyExitComputer.isEarlyExit(expr.getBody())) {
            b.append(variable).append(" = ");
            this.internalToJavaExpression(expr.getPredicate(), b);
            b.append(";");
        }
        b.decreaseIndentation().newLine().append("} while(");
        b.append(variable);
        b.append(");");
    }

    protected void _toJavaStatement(XForLoopExpression expr, ITreeAppendable b, boolean isReferenced) {
        this.internalToJavaStatement(expr.getForExpression(), b, true);
        b.newLine();
        ITreeAppendable loopAppendable = b.trace(expr);
        loopAppendable.append("for (");
        ITreeAppendable parameterAppendable = loopAppendable.trace((EObject)expr.getDeclaredParam());
        parameterAppendable.append("final ");
        JvmTypeReference paramType = this.getTypeProvider().getTypeForIdentifiable((JvmIdentifiableElement)expr.getDeclaredParam());
        this.serialize(paramType, expr, parameterAppendable);
        parameterAppendable.append(" ");
        String name = this.makeJavaIdentifier(expr.getDeclaredParam().getName());
        String varName = loopAppendable.declareVariable(expr.getDeclaredParam(), name);
        parameterAppendable.trace((EObject)expr.getDeclaredParam(), (EStructuralFeature)TypesPackage.Literals.JVM_FORMAL_PARAMETER__NAME, 0).append(varName);
        loopAppendable.append(" : ");
        this.internalToJavaExpression(expr.getForExpression(), loopAppendable);
        loopAppendable.append(") {").increaseIndentation();
        this.internalToJavaStatement(expr.getEachExpression(), loopAppendable, false);
        loopAppendable.decreaseIndentation().newLine().append("}");
    }

    protected void _toJavaStatement(final XConstructorCall expr, ITreeAppendable b, boolean isReferenced) {
        for (XExpression arg : expr.getArguments()) {
            this.internalToJavaStatement(arg, b, true);
        }
        Later later = new Later(){

            public void exec(ITreeAppendable constructorCallAppendable) {
                ILocationData locationWithNewKeyword = XbaseCompiler.this.getLocationWithNewKeyword(expr);
                ITreeAppendable appendableWithNewKeyword = locationWithNewKeyword != null ? constructorCallAppendable.trace(locationWithNewKeyword) : constructorCallAppendable;
                appendableWithNewKeyword.append("new ");
                JvmTypeReference producedType = XbaseCompiler.this.getTypeProvider().getType(expr);
                XbaseCompiler.this.serialize(producedType, expr, appendableWithNewKeyword.trace(expr, (EStructuralFeature)XbasePackage.Literals.XCONSTRUCTOR_CALL__CONSTRUCTOR, 0), false, false, true, false);
                constructorCallAppendable.append("(");
                XbaseCompiler.this.appendArguments((List<? extends XExpression>)expr.getArguments(), constructorCallAppendable);
                constructorCallAppendable.append(")");
            }
        };
        if (isReferenced) {
            this.declareFreshLocalVariable(expr, b, later);
        } else {
            b.newLine();
            later.exec(b);
            b.append(";");
        }
    }

    @Nullable
    protected ILocationData getLocationWithNewKeyword(XConstructorCall call) {
        ICompositeNode startNode = NodeModelUtils.getNode((EObject)call);
        if (startNode != null) {
            ArrayList resultNodes = Lists.newArrayList();
            for (INode child : startNode.getChildren()) {
                if (child.getGrammarElement() instanceof Keyword && "(".equals(child.getText())) break;
                resultNodes.add(child);
            }
            return this.toLocationData(resultNodes);
        }
        return null;
    }

    protected void _toJavaExpression(XConstructorCall expr, ITreeAppendable b) {
        String varName = this.getVarName(expr, b);
        b.trace(expr, false).append(varName);
    }

    protected void _toJavaStatement(XReturnExpression expr, ITreeAppendable b, boolean isReferenced) {
        if (expr.getExpression() != null) {
            JvmIdentifiableElement logicalContainer = this.getLogicalContainerProvider().getNearestLogicalContainer(expr);
            boolean needsSneakyThrow = false;
            if (logicalContainer instanceof JvmExecutable) {
                EList declaredExceptions = ((JvmExecutable)logicalContainer).getExceptions();
                needsSneakyThrow = this.needsSneakyThrow(expr.getExpression(), (Collection<JvmTypeReference>)declaredExceptions);
            }
            if (needsSneakyThrow) {
                b.newLine().append("try {").increaseIndentation();
            }
            this.internalToJavaStatement(expr.getExpression(), b, true);
            b.newLine().append("return ");
            this.internalToJavaExpression(expr.getExpression(), b);
            b.append(";");
            if (needsSneakyThrow) {
                this.generateCheckedExceptionHandling(expr, b);
            }
        } else {
            b.newLine().append("return;");
        }
    }

    protected void _toJavaExpression(XCastedExpression expr, ITreeAppendable b) {
        b.append("((");
        this.serialize(expr.getType(), expr, b);
        b.append(") ");
        this.internalToConvertedExpression(expr.getTarget(), b, expr.getType());
        b.append(")");
    }

    protected void _toJavaStatement(XCastedExpression expr, ITreeAppendable b, boolean isReferenced) {
        this.internalToJavaStatement(expr.getTarget(), b, isReferenced);
    }

    protected void _toJavaStatement(XIfExpression expr, ITreeAppendable b, boolean isReferenced) {
        if (isReferenced) {
            this.declareSyntheticVariable(expr, b);
        }
        this.internalToJavaStatement(expr.getIf(), b, true);
        b.newLine().append("if (");
        this.internalToJavaExpression(expr.getIf(), b);
        b.append(") {").increaseIndentation();
        boolean canBeReferenced = isReferenced && !this.isPrimitiveVoid(expr.getThen());
        this.internalToJavaStatement(expr.getThen(), b, canBeReferenced);
        if (canBeReferenced) {
            b.newLine();
            b.append(this.getVarName(expr, b));
            b.append(" = ");
            this.internalToConvertedExpression(expr.getThen(), b, null);
            b.append(";");
        }
        b.decreaseIndentation().newLine().append("}");
        if (expr.getElse() != null) {
            b.append(" else {").increaseIndentation();
            boolean canElseBeReferenced = isReferenced && !this.isPrimitiveVoid(expr.getElse());
            this.internalToJavaStatement(expr.getElse(), b, canElseBeReferenced);
            if (canElseBeReferenced) {
                b.newLine();
                b.append(this.getVarName(expr, b));
                b.append(" = ");
                this.internalToConvertedExpression(expr.getElse(), b, null);
                b.append(";");
            }
            b.decreaseIndentation().newLine().append("}");
        }
    }

    protected void _toJavaExpression(XIfExpression expr, ITreeAppendable b) {
        b.trace(expr, false).append(this.getVarName(expr, b));
    }

    protected void _toJavaStatement(XSwitchExpression expr, ITreeAppendable b, boolean isReferenced) {
        JvmIdentifiableElement feature;
        JvmTypeReference type = this.getTypeForVariableDeclaration(expr);
        String switchResultName = b.declareSyntheticVariable(this.getSwitchExpressionKey(expr), "_switchResult");
        if (isReferenced) {
            b.newLine();
            this.serialize(type, expr, b);
            b.append(" ").append(switchResultName).append(" = ");
            b.append(this.getDefaultValueLiteral(expr));
            b.append(";");
        }
        this.internalToJavaStatement(expr.getSwitch(), b, true);
        String matchedVariable = b.declareSyntheticVariable(Tuples.pair((Object)expr, (Object)"matches"), "_matched");
        String variableName = null;
        if (expr.getLocalVarName() == null && expr.getSwitch() instanceof XFeatureCall && b.hasName(feature = ((XFeatureCall)expr.getSwitch()).getFeature())) {
            variableName = b.getName(feature);
        }
        if (variableName == null) {
            String name = this.getNameProvider().getSimpleName(expr);
            name = name != null ? this.makeJavaIdentifier(name) : "_switchValue";
            JvmTypeReference typeReference = this.getTypeProvider().getType(expr.getSwitch());
            b.newLine().append("final ");
            this.serialize(typeReference, expr, b);
            b.append(" ");
            variableName = b.declareSyntheticVariable(expr, name);
            if (expr.getLocalVarName() != null) {
                b.trace(expr, (EStructuralFeature)XbasePackage.Literals.XSWITCH_EXPRESSION__LOCAL_VAR_NAME, 0).append(variableName);
            } else {
                b.append(variableName);
            }
            b.append(" = ");
            this.internalToJavaExpression(expr.getSwitch(), b);
            b.append(";");
        }
        b.newLine().append("boolean ");
        b.append(matchedVariable).append(" = false;");
        for (XCasePart casePart : expr.getCases()) {
            ITreeAppendable caseAppendable = b.trace((EObject)casePart, true);
            caseAppendable.newLine().append("if (!").append(matchedVariable).append(") {");
            caseAppendable.increaseIndentation();
            if (casePart.getTypeGuard() != null) {
                ITreeAppendable typeGuardAppendable = caseAppendable.trace((EObject)casePart.getTypeGuard(), true);
                typeGuardAppendable.newLine().append("if (");
                typeGuardAppendable.append(variableName);
                typeGuardAppendable.append(" instanceof ");
                typeGuardAppendable.trace((EObject)casePart.getTypeGuard()).append(casePart.getTypeGuard().getType());
                typeGuardAppendable.append(") {");
                typeGuardAppendable.increaseIndentation();
                XSwitchExpression switchOver = expr.getSwitch() instanceof XFeatureCall ? ((XFeatureCall)expr.getSwitch()).getFeature() : expr;
                typeGuardAppendable.openPseudoScope();
                String proposedName = this.getFavoriteVariableName((EObject)casePart.getTypeGuard().getType());
                String castedVariableName = typeGuardAppendable.declareSyntheticVariable(switchOver, proposedName);
                typeGuardAppendable.newLine().append("final ");
                this.serialize(casePart.getTypeGuard(), expr, typeGuardAppendable);
                typeGuardAppendable.append(" ");
                typeGuardAppendable.append(castedVariableName);
                typeGuardAppendable.append(" = (");
                this.serialize(casePart.getTypeGuard(), expr, typeGuardAppendable);
                typeGuardAppendable.append(")");
                typeGuardAppendable.append(variableName);
                typeGuardAppendable.append(";");
            }
            if (casePart.getCase() != null) {
                ITreeAppendable conditionAppendable = caseAppendable.trace(casePart.getCase(), true);
                this.internalToJavaStatement(casePart.getCase(), conditionAppendable, true);
                conditionAppendable.newLine().append("if (");
                JvmTypeReference convertedType = this.getTypeProvider().getType(casePart.getCase());
                if (this.getTypeReferences().is(convertedType, Boolean.TYPE) || this.getTypeReferences().is(convertedType, Boolean.class)) {
                    this.internalToJavaExpression(casePart.getCase(), conditionAppendable);
                } else {
                    JvmTypeReference typeRef = this.getTypeReferences().getTypeForName(Objects.class, (Notifier)expr, new JvmTypeReference[0]);
                    this.serialize(typeRef, (EObject)casePart, conditionAppendable);
                    conditionAppendable.append(".equal(").append(variableName).append(",");
                    this.internalToJavaExpression(casePart.getCase(), conditionAppendable);
                    conditionAppendable.append(")");
                }
                conditionAppendable.append(")");
                caseAppendable.append(" {");
                caseAppendable.increaseIndentation();
            }
            caseAppendable.newLine().append(matchedVariable).append("=true;");
            boolean canBeReferenced = isReferenced && !this.isPrimitiveVoid(casePart.getThen());
            this.internalToJavaStatement(casePart.getThen(), caseAppendable, canBeReferenced);
            if (canBeReferenced) {
                caseAppendable.newLine().append(switchResultName).append(" = ");
                this.internalToConvertedExpression(casePart.getThen(), caseAppendable, null);
                caseAppendable.append(";");
            }
            if (casePart.getCase() != null) {
                caseAppendable.decreaseIndentation().newLine().append("}");
            }
            if (casePart.getTypeGuard() != null) {
                caseAppendable.decreaseIndentation().newLine().append("}");
                caseAppendable.closeScope();
            }
            caseAppendable.decreaseIndentation();
            caseAppendable.newLine().append("}");
        }
        if (expr.getDefault() != null) {
            ILocationData location = this.getLocationOfDefault(expr);
            ITreeAppendable defaultAppendable = location != null ? b.trace(location) : b;
            defaultAppendable.newLine().append("if (!").append(matchedVariable).append(") {");
            defaultAppendable.increaseIndentation();
            boolean canBeReferenced = isReferenced && !this.isPrimitiveVoid(expr.getDefault());
            this.internalToJavaStatement(expr.getDefault(), defaultAppendable, canBeReferenced);
            if (canBeReferenced) {
                defaultAppendable.newLine().append(switchResultName).append(" = ");
                this.internalToConvertedExpression(expr.getDefault(), defaultAppendable, null);
                defaultAppendable.append(";");
            }
            defaultAppendable.decreaseIndentation();
            defaultAppendable.newLine().append("}");
        }
    }

    protected Object getSwitchExpressionKey(XSwitchExpression expr) {
        return new Pair((Object)expr, (Object)"key");
    }

    @Nullable
    protected String getReferenceName(XExpression expr, ITreeAppendable b) {
        Object key;
        if (expr instanceof XSwitchExpression && b.hasName(key = this.getSwitchExpressionKey((XSwitchExpression)expr))) {
            return b.getName(key);
        }
        return super.getReferenceName(expr, b);
    }

    @Nullable
    protected ILocationData getLocationOfDefault(XSwitchExpression expression) {
        ICompositeNode startNode = NodeModelUtils.getNode((EObject)expression);
        if (startNode != null) {
            ArrayList resultNodes = Lists.newArrayList();
            boolean defaultSeen = false;
            for (INode child : startNode.getChildren()) {
                if (defaultSeen) {
                    resultNodes.add(child);
                    if (GrammarUtil.containingAssignment((EObject)child.getGrammarElement()) == null) continue;
                    break;
                }
                if (!(child.getGrammarElement() instanceof Keyword) || !"default".equals(child.getText())) continue;
                defaultSeen = true;
                resultNodes.add(child);
            }
            return this.toLocationData(resultNodes);
        }
        return null;
    }

    protected void _toJavaExpression(XSwitchExpression expr, ITreeAppendable b) {
        String referenceName = this.getReferenceName(expr, b);
        if (referenceName == null) {
            throw new IllegalStateException("Switch expression wasn't translated to Java statements before.");
        }
        b.trace(expr, false).append(referenceName);
    }

    protected void _toJavaStatement(XClosure closure, ITreeAppendable b, boolean isReferenced) {
        if (!isReferenced) {
            throw new IllegalArgumentException("a closure definition does not cause any side-effects");
        }
        JvmTypeReference type = this.getTypeProvider().getType(closure);
        ITypeArgumentContext context = this.ctxProvider.getTypeArgumentContext((TypeArgumentContextProvider.Request)new TypeArgumentContextProvider.ReceiverRequest(type));
        b.newLine().append("final ");
        this.serialize(type, closure, b);
        b.append(" ");
        String variableName = b.declareSyntheticVariable(closure, "_function");
        b.append(variableName).append(" = ");
        b.append("new ");
        this.serialize(type, closure, b, false, false, true, false);
        b.append("() {");
        b.increaseIndentation().increaseIndentation();
        try {
            String proposedName;
            Object element;
            b.openScope();
            JvmOperation operation = this.closures.findImplementingOperation(type, closure.eResource());
            JvmTypeReference returnType = context.resolve(operation.getReturnType());
            b.newLine().append("public ");
            this.serialize(returnType, closure, b, false, false, true, true);
            b.append(" ").append(operation.getSimpleName());
            b.append("(");
            EList<JvmFormalParameter> closureParams = closure.getFormalParameters();
            EList operationParams = operation.getParameters();
            int i = 0;
            while (i < closureParams.size()) {
                JvmFormalParameter closureParam = (JvmFormalParameter)closureParams.get(i);
                JvmFormalParameter operationParam = (JvmFormalParameter)operationParams.get(i);
                JvmTypeReference parameterType = context.resolve(operationParam.getParameterType());
                b.append("final ");
                this.serialize(parameterType, closure, b, false, false, true, true);
                b.append(" ");
                String proposedParamName = this.makeJavaIdentifier(closureParam.getName());
                String name = b.declareVariable(closureParam, proposedParamName);
                b.append(name);
                if (i != closureParams.size() - 1) {
                    b.append(", ");
                }
                ++i;
            }
            b.append(") {");
            b.increaseIndentation();
            if (b.hasObject("this") && (element = b.getObject("this")) instanceof JvmType && !b.hasObject(proposedName = String.valueOf(((JvmType)element).getSimpleName()) + ".this")) {
                Object superElement;
                b.declareSyntheticVariable(element, proposedName);
                if (b.hasObject("super") && (superElement = b.getObject("super")) instanceof JvmType) {
                    b.declareSyntheticVariable(superElement, String.valueOf(((JvmType)element).getSimpleName()) + ".super");
                }
            }
            this.compile(closure.getExpression(), b, operation.getReturnType(), Sets.newHashSet((Iterable)operation.getExceptions()));
        }
        finally {
            b.closeScope();
        }
        b.decreaseIndentation();
        b.newLine().append("}");
        b.decreaseIndentation().newLine().append("};").decreaseIndentation();
    }

    protected void _toJavaExpression(XClosure call, ITreeAppendable b) {
        b.trace(call, false).append(this.getVarName(call, b));
    }

    protected boolean internalCanCompileToJavaExpression(XExpression expression, ITreeAppendable appendable) {
        if (expression instanceof XSwitchExpression) {
            XSwitchExpression switchExpression = (XSwitchExpression)expression;
            return appendable.hasName(this.getSwitchExpressionKey(switchExpression)) || !this.isVariableDeclarationRequired(expression, appendable);
        }
        return super.internalCanCompileToJavaExpression(expression, appendable);
    }

    protected boolean isVariableDeclarationRequired(XExpression expr, ITreeAppendable b) {
        if (expr instanceof XCastedExpression) {
            return false;
        }
        if (expr instanceof XInstanceOfExpression) {
            return false;
        }
        EObject container = expr.eContainer();
        if (container instanceof XVariableDeclaration || container instanceof XReturnExpression || container instanceof XThrowExpression) {
            return false;
        }
        return super.isVariableDeclarationRequired(expr, b);
    }
}

