/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.compiler;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.common.types.JvmAnnotationAnnotationValue;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmAnnotationTarget;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmAnnotationValue;
import org.eclipse.xtext.common.types.JvmBooleanAnnotationValue;
import org.eclipse.xtext.common.types.JvmByteAnnotationValue;
import org.eclipse.xtext.common.types.JvmCharAnnotationValue;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmCustomAnnotationValue;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmDoubleAnnotationValue;
import org.eclipse.xtext.common.types.JvmEnumAnnotationValue;
import org.eclipse.xtext.common.types.JvmEnumerationLiteral;
import org.eclipse.xtext.common.types.JvmEnumerationType;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFloatAnnotationValue;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericArrayTypeReference;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmIntAnnotationValue;
import org.eclipse.xtext.common.types.JvmLongAnnotationValue;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmShortAnnotationValue;
import org.eclipse.xtext.common.types.JvmStringAnnotationValue;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeAnnotationValue;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.JvmVoid;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.documentation.IEObjectDocumentationProvider;
import org.eclipse.xtext.documentation.IEObjectDocumentationProviderExtension;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IGenerator;
import org.eclipse.xtext.generator.trace.ILocationData;
import org.eclipse.xtext.generator.trace.LocationData;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.resource.ILocationInFileProvider;
import org.eclipse.xtext.util.ITextRegionWithLineInformation;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.util.TextRegionWithLineInformation;
import org.eclipse.xtext.util.Wrapper;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.compiler.DocumentationAdapter;
import org.eclipse.xtext.xbase.compiler.ImportManager;
import org.eclipse.xtext.xbase.compiler.JavaKeywords;
import org.eclipse.xtext.xbase.compiler.TreeAppendableUtil;
import org.eclipse.xtext.xbase.compiler.TypeReferenceSerializer;
import org.eclipse.xtext.xbase.compiler.XbaseCompiler;
import org.eclipse.xtext.xbase.compiler.output.ITreeAppendable;
import org.eclipse.xtext.xbase.compiler.output.TreeAppendable;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociations;
import org.eclipse.xtext.xbase.jvmmodel.ILogicalContainerProvider;
import org.eclipse.xtext.xbase.jvmmodel.JvmTypeExtensions;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IntegerRange;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class JvmModelGenerator
implements IGenerator {
    private static final Logger LOG = new Functions.Function0<Logger>(){

        public Logger apply() {
            Logger _logger = Logger.getLogger(JvmModelGenerator.class);
            return _logger;
        }
    }.apply();
    @Inject
    private ILogicalContainerProvider _iLogicalContainerProvider;
    @Inject
    private TypeReferences _typeReferences;
    @Inject
    private TreeAppendableUtil _treeAppendableUtil;
    @Inject
    private JvmTypeExtensions _jvmTypeExtensions;
    @Inject
    private XbaseCompiler compiler;
    @Inject
    private TypeReferenceSerializer typeRefSerializer;
    @Inject
    private ILocationInFileProvider locationProvider;
    @Inject
    private IEObjectDocumentationProvider documentationProvider;
    @Inject
    private IJvmModelAssociations jvmModelAssociations;
    @Inject
    private JavaKeywords keywords;

    public void doGenerate(Resource input, IFileSystemAccess fsa) {
        EList _contents = input.getContents();
        for (EObject obj : _contents) {
            this.internalDoGenerate(obj, fsa);
        }
    }

    protected void _internalDoGenerate(EObject obj, IFileSystemAccess fsa) {
    }

    protected void _internalDoGenerate(JvmGenericType type, IFileSystemAccess fsa) {
        String _qualifiedName = type.getQualifiedName();
        String _replace = _qualifiedName.replace(".", "/");
        String _plus = String.valueOf(_replace) + ".java";
        CharSequence _generateType = this.generateType((JvmDeclaredType)type);
        fsa.generateFile(_plus, _generateType);
    }

    protected void _internalDoGenerate(JvmEnumerationType type, IFileSystemAccess fsa) {
        String _qualifiedName = type.getQualifiedName();
        String _replace = _qualifiedName.replace(".", "/");
        String _plus = String.valueOf(_replace) + ".java";
        CharSequence _generateType = this.generateType((JvmDeclaredType)type);
        fsa.generateFile(_plus, _generateType);
    }

    public CharSequence generateType(JvmDeclaredType type) {
        boolean _not;
        boolean _notEquals;
        ImportManager _importManager;
        ImportManager importManager = _importManager = new ImportManager(true, type);
        TreeAppendable bodyAppendable = this.createAppendable((EObject)type, importManager);
        this.generateBody(type, bodyAppendable);
        TreeAppendable importAppendable = this.createAppendable((EObject)type, importManager);
        String _packageName = type.getPackageName();
        boolean bl = _notEquals = !Objects.equal((Object)_packageName, null);
        if (_notEquals) {
            ITreeAppendable _append = importAppendable.append("package ");
            String _packageName_1 = type.getPackageName();
            ITreeAppendable _append_1 = _append.append(_packageName_1);
            _append_1.append(";");
            TreeAppendable _newLine = importAppendable.newLine();
            _newLine.newLine();
        }
        List<String> _imports = importManager.getImports();
        for (String i : _imports) {
            ITreeAppendable _append_2 = importAppendable.append("import ");
            ITreeAppendable _append_3 = _append_2.append(i);
            ITreeAppendable _append_4 = _append_3.append(";");
            _append_4.newLine();
        }
        List<String> _imports_1 = importManager.getImports();
        boolean _isEmpty = _imports_1.isEmpty();
        boolean bl2 = _not = !_isEmpty;
        if (_not) {
            importAppendable.newLine();
        }
        importAppendable.append(bodyAppendable);
        return importAppendable;
    }

    protected ITreeAppendable _generateBody(JvmGenericType it, ITreeAppendable appendable) {
        ITreeAppendable _newLine_1;
        ITreeAppendable _xblockexpression = null;
        this.generateJavaDoc((EObject)it, appendable);
        final ITreeAppendable childAppendable = appendable.trace((EObject)it);
        this.generateAnnotations((JvmAnnotationTarget)it, childAppendable, true);
        this.generateModifier((JvmMember)it, childAppendable);
        boolean _isInterface = it.isInterface();
        if (_isInterface) {
            childAppendable.append("interface ");
        } else {
            childAppendable.append("class ");
        }
        ITreeAppendable _traceSignificant = this._treeAppendableUtil.traceSignificant(childAppendable, (EObject)it);
        String _simpleName = it.getSimpleName();
        _traceSignificant.append(_simpleName);
        this.generateTypeParameterDeclaration((JvmTypeParameterDeclarator)it, childAppendable);
        EList _typeParameters = it.getTypeParameters();
        boolean _isEmpty = _typeParameters.isEmpty();
        if (_isEmpty) {
            childAppendable.append(" ");
        }
        this.generateExtendsClause((JvmDeclaredType)it, childAppendable);
        childAppendable.append("{");
        final Wrapper b = Wrapper.wrap((Object)true);
        EList _members = it.getMembers();
        Procedures.Procedure1<JvmMember> _function = new Procedures.Procedure1<JvmMember>(){

            public void apply(JvmMember it) {
                ITreeAppendable memberAppendable = JvmModelGenerator.this._treeAppendableUtil.traceWithComments(childAppendable, (EObject)it);
                memberAppendable.openScope();
                Boolean _get = (Boolean)b.get();
                boolean _generateMember = JvmModelGenerator.this.generateMember(it, memberAppendable, _get);
                b.set((Object)_generateMember);
                memberAppendable.closeScope();
            }
        };
        IterableExtensions.forEach((Iterable)_members, (Procedures.Procedure1)_function);
        ITreeAppendable _newLine = childAppendable.newLine();
        _newLine.append("}");
        _xblockexpression = _newLine_1 = appendable.newLine();
        return _xblockexpression;
    }

    protected ITreeAppendable _generateBody(JvmEnumerationType it, final ITreeAppendable appendable) {
        ITreeAppendable _newLine_1;
        ITreeAppendable _xblockexpression = null;
        this.generateJavaDoc((EObject)it, appendable);
        this.generateAnnotations((JvmAnnotationTarget)it, appendable, true);
        this.generateModifier((JvmMember)it, appendable);
        appendable.append("enum ");
        ITreeAppendable _traceSignificant = this._treeAppendableUtil.traceSignificant(appendable, (EObject)it);
        String _simpleName = it.getSimpleName();
        _traceSignificant.append(_simpleName);
        appendable.append(" ");
        this.generateExtendsClause((JvmDeclaredType)it, appendable);
        appendable.append("{");
        final Wrapper b = Wrapper.wrap((Object)true);
        EList _literals = it.getLiterals();
        Procedures.Procedure1<JvmEnumerationLiteral> _function = new Procedures.Procedure1<JvmEnumerationLiteral>(){

            public void apply(JvmEnumerationLiteral it) {
                ITreeAppendable _trace = appendable.trace((EObject)it);
                Boolean _get = (Boolean)b.get();
                boolean _generateEnumLiteral = JvmModelGenerator.this.generateEnumLiteral(it, _trace, _get);
                b.set((Object)_generateEnumLiteral);
            }
        };
        IterableExtensions.forEach((Iterable)_literals, (Procedures.Procedure1)_function);
        EList _members = it.getMembers();
        Functions.Function1<JvmMember, Boolean> _function_1 = new Functions.Function1<JvmMember, Boolean>(){

            public Boolean apply(JvmMember it) {
                boolean _not = !(it instanceof JvmEnumerationLiteral);
                return _not;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_members, (Functions.Function1)_function_1);
        Procedures.Procedure1<JvmMember> _function_2 = new Procedures.Procedure1<JvmMember>(){

            public void apply(JvmMember it) {
                ITreeAppendable _trace = appendable.trace((EObject)it);
                Boolean _get = (Boolean)b.get();
                boolean _generateMember = JvmModelGenerator.this.generateMember(it, _trace, _get);
                b.set((Object)_generateMember);
            }
        };
        IterableExtensions.forEach((Iterable)_filter, (Procedures.Procedure1)_function_2);
        ITreeAppendable _newLine = appendable.newLine();
        ITreeAppendable _append = _newLine.append("}");
        _xblockexpression = _newLine_1 = _append.newLine();
        return _xblockexpression;
    }

    protected ITreeAppendable _generateModifier(JvmDeclaredType it, ITreeAppendable appendable) {
        boolean _isStatic;
        ITreeAppendable _xblockexpression = null;
        JvmVisibility _visibility = it.getVisibility();
        String _javaName = this.javaName(_visibility);
        appendable.append(_javaName);
        boolean _isAbstract = it.isAbstract();
        if (_isAbstract) {
            appendable.append("abstract ");
        }
        if (_isStatic = it.isStatic()) {
            appendable.append("static ");
        }
        ITreeAppendable _xifexpression = null;
        boolean _isFinal = it.isFinal();
        if (_isFinal) {
            ITreeAppendable _append;
            _xifexpression = _append = appendable.append("final ");
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    protected ITreeAppendable _generateModifier(JvmField it, ITreeAppendable appendable) {
        ITreeAppendable _xblockexpression = null;
        JvmVisibility _visibility = it.getVisibility();
        String _javaName = this.javaName(_visibility);
        appendable.append(_javaName);
        boolean _isFinal = it.isFinal();
        if (_isFinal) {
            appendable.append("final ");
        }
        ITreeAppendable _xifexpression = null;
        boolean _isStatic = it.isStatic();
        if (_isStatic) {
            ITreeAppendable _append;
            _xifexpression = _append = appendable.append("static ");
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    protected ITreeAppendable _generateModifier(JvmOperation it, ITreeAppendable appendable) {
        boolean _isStatic;
        ITreeAppendable _xblockexpression = null;
        JvmVisibility _visibility = it.getVisibility();
        String _javaName = this.javaName(_visibility);
        appendable.append(_javaName);
        boolean _isAbstract = it.isAbstract();
        if (_isAbstract) {
            appendable.append("abstract ");
        }
        if (_isStatic = it.isStatic()) {
            appendable.append("static ");
        }
        ITreeAppendable _xifexpression = null;
        boolean _isFinal = it.isFinal();
        if (_isFinal) {
            ITreeAppendable _append;
            _xifexpression = _append = appendable.append("final ");
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    protected ITreeAppendable _generateModifier(JvmConstructor it, ITreeAppendable appendable) {
        JvmVisibility _visibility = it.getVisibility();
        String _javaName = this.javaName(_visibility);
        ITreeAppendable _append = appendable.append(_javaName);
        return _append;
    }

    public String javaName(JvmVisibility visibility) {
        boolean _notEquals;
        boolean bl = _notEquals = !Objects.equal((Object)visibility, null);
        if (_notEquals) {
            String _switchResult = null;
            boolean _matched = false;
            if (!_matched && Objects.equal((Object)visibility, (Object)JvmVisibility.PRIVATE)) {
                _matched = true;
                _switchResult = "private ";
            }
            if (!_matched && Objects.equal((Object)visibility, (Object)JvmVisibility.PUBLIC)) {
                _matched = true;
                _switchResult = "public ";
            }
            if (!_matched && Objects.equal((Object)visibility, (Object)JvmVisibility.PROTECTED)) {
                _matched = true;
                _switchResult = "protected ";
            }
            if (!_matched && Objects.equal((Object)visibility, (Object)JvmVisibility.DEFAULT)) {
                _matched = true;
                _switchResult = "";
            }
            return _switchResult;
        }
        return "";
    }

    public void generateExtendsClause(JvmDeclaredType it, final ITreeAppendable appendable) {
        Procedures.Procedure2<Iterable<JvmTypeReference>, String> _function;
        EList _superTypes = it.getSuperTypes();
        boolean _isEmpty = _superTypes.isEmpty();
        if (_isEmpty) {
            return;
        }
        Procedures.Procedure2<Iterable<JvmTypeReference>, String> commaDelimited = _function = new Procedures.Procedure2<Iterable<JvmTypeReference>, String>(){

            public void apply(Iterable<JvmTypeReference> it, String prefix) {
                boolean _isEmpty = IterableExtensions.isEmpty(it);
                if (_isEmpty) {
                    return;
                }
                ITreeAppendable _append = appendable.append(prefix);
                _append.append(" ");
                JvmTypeReference _head = (JvmTypeReference)IterableExtensions.head(it);
                JvmModelGenerator.this.serialize(_head, appendable);
                Iterable _tail = IterableExtensions.tail(it);
                Procedures.Procedure1<JvmTypeReference> _function = new Procedures.Procedure1<JvmTypeReference>(){

                    public void apply(JvmTypeReference it) {
                        appendable.append(", ");
                        JvmModelGenerator.this.serialize(it, appendable);
                    }
                };
                IterableExtensions.forEach((Iterable)_tail, (Procedures.Procedure1)_function);
                appendable.append(" ");
            }
        };
        boolean _and = false;
        if (!(it instanceof JvmGenericType)) {
            _and = false;
        } else {
            boolean _isInterface = ((JvmGenericType)it).isInterface();
            boolean bl = _and = it instanceof JvmGenericType && _isInterface;
        }
        if (_and) {
            EList _superTypes_1 = it.getSuperTypes();
            commaDelimited.apply((Object)_superTypes_1, (Object)"extends");
        } else {
            boolean _isEmpty_1;
            boolean _not;
            boolean _notEquals;
            EList _superTypes_2 = it.getSuperTypes();
            Functions.Function1<JvmTypeReference, Boolean> _function_1 = new Functions.Function1<JvmTypeReference, Boolean>(){

                public Boolean apply(JvmTypeReference typeRef) {
                    String _identifier = typeRef.getIdentifier();
                    boolean _notEquals = !Objects.equal((Object)_identifier, (Object)"java.lang.Object");
                    return _notEquals;
                }
            };
            Iterable withoutObject = IterableExtensions.filter((Iterable)_superTypes_2, (Functions.Function1)_function_1);
            Functions.Function1<JvmTypeReference, Boolean> _function_2 = new Functions.Function1<JvmTypeReference, Boolean>(){

                public Boolean apply(JvmTypeReference typeRef) {
                    boolean _and = false;
                    JvmType _type = typeRef.getType();
                    if (!(_type instanceof JvmGenericType)) {
                        _and = false;
                    } else {
                        JvmType _type_1 = typeRef.getType();
                        boolean _isInterface = ((JvmGenericType)_type_1).isInterface();
                        boolean _not = !_isInterface;
                        _and = _type instanceof JvmGenericType && _not;
                    }
                    return _and;
                }
            };
            Iterable _filter = IterableExtensions.filter((Iterable)withoutObject, (Functions.Function1)_function_2);
            final JvmTypeReference superClazz = (JvmTypeReference)IterableExtensions.head((Iterable)_filter);
            Functions.Function1<JvmTypeReference, Boolean> _function_3 = new Functions.Function1<JvmTypeReference, Boolean>(){

                public Boolean apply(JvmTypeReference typeRef) {
                    boolean _notEquals = !Objects.equal((Object)typeRef, (Object)superClazz);
                    return _notEquals;
                }
            };
            Iterable superInterfaces = IterableExtensions.filter((Iterable)withoutObject, (Functions.Function1)_function_3);
            boolean bl = _notEquals = !Objects.equal((Object)superClazz, null);
            if (_notEquals) {
                appendable.append("extends ");
                this.serialize(superClazz, appendable);
                appendable.append(" ");
            }
            boolean bl2 = _not = !(_isEmpty_1 = IterableExtensions.isEmpty((Iterable)superInterfaces));
            if (_not) {
                commaDelimited.apply((Object)superInterfaces, (Object)"implements");
            }
        }
    }

    public boolean generateEnumLiteral(JvmEnumerationLiteral it, ITreeAppendable appendable, boolean first) {
        boolean _not;
        boolean bl = _not = !first;
        if (_not) {
            ITreeAppendable _append = appendable.append(",");
            _append.newLine();
        }
        ITreeAppendable _increaseIndentation = appendable.increaseIndentation();
        _increaseIndentation.newLine();
        this.generateJavaDoc((EObject)it, appendable);
        this.generateAnnotations((JvmAnnotationTarget)it, appendable, true);
        String _simpleName = it.getSimpleName();
        appendable.append(_simpleName);
        appendable.decreaseIndentation();
        return false;
    }

    protected boolean _generateMember(JvmMember it, ITreeAppendable appendable, boolean first) {
        String _plus = "generateMember not implemented for elements of type " + it;
        UnsupportedOperationException _unsupportedOperationException = new UnsupportedOperationException(_plus);
        throw _unsupportedOperationException;
    }

    protected boolean _generateMember(JvmGenericType it, ITreeAppendable appendable, boolean first) {
        ITreeAppendable _increaseIndentation = appendable.increaseIndentation();
        _increaseIndentation.newLine();
        this.generateBody((JvmDeclaredType)it, appendable);
        appendable.decreaseIndentation();
        return false;
    }

    protected boolean _generateMember(JvmField it, ITreeAppendable appendable, boolean first) {
        boolean _not;
        ITreeAppendable _increaseIndentation = appendable.increaseIndentation();
        _increaseIndentation.newLine();
        boolean bl = _not = !first;
        if (_not) {
            appendable.newLine();
        }
        this.generateJavaDoc((EObject)it, appendable);
        ITreeAppendable tracedAppendable = appendable.trace((EObject)it);
        this.generateAnnotations((JvmAnnotationTarget)it, tracedAppendable, true);
        this.generateModifier((JvmMember)it, tracedAppendable);
        JvmTypeReference _type = it.getType();
        this.serialize(_type, tracedAppendable);
        tracedAppendable.append(" ");
        ITreeAppendable _traceSignificant = this._treeAppendableUtil.traceSignificant(tracedAppendable, (EObject)it);
        String _simpleName = it.getSimpleName();
        _traceSignificant.append(_simpleName);
        this.generateInitialization(it, tracedAppendable);
        tracedAppendable.append(";");
        appendable.decreaseIndentation();
        return false;
    }

    protected boolean _generateMember(JvmOperation it, ITreeAppendable appendable, boolean first) {
        boolean _not;
        ITreeAppendable _increaseIndentation = appendable.increaseIndentation();
        _increaseIndentation.newLine();
        boolean bl = _not = !first;
        if (_not) {
            appendable.newLine();
        }
        appendable.openScope();
        this.generateJavaDoc((EObject)it, appendable);
        ITreeAppendable tracedAppendable = appendable.trace((EObject)it);
        this.generateAnnotations((JvmAnnotationTarget)it, tracedAppendable, true);
        this.generateModifier((JvmMember)it, tracedAppendable);
        this.generateTypeParameterDeclaration((JvmTypeParameterDeclarator)it, tracedAppendable);
        JvmTypeReference _returnType = it.getReturnType();
        boolean _equals = Objects.equal((Object)_returnType, null);
        if (_equals) {
            tracedAppendable.append("void");
        } else {
            JvmTypeReference _returnType_1 = it.getReturnType();
            this.serialize(_returnType_1, tracedAppendable);
        }
        tracedAppendable.append(" ");
        ITreeAppendable _traceSignificant = this._treeAppendableUtil.traceSignificant(tracedAppendable, (EObject)it);
        String _simpleName = it.getSimpleName();
        _traceSignificant.append(_simpleName);
        tracedAppendable.append("(");
        this.generateParameters((JvmExecutable)it, tracedAppendable);
        tracedAppendable.append(")");
        this.generateThrowsClause((JvmExecutable)it, tracedAppendable);
        boolean _isAbstract = it.isAbstract();
        if (_isAbstract) {
            tracedAppendable.append(";");
        } else {
            tracedAppendable.append(" ");
            this.generateExecutableBody((JvmExecutable)it, tracedAppendable);
        }
        appendable.decreaseIndentation();
        appendable.closeScope();
        return false;
    }

    protected boolean _generateMember(JvmConstructor it, ITreeAppendable appendable, boolean first) {
        boolean _not;
        boolean _isSingleSyntheticDefaultConstructor = this._jvmTypeExtensions.isSingleSyntheticDefaultConstructor(it);
        boolean bl = _not = !_isSingleSyntheticDefaultConstructor;
        if (_not) {
            boolean _not_1;
            ITreeAppendable _increaseIndentation = appendable.increaseIndentation();
            _increaseIndentation.newLine();
            boolean bl2 = _not_1 = !first;
            if (_not_1) {
                appendable.newLine();
            }
            appendable.openScope();
            this.generateJavaDoc((EObject)it, appendable);
            ITreeAppendable tracedAppendable = appendable.trace((EObject)it);
            this.generateAnnotations((JvmAnnotationTarget)it, tracedAppendable, true);
            this.generateModifier((JvmMember)it, tracedAppendable);
            this.generateTypeParameterDeclaration((JvmTypeParameterDeclarator)it, tracedAppendable);
            ITreeAppendable _traceSignificant = this._treeAppendableUtil.traceSignificant(tracedAppendable, (EObject)it);
            String _simpleName = it.getSimpleName();
            _traceSignificant.append(_simpleName);
            tracedAppendable.append("(");
            this.generateParameters((JvmExecutable)it, tracedAppendable);
            tracedAppendable.append(")");
            this.generateThrowsClause((JvmExecutable)it, tracedAppendable);
            tracedAppendable.append(" ");
            this.generateExecutableBody((JvmExecutable)it, tracedAppendable);
            appendable.decreaseIndentation();
            appendable.closeScope();
            return false;
        }
        return first;
    }

    public void generateInitialization(JvmField it, ITreeAppendable appendable) {
        boolean _notEquals;
        Procedures.Procedure1<? super ITreeAppendable> _compilationStrategy = this._jvmTypeExtensions.getCompilationStrategy((JvmIdentifiableElement)it);
        boolean bl = _notEquals = !Objects.equal(_compilationStrategy, null);
        if (_notEquals) {
            appendable.append(" = ");
            appendable.increaseIndentation();
            Procedures.Procedure1<? super ITreeAppendable> _compilationStrategy_1 = this._jvmTypeExtensions.getCompilationStrategy((JvmIdentifiableElement)it);
            _compilationStrategy_1.apply((Object)appendable);
            appendable.decreaseIndentation();
        } else {
            boolean _notEquals_1;
            XExpression expression = this._iLogicalContainerProvider.getAssociatedExpression((JvmIdentifiableElement)it);
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)expression, null);
            if (_notEquals_1) {
                appendable.append(" = ");
                JvmTypeReference _type = it.getType();
                this.compiler.compileAsJavaExpression(expression, appendable, _type);
            }
        }
    }

    public void generateTypeParameterDeclaration(JvmTypeParameterDeclarator it, final ITreeAppendable appendable) {
        boolean _not;
        EList _typeParameters = it.getTypeParameters();
        boolean _isEmpty = _typeParameters.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            appendable.append("<");
            EList _typeParameters_1 = it.getTypeParameters();
            JvmTypeParameter _head = (JvmTypeParameter)IterableExtensions.head((Iterable)_typeParameters_1);
            this.generateTypeParameterDeclaration(_head, appendable);
            EList _typeParameters_2 = it.getTypeParameters();
            Iterable _tail = IterableExtensions.tail((Iterable)_typeParameters_2);
            Procedures.Procedure1<JvmTypeParameter> _function = new Procedures.Procedure1<JvmTypeParameter>(){

                public void apply(JvmTypeParameter it) {
                    appendable.append(", ");
                    JvmModelGenerator.this.generateTypeParameterDeclaration(it, appendable);
                }
            };
            IterableExtensions.forEach((Iterable)_tail, (Procedures.Procedure1)_function);
            appendable.append("> ");
        }
    }

    public void generateTypeParameterDeclaration(JvmTypeParameter it, ITreeAppendable appendable) {
        ITreeAppendable tracedAppendable = appendable.trace((EObject)it);
        ITreeAppendable _traceSignificant = this._treeAppendableUtil.traceSignificant(tracedAppendable, (EObject)it);
        String _name = it.getName();
        _traceSignificant.append(_name);
        this.generateTypeParameterConstraints(it, tracedAppendable);
    }

    public void generateTypeParameterConstraints(JvmTypeParameter it, final ITreeAppendable appendable) {
        boolean _not;
        EList _constraints = it.getConstraints();
        Iterable upperBounds = Iterables.filter((Iterable)_constraints, JvmUpperBound.class);
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)upperBounds);
        boolean bl = _not = !_isEmpty;
        if (_not) {
            appendable.append(" extends ");
            JvmUpperBound _head = (JvmUpperBound)IterableExtensions.head((Iterable)upperBounds);
            JvmTypeReference _typeReference = _head.getTypeReference();
            this.serialize(_typeReference, appendable);
            Iterable _tail = IterableExtensions.tail((Iterable)upperBounds);
            Procedures.Procedure1<JvmUpperBound> _function = new Procedures.Procedure1<JvmUpperBound>(){

                public void apply(JvmUpperBound it) {
                    appendable.append(" & ");
                    JvmTypeReference _typeReference = it.getTypeReference();
                    JvmModelGenerator.this.serialize(_typeReference, appendable);
                }
            };
            IterableExtensions.forEach((Iterable)_tail, (Procedures.Procedure1)_function);
        }
    }

    public void generateThrowsClause(JvmExecutable it, final ITreeAppendable appendable) {
        boolean _not;
        final HashSet seenExceptions = CollectionLiterals.newHashSet((Object[])new JvmType[0]);
        EList _exceptions = it.getExceptions();
        boolean _isEmpty = _exceptions.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            appendable.append(" throws ");
            EList _exceptions_1 = it.getExceptions();
            JvmTypeReference _head = (JvmTypeReference)IterableExtensions.head((Iterable)_exceptions_1);
            JvmType _type = _head.getType();
            seenExceptions.add(_type);
            EList _exceptions_2 = it.getExceptions();
            JvmTypeReference _head_1 = (JvmTypeReference)IterableExtensions.head((Iterable)_exceptions_2);
            ITreeAppendable _trace = appendable.trace((EObject)_head_1);
            EList _exceptions_3 = it.getExceptions();
            JvmTypeReference _head_2 = (JvmTypeReference)IterableExtensions.head((Iterable)_exceptions_3);
            JvmType _type_1 = _head_2.getType();
            _trace.append(_type_1);
            EList _exceptions_4 = it.getExceptions();
            Iterable _tail = IterableExtensions.tail((Iterable)_exceptions_4);
            Procedures.Procedure1<JvmTypeReference> _function = new Procedures.Procedure1<JvmTypeReference>(){

                public void apply(JvmTypeReference exception) {
                    JvmType _type = exception.getType();
                    boolean _add = seenExceptions.add(_type);
                    if (_add) {
                        appendable.append(", ");
                        ITreeAppendable _trace = appendable.trace((EObject)exception);
                        JvmType _type_1 = exception.getType();
                        _trace.append(_type_1);
                    }
                }
            };
            IterableExtensions.forEach((Iterable)_tail, (Procedures.Procedure1)_function);
        }
    }

    public void generateParameters(JvmExecutable it, ITreeAppendable appendable) {
        boolean _not;
        EList _parameters = it.getParameters();
        boolean _isEmpty = _parameters.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            EList _parameters_1 = it.getParameters();
            int _size = _parameters_1.size();
            int _minus = _size - 1;
            IntegerRange _upTo = new IntegerRange(0, _minus);
            for (Integer i : _upTo) {
                boolean _not_1;
                EList _parameters_2;
                int _size_1;
                int _plus = i + 1;
                boolean last = _plus == (_size_1 = (_parameters_2 = it.getParameters()).size());
                EList _parameters_3 = it.getParameters();
                JvmFormalParameter p = (JvmFormalParameter)_parameters_3.get(i.intValue());
                boolean _and = false;
                if (!last) {
                    _and = false;
                } else {
                    boolean _isVarArgs = it.isVarArgs();
                    _and = last && _isVarArgs;
                }
                this.generateParameter(p, appendable, _and);
                boolean bl2 = _not_1 = !last;
                if (!_not_1) continue;
                appendable.append(", ");
            }
        }
    }

    public void generateParameter(JvmFormalParameter it, ITreeAppendable appendable, boolean vararg) {
        ITreeAppendable tracedAppendable = appendable.trace((EObject)it);
        this.generateAnnotations((JvmAnnotationTarget)it, tracedAppendable, false);
        tracedAppendable.append("final ");
        if (vararg) {
            JvmTypeReference _parameterType = it.getParameterType();
            JvmTypeReference _componentType = ((JvmGenericArrayTypeReference)_parameterType).getComponentType();
            this.serialize(_componentType, tracedAppendable);
            tracedAppendable.append("...");
        } else {
            JvmTypeReference _parameterType_1 = it.getParameterType();
            this.serialize(_parameterType_1, tracedAppendable);
        }
        tracedAppendable.append(" ");
        String _simpleName = it.getSimpleName();
        String _makeJavaIdentifier = this.makeJavaIdentifier(_simpleName);
        String name = tracedAppendable.declareVariable(it, _makeJavaIdentifier);
        ITreeAppendable _traceSignificant = this._treeAppendableUtil.traceSignificant(tracedAppendable, (EObject)it);
        _traceSignificant.append(name);
    }

    public void generateExecutableBody(JvmExecutable op, ITreeAppendable appendable) {
        boolean _notEquals;
        Procedures.Procedure1<? super ITreeAppendable> _compilationStrategy = this._jvmTypeExtensions.getCompilationStrategy((JvmIdentifiableElement)op);
        boolean bl = _notEquals = !Objects.equal(_compilationStrategy, null);
        if (_notEquals) {
            ITreeAppendable _increaseIndentation = appendable.increaseIndentation();
            ITreeAppendable _append = _increaseIndentation.append("{");
            _append.newLine();
            Procedures.Procedure1<? super ITreeAppendable> _compilationStrategy_1 = this._jvmTypeExtensions.getCompilationStrategy((JvmIdentifiableElement)op);
            _compilationStrategy_1.apply((Object)appendable);
            ITreeAppendable _decreaseIndentation = appendable.decreaseIndentation();
            ITreeAppendable _newLine = _decreaseIndentation.newLine();
            _newLine.append("}");
        } else {
            boolean _notEquals_1;
            XExpression expression = this._iLogicalContainerProvider.getAssociatedExpression((JvmIdentifiableElement)op);
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)expression, null);
            if (_notEquals_1) {
                JvmTypeReference _switchResult = null;
                boolean _matched = false;
                if (!_matched && op instanceof JvmOperation) {
                    JvmTypeReference _returnType;
                    JvmOperation _jvmOperation = (JvmOperation)op;
                    _matched = true;
                    _switchResult = _returnType = _jvmOperation.getReturnType();
                }
                if (!_matched && op instanceof JvmConstructor) {
                    JvmTypeReference _typeForName;
                    JvmConstructor _jvmConstructor = (JvmConstructor)op;
                    _matched = true;
                    _switchResult = _typeForName = this._typeReferences.getTypeForName(Void.TYPE, (Notifier)_jvmConstructor, new JvmTypeReference[0]);
                }
                if (!_matched) {
                    _switchResult = null;
                }
                JvmTypeReference returnType = _switchResult;
                boolean _and = false;
                boolean _and_1 = false;
                if (!(expression instanceof XBlockExpression)) {
                    _and_1 = false;
                } else {
                    EList<XExpression> _expressions = ((XBlockExpression)expression).getExpressions();
                    int _size = _expressions.size();
                    boolean _notEquals_2 = _size != 1;
                    boolean bl3 = _and_1 = expression instanceof XBlockExpression && _notEquals_2;
                }
                if (!_and_1) {
                    _and = false;
                } else {
                    boolean bl4 = _and = _and_1 && returnType instanceof JvmVoid;
                }
                if (_and) {
                    XBlockExpression block = (XBlockExpression)expression;
                    EList<XExpression> _expressions_1 = block.getExpressions();
                    boolean _isEmpty = _expressions_1.isEmpty();
                    if (_isEmpty) {
                        appendable.append("{}");
                    } else {
                        EList _exceptions = op.getExceptions();
                        Set _set = IterableExtensions.toSet((Iterable)_exceptions);
                        this.compiler.compile(expression, appendable, returnType, _set);
                    }
                } else {
                    ITreeAppendable _append_1 = appendable.append("{");
                    _append_1.increaseIndentation();
                    EList _exceptions_1 = op.getExceptions();
                    Set _set_1 = IterableExtensions.toSet((Iterable)_exceptions_1);
                    this.compiler.compile(expression, appendable, returnType, _set_1);
                    ITreeAppendable _decreaseIndentation_1 = appendable.decreaseIndentation();
                    ITreeAppendable _newLine_1 = _decreaseIndentation_1.newLine();
                    _newLine_1.append("}");
                }
            } else if (op instanceof JvmOperation) {
                ITreeAppendable _increaseIndentation_1 = appendable.increaseIndentation();
                ITreeAppendable _append_2 = _increaseIndentation_1.append("{");
                _append_2.newLine();
                appendable.append("throw new UnsupportedOperationException(\"");
                String _simpleName = op.getSimpleName();
                appendable.append(_simpleName);
                appendable.append("is not implemented\");");
                ITreeAppendable _decreaseIndentation_2 = appendable.decreaseIndentation();
                ITreeAppendable _newLine_2 = _decreaseIndentation_2.newLine();
                _newLine_2.append("}");
            } else if (op instanceof JvmConstructor) {
                ITreeAppendable _append_3 = appendable.append("{");
                ITreeAppendable _newLine_3 = _append_3.newLine();
                _newLine_3.append("}");
            }
        }
    }

    public void generateJavaDoc(EObject it, ITreeAppendable appendable) {
        boolean _not;
        EList _eAdapters = it.eAdapters();
        Iterable _filter = Iterables.filter((Iterable)_eAdapters, DocumentationAdapter.class);
        DocumentationAdapter adapter = (DocumentationAdapter)((Object)IterableExtensions.head((Iterable)_filter));
        String _documentation = adapter == null ? null : adapter.getDocumentation();
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)_documentation);
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            boolean _equals;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"/**");
            StringConcatenation doc = _builder;
            doc.newLine();
            doc.append((Object)" * ");
            String _documentation_1 = adapter.getDocumentation();
            doc.append((Object)_documentation_1, " * ");
            doc.newLine();
            doc.append((Object)" */");
            Set<EObject> sourceElements = this.jvmModelAssociations.getSourceElements(it);
            boolean _and = false;
            int _size = sourceElements.size();
            boolean bl2 = _equals = _size == 1;
            if (!_equals) {
                _and = false;
            } else {
                boolean bl3 = _and = _equals && this.documentationProvider instanceof IEObjectDocumentationProviderExtension;
            }
            if (_and) {
                boolean _not_1;
                EObject _head = (EObject)IterableExtensions.head(sourceElements);
                List documentationNodes = ((IEObjectDocumentationProviderExtension)this.documentationProvider).getDocumentationNodes(_head);
                boolean _isEmpty = documentationNodes.isEmpty();
                boolean bl4 = _not_1 = !_isEmpty;
                if (_not_1) {
                    ITextRegionWithLineInformation documentationTrace = ITextRegionWithLineInformation.EMPTY_REGION;
                    for (INode node : documentationNodes) {
                        ITextRegionWithLineInformation _merge;
                        int _offset = node.getOffset();
                        int _length = node.getLength();
                        int _startLine = node.getStartLine();
                        int _endLine = node.getEndLine();
                        TextRegionWithLineInformation _textRegionWithLineInformation = new TextRegionWithLineInformation(_offset, _length, _startLine, _endLine);
                        documentationTrace = _merge = documentationTrace.merge((ITextRegionWithLineInformation)_textRegionWithLineInformation);
                    }
                    LocationData _locationData = new LocationData(documentationTrace, null, null);
                    ITreeAppendable _trace = appendable.trace((ILocationData)_locationData);
                    String _string = doc.toString();
                    _trace.append(_string);
                    appendable.newLine();
                    return;
                }
            }
            String _string_1 = doc.toString();
            ITreeAppendable _append = appendable.append(_string_1);
            _append.newLine();
        }
    }

    public void generateAnnotations(JvmAnnotationTarget it, final ITreeAppendable appendable, final boolean withLineBreak) {
        boolean _not;
        EList _annotations = it.getAnnotations();
        boolean _isEmpty = _annotations.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            EList _annotations_1 = it.getAnnotations();
            JvmAnnotationReference _head = (JvmAnnotationReference)IterableExtensions.head((Iterable)_annotations_1);
            this.generateAnnotation(_head, appendable);
            EList _annotations_2 = it.getAnnotations();
            Iterable _tail = IterableExtensions.tail((Iterable)_annotations_2);
            Procedures.Procedure1<JvmAnnotationReference> _function = new Procedures.Procedure1<JvmAnnotationReference>(){

                public void apply(JvmAnnotationReference it) {
                    if (withLineBreak) {
                        appendable.newLine();
                    } else {
                        appendable.append(" ");
                    }
                    JvmModelGenerator.this.generateAnnotation(it, appendable);
                }
            };
            IterableExtensions.forEach((Iterable)_tail, (Procedures.Procedure1)_function);
            if (withLineBreak) {
                appendable.newLine();
            } else {
                appendable.append(" ");
            }
        }
    }

    public void generateAnnotations(JvmAnnotationAnnotationValue it, final ITreeAppendable appendable, final boolean withLineBreak) {
        boolean _not;
        EList _annotations = it.getAnnotations();
        boolean _isEmpty = _annotations.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            EList _annotations_1 = it.getAnnotations();
            JvmAnnotationReference _head = (JvmAnnotationReference)IterableExtensions.head((Iterable)_annotations_1);
            this.generateAnnotation(_head, appendable);
            EList _annotations_2 = it.getAnnotations();
            Iterable _tail = IterableExtensions.tail((Iterable)_annotations_2);
            Procedures.Procedure1<JvmAnnotationReference> _function = new Procedures.Procedure1<JvmAnnotationReference>(){

                public void apply(JvmAnnotationReference it) {
                    if (withLineBreak) {
                        appendable.newLine();
                    } else {
                        appendable.append(", ");
                    }
                    JvmModelGenerator.this.generateAnnotation(it, appendable);
                }
            };
            IterableExtensions.forEach((Iterable)_tail, (Procedures.Procedure1)_function);
            if (withLineBreak) {
                appendable.newLine();
            } else {
                appendable.append(" ");
            }
        }
    }

    public void generateAnnotation(JvmAnnotationReference it, final ITreeAppendable appendable) {
        boolean _not;
        appendable.append("@");
        JvmAnnotationType _annotation = it.getAnnotation();
        appendable.append((JvmType)_annotation);
        EList _values = it.getValues();
        boolean _isEmpty = _values.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            appendable.append("(");
            EList _values_1 = it.getValues();
            JvmAnnotationValue _head = (JvmAnnotationValue)IterableExtensions.head((Iterable)_values_1);
            this.toJava(_head, appendable);
            EList _values_2 = it.getValues();
            Iterable _tail = IterableExtensions.tail((Iterable)_values_2);
            Procedures.Procedure1<JvmAnnotationValue> _function = new Procedures.Procedure1<JvmAnnotationValue>(){

                public void apply(JvmAnnotationValue it) {
                    appendable.append(", ");
                    JvmModelGenerator.this.toJava(it, appendable);
                }
            };
            IterableExtensions.forEach((Iterable)_tail, (Procedures.Procedure1)_function);
            appendable.append(")");
        }
    }

    public void toJava(JvmAnnotationValue it, ITreeAppendable appendable) {
        boolean _notEquals;
        JvmOperation _operation = it.getOperation();
        boolean bl = _notEquals = !Objects.equal((Object)_operation, null);
        if (_notEquals) {
            JvmOperation _operation_1 = it.getOperation();
            String _simpleName = _operation_1.getSimpleName();
            appendable.append(_simpleName);
            appendable.append(" = ");
        }
        this.toJavaLiteral(it, appendable);
    }

    protected void _toJavaLiteral(JvmAnnotationAnnotationValue it, ITreeAppendable appendable) {
        boolean _notEquals;
        EList _values = it.getValues();
        int _size = _values.size();
        boolean bl = _notEquals = _size != 1;
        if (_notEquals) {
            appendable.append("{ ");
            this.generateAnnotations(it, appendable, false);
            appendable.append("} ");
        } else {
            this.generateAnnotations(it, appendable, false);
        }
    }

    protected void _toJavaLiteral(JvmShortAnnotationValue it, ITreeAppendable appendable) {
        boolean _equals;
        EList _values = it.getValues();
        int _size = _values.size();
        boolean bl = _equals = _size == 1;
        if (_equals) {
            EList _values_1 = it.getValues();
            Short _head = (Short)IterableExtensions.head((Iterable)_values_1);
            String _string = _head.toString();
            appendable.append(_string);
        } else {
            EList _values_2 = it.getValues();
            Functions.Function1<Short, String> _function = new Functions.Function1<Short, String>(){

                public String apply(Short it) {
                    String _string = it.toString();
                    return _string;
                }
            };
            String _join = IterableExtensions.join((Iterable)_values_2, (CharSequence)"{ ", (CharSequence)", ", (CharSequence)" }", (Functions.Function1)_function);
            appendable.append(_join);
        }
    }

    protected void _toJavaLiteral(JvmIntAnnotationValue it, ITreeAppendable appendable) {
        boolean _equals;
        EList _values = it.getValues();
        int _size = _values.size();
        boolean bl = _equals = _size == 1;
        if (_equals) {
            EList _values_1 = it.getValues();
            Integer _head = (Integer)IterableExtensions.head((Iterable)_values_1);
            String _string = _head.toString();
            appendable.append(_string);
        } else {
            EList _values_2 = it.getValues();
            Functions.Function1<Integer, String> _function = new Functions.Function1<Integer, String>(){

                public String apply(Integer it) {
                    String _string = it.toString();
                    return _string;
                }
            };
            String _join = IterableExtensions.join((Iterable)_values_2, (CharSequence)"{ ", (CharSequence)", ", (CharSequence)" }", (Functions.Function1)_function);
            appendable.append(_join);
        }
    }

    protected void _toJavaLiteral(JvmLongAnnotationValue it, ITreeAppendable appendable) {
        boolean _equals;
        EList _values = it.getValues();
        int _size = _values.size();
        boolean bl = _equals = _size == 1;
        if (_equals) {
            EList _values_1 = it.getValues();
            Long _head = (Long)IterableExtensions.head((Iterable)_values_1);
            String _string = _head.toString();
            appendable.append(_string);
        } else {
            EList _values_2 = it.getValues();
            Functions.Function1<Long, String> _function = new Functions.Function1<Long, String>(){

                public String apply(Long it) {
                    String _string = it.toString();
                    return _string;
                }
            };
            String _join = IterableExtensions.join((Iterable)_values_2, (CharSequence)"{ ", (CharSequence)", ", (CharSequence)" }", (Functions.Function1)_function);
            appendable.append(_join);
        }
    }

    protected void _toJavaLiteral(JvmByteAnnotationValue it, ITreeAppendable appendable) {
        boolean _equals;
        EList _values = it.getValues();
        int _size = _values.size();
        boolean bl = _equals = _size == 1;
        if (_equals) {
            EList _values_1 = it.getValues();
            Byte _head = (Byte)IterableExtensions.head((Iterable)_values_1);
            String _string = _head.toString();
            appendable.append(_string);
        } else {
            EList _values_2 = it.getValues();
            Functions.Function1<Byte, String> _function = new Functions.Function1<Byte, String>(){

                public String apply(Byte it) {
                    String _string = it.toString();
                    return _string;
                }
            };
            String _join = IterableExtensions.join((Iterable)_values_2, (CharSequence)"{ ", (CharSequence)", ", (CharSequence)" }", (Functions.Function1)_function);
            appendable.append(_join);
        }
    }

    protected void _toJavaLiteral(JvmDoubleAnnotationValue it, ITreeAppendable appendable) {
        boolean _equals;
        EList _values = it.getValues();
        int _size = _values.size();
        boolean bl = _equals = _size == 1;
        if (_equals) {
            EList _values_1 = it.getValues();
            Double _head = (Double)IterableExtensions.head((Iterable)_values_1);
            String _string = _head.toString();
            appendable.append(_string);
        } else {
            EList _values_2 = it.getValues();
            Functions.Function1<Double, String> _function = new Functions.Function1<Double, String>(){

                public String apply(Double it) {
                    boolean _isNaN;
                    String _switchResult = null;
                    boolean _matched = false;
                    if (!_matched && (_isNaN = Double.isNaN(it))) {
                        _matched = true;
                        _switchResult = "Double.NaN";
                    }
                    if (!_matched && Objects.equal((Object)it, (Object)Double.POSITIVE_INFINITY)) {
                        _matched = true;
                        _switchResult = "Double.POSITIVE_INFINITY";
                    }
                    if (!_matched && Objects.equal((Object)it, (Object)Double.NEGATIVE_INFINITY)) {
                        _matched = true;
                        _switchResult = "Double.NEGATIVE_INFINITY";
                    }
                    if (!_matched) {
                        String _plus;
                        String _string = it.toString();
                        _switchResult = _plus = String.valueOf(_string) + "d";
                    }
                    return _switchResult;
                }
            };
            String _join = IterableExtensions.join((Iterable)_values_2, (CharSequence)"{ ", (CharSequence)", ", (CharSequence)" }", (Functions.Function1)_function);
            appendable.append(_join);
        }
    }

    protected void _toJavaLiteral(JvmFloatAnnotationValue it, ITreeAppendable appendable) {
        boolean _equals;
        EList _values = it.getValues();
        int _size = _values.size();
        boolean bl = _equals = _size == 1;
        if (_equals) {
            EList _values_1 = it.getValues();
            Float _head = (Float)IterableExtensions.head((Iterable)_values_1);
            String _string = _head.toString();
            appendable.append(_string);
        } else {
            EList _values_2 = it.getValues();
            Functions.Function1<Float, String> _function = new Functions.Function1<Float, String>(){

                public String apply(Float it) {
                    boolean _isNaN;
                    String _switchResult = null;
                    boolean _matched = false;
                    if (!_matched && (_isNaN = Float.isNaN(it.floatValue()))) {
                        _matched = true;
                        _switchResult = "Float.NaN";
                    }
                    if (!_matched && Objects.equal((Object)it, (Object)Float.valueOf(Float.POSITIVE_INFINITY))) {
                        _matched = true;
                        _switchResult = "Float.POSITIVE_INFINITY";
                    }
                    if (!_matched && Objects.equal((Object)it, (Object)Float.valueOf(Float.NEGATIVE_INFINITY))) {
                        _matched = true;
                        _switchResult = "Float.NEGATIVE_INFINITY";
                    }
                    if (!_matched) {
                        String _plus;
                        String _string = it.toString();
                        _switchResult = _plus = String.valueOf(_string) + "f";
                    }
                    return _switchResult;
                }
            };
            String _join = IterableExtensions.join((Iterable)_values_2, (CharSequence)"{ ", (CharSequence)", ", (CharSequence)" }", (Functions.Function1)_function);
            appendable.append(_join);
        }
    }

    protected void _toJavaLiteral(JvmCharAnnotationValue it, ITreeAppendable appendable) {
        boolean _equals;
        EList _values = it.getValues();
        int _size = _values.size();
        boolean bl = _equals = _size == 1;
        if (_equals) {
            EList _values_1 = it.getValues();
            Character _head = (Character)IterableExtensions.head((Iterable)_values_1);
            String _string = _head.toString();
            String _convertToJavaString = Strings.convertToJavaString((String)_string, (boolean)true);
            String _plus = "'" + _convertToJavaString;
            String _plus_1 = String.valueOf(_plus) + "'";
            appendable.append(_plus_1);
        } else {
            EList _values_2 = it.getValues();
            Functions.Function1<Character, String> _function = new Functions.Function1<Character, String>(){

                public String apply(Character it) {
                    String _string = it.toString();
                    String _convertToJavaString = Strings.convertToJavaString((String)_string, (boolean)true);
                    String _plus = "'" + _convertToJavaString;
                    String _plus_1 = String.valueOf(_plus) + "'";
                    return _plus_1;
                }
            };
            String _join = IterableExtensions.join((Iterable)_values_2, (CharSequence)"{ ", (CharSequence)", ", (CharSequence)" }", (Functions.Function1)_function);
            appendable.append(_join);
        }
    }

    protected void _toJavaLiteral(JvmStringAnnotationValue it, ITreeAppendable appendable) {
        boolean _equals;
        EList _values = it.getValues();
        int _size = _values.size();
        boolean bl = _equals = _size == 1;
        if (_equals) {
            EList _values_1 = it.getValues();
            String _head = (String)IterableExtensions.head((Iterable)_values_1);
            String _convertToJavaString = Strings.convertToJavaString((String)_head, (boolean)true);
            String _plus = "\"" + _convertToJavaString;
            String _plus_1 = String.valueOf(_plus) + "\"";
            appendable.append(_plus_1);
        } else {
            EList _values_2 = it.getValues();
            Functions.Function1<String, String> _function = new Functions.Function1<String, String>(){

                public String apply(String it) {
                    String _convertToJavaString = Strings.convertToJavaString((String)it, (boolean)true);
                    String _plus = "\"" + _convertToJavaString;
                    String _plus_1 = String.valueOf(_plus) + "\"";
                    return _plus_1;
                }
            };
            String _join = IterableExtensions.join((Iterable)_values_2, (CharSequence)"{ ", (CharSequence)", ", (CharSequence)" }", (Functions.Function1)_function);
            appendable.append(_join);
        }
    }

    protected void _toJavaLiteral(JvmTypeAnnotationValue it, final ITreeAppendable appendable) {
        boolean _notEquals;
        EList _values = it.getValues();
        int _size = _values.size();
        boolean bl = _notEquals = _size != 1;
        if (_notEquals) {
            boolean _not;
            appendable.append("{ ");
            EList _values_1 = it.getValues();
            boolean _isEmpty = _values_1.isEmpty();
            boolean bl2 = _not = !_isEmpty;
            if (_not) {
                EList _values_2 = it.getValues();
                JvmTypeReference _head = (JvmTypeReference)IterableExtensions.head((Iterable)_values_2);
                JvmType _type = _head.getType();
                appendable.append(_type);
                appendable.append(".class");
                EList _values_3 = it.getValues();
                Iterable _tail = IterableExtensions.tail((Iterable)_values_3);
                Procedures.Procedure1<JvmTypeReference> _function = new Procedures.Procedure1<JvmTypeReference>(){

                    public void apply(JvmTypeReference it) {
                        appendable.append(", ");
                        JvmType _type = it.getType();
                        appendable.append(_type);
                        appendable.append(".class");
                    }
                };
                IterableExtensions.forEach((Iterable)_tail, (Procedures.Procedure1)_function);
            }
            appendable.append(" }");
        } else {
            EList _values_4 = it.getValues();
            JvmTypeReference _head_1 = (JvmTypeReference)IterableExtensions.head((Iterable)_values_4);
            JvmType _type_1 = _head_1.getType();
            appendable.append(_type_1);
            appendable.append(".class");
        }
    }

    protected void _toJavaLiteral(JvmEnumAnnotationValue it, final ITreeAppendable appendable) {
        boolean _notEquals;
        EList _values = it.getValues();
        int _size = _values.size();
        boolean bl = _notEquals = _size != 1;
        if (_notEquals) {
            boolean _not;
            appendable.append("{ ");
            EList _values_1 = it.getValues();
            boolean _isEmpty = _values_1.isEmpty();
            boolean bl2 = _not = !_isEmpty;
            if (_not) {
                EList _values_2 = it.getValues();
                JvmEnumerationLiteral _head = (JvmEnumerationLiteral)IterableExtensions.head((Iterable)_values_2);
                JvmDeclaredType _declaringType = _head.getDeclaringType();
                appendable.append((JvmType)_declaringType);
                appendable.append(".");
                EList _values_3 = it.getValues();
                JvmEnumerationLiteral _head_1 = (JvmEnumerationLiteral)IterableExtensions.head((Iterable)_values_3);
                String _simpleName = _head_1.getSimpleName();
                appendable.append(_simpleName);
                EList _values_4 = it.getValues();
                Iterable _tail = IterableExtensions.tail((Iterable)_values_4);
                Procedures.Procedure1<JvmEnumerationLiteral> _function = new Procedures.Procedure1<JvmEnumerationLiteral>(){

                    public void apply(JvmEnumerationLiteral it) {
                        appendable.append(", ");
                        JvmDeclaredType _declaringType = it.getDeclaringType();
                        appendable.append((JvmType)_declaringType);
                        appendable.append(".");
                        String _simpleName = it.getSimpleName();
                        appendable.append(_simpleName);
                    }
                };
                IterableExtensions.forEach((Iterable)_tail, (Procedures.Procedure1)_function);
            }
            appendable.append(" }");
        } else {
            EList _values_5 = it.getValues();
            JvmEnumerationLiteral _head_2 = (JvmEnumerationLiteral)IterableExtensions.head((Iterable)_values_5);
            JvmDeclaredType _declaringType_1 = _head_2.getDeclaringType();
            appendable.append((JvmType)_declaringType_1);
            appendable.append(".");
            EList _values_6 = it.getValues();
            JvmEnumerationLiteral _head_3 = (JvmEnumerationLiteral)IterableExtensions.head((Iterable)_values_6);
            String _simpleName_1 = _head_3.getSimpleName();
            appendable.append(_simpleName_1);
        }
    }

    protected void _toJavaLiteral(JvmBooleanAnnotationValue it, ITreeAppendable appendable) {
        boolean _equals;
        EList _values = it.getValues();
        int _size = _values.size();
        boolean bl = _equals = _size == 1;
        if (_equals) {
            EList _values_1 = it.getValues();
            Boolean _head = (Boolean)IterableExtensions.head((Iterable)_values_1);
            String _string = _head.toString();
            appendable.append(_string);
        } else {
            EList _values_2 = it.getValues();
            Functions.Function1<Boolean, String> _function = new Functions.Function1<Boolean, String>(){

                public String apply(Boolean it) {
                    String _string = it.toString();
                    return _string;
                }
            };
            String _join = IterableExtensions.join((Iterable)_values_2, (CharSequence)"{ ", (CharSequence)", ", (CharSequence)" }", (Functions.Function1)_function);
            appendable.append(_join);
        }
    }

    protected void _toJavaLiteral(JvmCustomAnnotationValue it, final ITreeAppendable appendable) {
        int _size;
        EList _values = it.getValues();
        int _switchValue = _size = _values.size();
        boolean _matched = false;
        if (!_matched && Objects.equal((Object)_switchValue, (Object)0)) {
            _matched = true;
            appendable.append("{}");
        }
        if (!_matched && Objects.equal((Object)_switchValue, (Object)1)) {
            _matched = true;
            EList _values_1 = it.getValues();
            Object _head = IterableExtensions.head((Iterable)_values_1);
            this.compiler.toJavaExpression((XExpression)_head, appendable);
        }
        if (!_matched) {
            appendable.append("{ ");
            EList _values_2 = it.getValues();
            Object _head_1 = IterableExtensions.head((Iterable)_values_2);
            this.compiler.toJavaExpression((XExpression)_head_1, appendable);
            EList _values_3 = it.getValues();
            Iterable _tail = IterableExtensions.tail((Iterable)_values_3);
            Iterable _filter = Iterables.filter((Iterable)_tail, XExpression.class);
            Procedures.Procedure1<XExpression> _function = new Procedures.Procedure1<XExpression>(){

                public void apply(XExpression it) {
                    appendable.append(", ");
                    JvmModelGenerator.this.compiler.toJavaExpression(it, appendable);
                }
            };
            IterableExtensions.forEach((Iterable)_filter, (Procedures.Procedure1)_function);
            appendable.append(" }");
        }
    }

    public void serialize(JvmTypeReference it, ITreeAppendable appendable) {
        boolean _equals = Objects.equal((Object)it, null);
        if (_equals) {
            NullPointerException _nullPointerException = new NullPointerException();
            LOG.warn((Object)"type was null", (Throwable)_nullPointerException);
            appendable.append("Object /* problem during compilation, see error log*/");
        } else {
            EObject _eContainer = it.eContainer();
            this.typeRefSerializer.serialize(it, _eContainer, appendable);
        }
    }

    public TreeAppendable createAppendable(EObject context, ImportManager importManager) {
        boolean _notEquals;
        TreeAppendable _treeAppendable;
        TreeAppendable appendable = _treeAppendable = new TreeAppendable(importManager, this.locationProvider, this.jvmModelAssociations, context, "  ", "\n");
        JvmGenericType type = this.containerType(context);
        boolean bl = _notEquals = !Objects.equal((Object)type, null);
        if (_notEquals) {
            boolean _notEquals_1;
            JvmGenericType _containerType = this.containerType(context);
            appendable.declareVariable(_containerType, "this");
            JvmGenericType _containerType_1 = this.containerType(context);
            JvmTypeReference superType = _containerType_1.getExtendedClass();
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)superType, null);
            if (_notEquals_1) {
                JvmType _type = superType.getType();
                appendable.declareVariable(_type, "super");
            }
        }
        return appendable;
    }

    public JvmGenericType containerType(EObject context) {
        JvmGenericType _xifexpression = null;
        boolean _equals = Objects.equal((Object)context, null);
        if (_equals) {
            _xifexpression = null;
        } else {
            JvmGenericType _xifexpression_1 = null;
            if (context instanceof JvmGenericType) {
                _xifexpression_1 = (JvmGenericType)context;
            } else {
                JvmGenericType _containerType;
                EObject _eContainer = context.eContainer();
                _xifexpression_1 = _containerType = this.containerType(_eContainer);
            }
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    protected String makeJavaIdentifier(String name) {
        String _plus;
        String _xifexpression = null;
        boolean _isJavaKeyword = this.keywords.isJavaKeyword(name);
        _xifexpression = _isJavaKeyword ? (_plus = String.valueOf(name) + "_") : name;
        return _xifexpression;
    }

    public void internalDoGenerate(EObject type, IFileSystemAccess fsa) {
        if (type instanceof JvmEnumerationType) {
            this._internalDoGenerate((JvmEnumerationType)type, fsa);
            return;
        }
        if (type instanceof JvmGenericType) {
            this._internalDoGenerate((JvmGenericType)type, fsa);
            return;
        }
        if (type != null) {
            this._internalDoGenerate(type, fsa);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(type, fsa).toString());
    }

    public ITreeAppendable generateBody(JvmDeclaredType it, ITreeAppendable appendable) {
        if (it instanceof JvmEnumerationType) {
            return this._generateBody((JvmEnumerationType)it, appendable);
        }
        if (it instanceof JvmGenericType) {
            return this._generateBody((JvmGenericType)it, appendable);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it, appendable).toString());
    }

    public ITreeAppendable generateModifier(JvmMember it, ITreeAppendable appendable) {
        if (it instanceof JvmConstructor) {
            return this._generateModifier((JvmConstructor)it, appendable);
        }
        if (it instanceof JvmOperation) {
            return this._generateModifier((JvmOperation)it, appendable);
        }
        if (it instanceof JvmDeclaredType) {
            return this._generateModifier((JvmDeclaredType)it, appendable);
        }
        if (it instanceof JvmField) {
            return this._generateModifier((JvmField)it, appendable);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it, appendable).toString());
    }

    public boolean generateMember(JvmMember it, ITreeAppendable appendable, boolean first) {
        if (it instanceof JvmConstructor) {
            return this._generateMember((JvmConstructor)it, appendable, first);
        }
        if (it instanceof JvmGenericType) {
            return this._generateMember((JvmGenericType)it, appendable, first);
        }
        if (it instanceof JvmOperation) {
            return this._generateMember((JvmOperation)it, appendable, first);
        }
        if (it instanceof JvmField) {
            return this._generateMember((JvmField)it, appendable, first);
        }
        if (it != null) {
            return this._generateMember(it, appendable, first);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it, appendable, first).toString());
    }

    public void toJavaLiteral(JvmAnnotationValue it, ITreeAppendable appendable) {
        if (it instanceof JvmAnnotationAnnotationValue) {
            this._toJavaLiteral((JvmAnnotationAnnotationValue)it, appendable);
            return;
        }
        if (it instanceof JvmBooleanAnnotationValue) {
            this._toJavaLiteral((JvmBooleanAnnotationValue)it, appendable);
            return;
        }
        if (it instanceof JvmByteAnnotationValue) {
            this._toJavaLiteral((JvmByteAnnotationValue)it, appendable);
            return;
        }
        if (it instanceof JvmCharAnnotationValue) {
            this._toJavaLiteral((JvmCharAnnotationValue)it, appendable);
            return;
        }
        if (it instanceof JvmCustomAnnotationValue) {
            this._toJavaLiteral((JvmCustomAnnotationValue)it, appendable);
            return;
        }
        if (it instanceof JvmDoubleAnnotationValue) {
            this._toJavaLiteral((JvmDoubleAnnotationValue)it, appendable);
            return;
        }
        if (it instanceof JvmEnumAnnotationValue) {
            this._toJavaLiteral((JvmEnumAnnotationValue)it, appendable);
            return;
        }
        if (it instanceof JvmFloatAnnotationValue) {
            this._toJavaLiteral((JvmFloatAnnotationValue)it, appendable);
            return;
        }
        if (it instanceof JvmIntAnnotationValue) {
            this._toJavaLiteral((JvmIntAnnotationValue)it, appendable);
            return;
        }
        if (it instanceof JvmLongAnnotationValue) {
            this._toJavaLiteral((JvmLongAnnotationValue)it, appendable);
            return;
        }
        if (it instanceof JvmShortAnnotationValue) {
            this._toJavaLiteral((JvmShortAnnotationValue)it, appendable);
            return;
        }
        if (it instanceof JvmStringAnnotationValue) {
            this._toJavaLiteral((JvmStringAnnotationValue)it, appendable);
            return;
        }
        if (it instanceof JvmTypeAnnotationValue) {
            this._toJavaLiteral((JvmTypeAnnotationValue)it, appendable);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it, appendable).toString());
    }
}

