/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.framework.jar;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.birt.core.framework.IBundle;
import org.eclipse.birt.core.framework.IConfigurationElement;
import org.eclipse.birt.core.framework.IExtension;
import org.eclipse.birt.core.framework.IExtensionRegistry;
import org.eclipse.birt.core.framework.IPlatform;
import org.eclipse.birt.core.framework.IPlatformPath;
import org.eclipse.birt.core.framework.PlatformConfig;
import org.eclipse.birt.core.framework.eclipse.EclipseExtensionRegistry;
import org.eclipse.birt.core.framework.jar.Bundle;
import org.eclipse.birt.core.framework.jar.BundleLoader;
import org.eclipse.birt.core.framework.jar.ExtensionRegistry;
import org.eclipse.core.internal.runtime.AdapterManager;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.Platform;
import org.xml.sax.SAXException;

public class ServicePlatform
implements IPlatform {
    protected static Logger logger = Logger.getLogger(IPlatform.class.getName());
    protected PlatformConfig config;
    protected HashMap<String, Bundle> bundles = new HashMap();
    protected ExtensionRegistry extensionRegistry = new ExtensionRegistry();
    protected File workspace;

    ServicePlatform(PlatformConfig config) {
        this.config = config;
    }

    public void installBundle(URL root) throws IOException, ParserConfigurationException, SAXException {
        Bundle bundle = new BundleLoader(this, root).load();
        if (bundle != null) {
            this.bundles.put(bundle.getSymbolicName(), bundle);
            this.extensionRegistry.addBundle(bundle);
        }
    }

    public IBundle getBundle(String symbolicName) {
        return this.bundles.get(symbolicName);
    }

    public IExtensionRegistry getExtensionRegistry() {
        return new EclipseExtensionRegistry(Platform.getExtensionRegistry());
    }

    public IAdapterManager getAdapterManager() {
        return AdapterManager.getDefault();
    }

    public URL asLocalURL(URL url) throws IOException {
        return url;
    }

    public String getDebugOption(String name) {
        return null;
    }

    public void initializeTracing(String pluginName) {
    }

    public Object createFactoryObject(String extensionId) {
        try {
            IConfigurationElement[] configs;
            IExtensionRegistry registry = this.getExtensionRegistry();
            String extensionPointId = "org.eclipse.birt.core.FactoryService";
            IExtension factoryExt = registry.getExtension(extensionPointId, extensionId);
            if (factoryExt != null && (configs = factoryExt.getConfigurationElements()) != null && configs.length > 0) {
                IConfigurationElement config = configs[0];
                Object factory = config.createExecutableExtension("class");
                return factory;
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, ex.getMessage(), ex);
        }
        return null;
    }

    public Object enterPlatformContext() {
        return null;
    }

    public void exitPlatformContext(Object context) {
    }

    public String getOS() {
        String os = System.getProperty("os.name");
        if (os == null) {
            return "unknown";
        }
        if (os.startsWith("Windows")) {
            return "win32";
        }
        if (os.equals("Linux")) {
            return "linux";
        }
        if (os.equals("AIX")) {
            return "aix";
        }
        if (os.equals("SunOS") || os.equals("Solaris")) {
            return "solaris";
        }
        if (os.equals("HP-UX")) {
            return "hpux";
        }
        if (os.equals("Mac OS") || os.equals("Mac OS X")) {
            return "macosx";
        }
        return "unknown";
    }

    public URL find(String bundleId, String path) {
        Bundle bundle = (Bundle)this.getBundle(bundleId);
        if (bundle != null) {
            try {
                return new URL(bundle.root, path);
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        }
        return null;
    }

    public URL toFileURL(URL url) {
        if ("file".equals(url.getProtocol())) {
            return url;
        }
        return null;
    }

    public URL find(IBundle bundle, IPlatformPath path) {
        return null;
    }

    public File getWorkspace() {
        return this.workspace;
    }

    public void startup() {
        String tempDir = this.config.getTempDir();
        UUID uuid = UUID.randomUUID();
        String workPath = "workspace_" + uuid.toString();
        this.workspace = new File(new File(tempDir), workPath);
        this.workspace.mkdirs();
        this.workspace.deleteOnExit();
    }

    public void shutdown() {
        if (this.workspace != null) {
            this.removeFile(this.workspace);
            this.workspace = null;
        }
    }

    protected void removeFile(File file) {
        File[] files;
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File childFile = fileArray[n2];
                this.removeFile(childFile);
                ++n2;
            }
        }
        file.delete();
    }
}

