/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.refactoring.ui;

import com.google.inject.Inject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.xtext.ui.refactoring.impl.ProjectUtil;
import org.eclipse.xtext.ui.refactoring.ui.IRenameElementContext;
import org.eclipse.xtext.ui.refactoring.ui.RefactoringPreferences;
import org.eclipse.xtext.ui.util.DisplayRunnable;

public class SaveHelper {
    @Inject
    private ProjectUtil projectUtil;
    @Inject
    private RefactoringPreferences prefs;
    @Inject(optional=true)
    private IWorkbench workbench;

    public void saveEditors(final IRenameElementContext context) {
        new DisplayRunnable(){

            protected void run() throws Exception {
                IWorkbenchPage workbenchPage = SaveHelper.this.getWorkbenchPage(context);
                if (SaveHelper.this.prefs.isSaveAllBeforeRefactoring()) {
                    workbenchPage.saveAllEditors(false);
                } else {
                    SaveHelper.this.saveDeclaringEditor(context, workbenchPage);
                }
            }
        }.syncExec();
        SaveHelper.waitForAutoBuild();
    }

    protected IWorkbenchPage getWorkbenchPage(IRenameElementContext context) {
        IEditorPart triggeringEditor = context.getTriggeringEditor();
        return triggeringEditor == null ? this.workbench.getActiveWorkbenchWindow().getActivePage() : triggeringEditor.getEditorSite().getPage();
    }

    protected void saveDeclaringEditor(IRenameElementContext context, IWorkbenchPage workbenchPage) {
        IEditorPart declaringEditor = this.getOpenEditor(context.getTargetElementURI(), workbenchPage);
        if (declaringEditor != null && declaringEditor.isDirty()) {
            declaringEditor.doSave((IProgressMonitor)new NullProgressMonitor());
        }
    }

    protected IEditorPart getOpenEditor(URI uri, IWorkbenchPage page) {
        IFile file = this.projectUtil.findFileStorage(uri.trimFragment(), true);
        if (file != null) {
            FileEditorInput fileEditorInput = new FileEditorInput(file);
            return page.findEditor((IEditorInput)fileEditorInput);
        }
        return null;
    }

    protected static void waitForAutoBuild() {
        boolean wasInterrupted = false;
        do {
            try {
                Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, null);
                wasInterrupted = false;
            }
            catch (OperationCanceledException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                wasInterrupted = true;
            }
        } while (wasInterrupted);
    }
}

