/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.reconciler;

import org.apache.log4j.Logger;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;

public class ReplaceRegion
implements ITypedRegion {
    private static final Logger log = Logger.getLogger(ReplaceRegion.class);
    public static final String REPLACE = "__replace";
    private int offset;
    private int originalLength;
    private String text;

    public ReplaceRegion(int offset, int originalLength, String text) {
        this.offset = offset;
        this.originalLength = originalLength;
        this.text = text;
    }

    public String getType() {
        return REPLACE;
    }

    public void mergeWith(ReplaceRegion next, Object textAfterNextChange) {
        try {
            int mergedOffset = Math.min(this.offset, this.toOriginalIndex(next.offset));
            int mergedEnd = Math.max(this.offset + this.originalLength, this.toOriginalIndex(next.offset + next.originalLength));
            int mergedLength = mergedEnd - mergedOffset;
            int replacementOffset = Math.min(this.toReplacedIndex(this.offset), next.offset);
            int replacementEnd = Math.max(next.toReplacedIndex(this.offset + this.text.length()), next.offset + next.text.length());
            this.text = textAfterNextChange instanceof IDocument ? ((IDocument)textAfterNextChange).get(replacementOffset, replacementEnd - replacementOffset) : ((String)textAfterNextChange).substring(replacementOffset, replacementEnd);
            this.offset = mergedOffset;
            this.originalLength = mergedLength;
        }
        catch (Exception e) {
            log.error((Object)"Cannot merge ReplaceRegions", (Throwable)e);
        }
    }

    protected int toOriginalIndex(int indexAfterReplace) {
        return ReplaceRegion.toOriginalIndex(indexAfterReplace, this.offset, this.originalLength, this.text.length());
    }

    protected int toReplacedIndex(int originalIndex) {
        return ReplaceRegion.toOriginalIndex(originalIndex, this.offset, this.text.length(), this.originalLength);
    }

    private static int toOriginalIndex(int indexAfterReplace, int offset, int originalLength, int replacementLength) {
        if (originalLength < replacementLength) {
            if (indexAfterReplace <= offset + originalLength) {
                return indexAfterReplace;
            }
            if (indexAfterReplace < offset + replacementLength) {
                return offset + originalLength;
            }
            return indexAfterReplace + (originalLength - replacementLength);
        }
        if (originalLength > replacementLength) {
            if (indexAfterReplace <= offset + replacementLength) {
                return indexAfterReplace;
            }
            return indexAfterReplace + (originalLength - replacementLength);
        }
        return indexAfterReplace + (originalLength - replacementLength);
    }

    public int getOffset() {
        return this.offset;
    }

    public String getText() {
        return this.text;
    }

    public int getLength() {
        return this.originalLength;
    }
}

