/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.bidi.internal.consumable;

import org.eclipse.equinox.bidi.advanced.ISTextExpert;
import org.eclipse.equinox.bidi.custom.STextCharTypes;
import org.eclipse.equinox.bidi.custom.STextTypeHandler;

public class STextMath
extends STextTypeHandler {
    static final byte L = 0;
    static final byte R = 1;
    static final byte AL = 2;
    static final byte AN = 6;

    public STextMath() {
        super("+-/*()=");
    }

    public int getDirection(ISTextExpert expert, String text) {
        return this.getDirection(expert, text, new STextCharTypes(expert, text));
    }

    public int getDirection(ISTextExpert expert, String text, STextCharTypes charTypes) {
        String language = expert.getEnvironment().getLanguage();
        if (!language.equals("ar")) {
            return 0;
        }
        boolean flagAN = false;
        int i = 0;
        while (i < text.length()) {
            byte charType = charTypes.getBidiTypeAt(i);
            if (charType == 2) {
                return 1;
            }
            if (charType == 0 || charType == 1) {
                return 0;
            }
            if (charType == 6) {
                flagAN = true;
            }
            ++i;
        }
        if (flagAN) {
            return 1;
        }
        return 0;
    }
}

