/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.gogo.shell;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.felix.gogo.options.Option;
import org.apache.felix.gogo.options.Options;
import org.apache.felix.gogo.shell.Shell;
import org.apache.felix.service.command.CommandSession;

public class Builtin {
    static final String[] functions = new String[]{"format", "getopt", "new", "set", "tac", "type"};
    private static final String[] packages = new String[]{"java.lang", "java.io", "java.net", "java.util"};
    private static final Set<String> KEYWORDS = new HashSet<String>(Arrays.asList("abstract", "continue", "for", "new", "switch", "assert", "default", "goto", "package", "synchronized", "boolean", "do", "if", "private", "this", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "class", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while"));

    public CharSequence format(CommandSession session) {
        return this.format(session, session.get("_"));
    }

    public CharSequence format(CommandSession session, Object arg) {
        CharSequence result = session.format(arg, 0);
        System.out.println(result);
        return result;
    }

    public Option getopt(List<Object> spec, Object[] args) {
        String[] optSpec = new String[spec.size()];
        for (int i = 0; i < optSpec.length; ++i) {
            optSpec[i] = spec.get(i).toString();
        }
        return Options.compile(optSpec).parse(args);
    }

    public Object _new(Object name, Object[] argv) throws Exception {
        Class<?> clazz = null;
        clazz = name instanceof Class ? (Class<?>)name : this.loadClass(name.toString());
        for (Constructor<?> c : clazz.getConstructors()) {
            Class<?>[] types = c.getParameterTypes();
            if (types.length != argv.length) continue;
            boolean match = true;
            for (int i = 0; i < argv.length; ++i) {
                if (types[i].isAssignableFrom(argv[i].getClass())) continue;
                if (!types[i].isAssignableFrom(String.class)) {
                    match = false;
                    break;
                }
                argv[i] = argv[i].toString();
            }
            if (!match) continue;
            try {
                return c.newInstance(argv);
            }
            catch (InvocationTargetException ite) {
                Throwable cause = ite.getCause();
                if (cause instanceof Exception) {
                    throw (Exception)cause;
                }
                throw ite;
            }
        }
        throw new IllegalArgumentException("can't coerce " + Arrays.asList(argv) + " to any of " + Arrays.asList(clazz.getConstructors()));
    }

    private Class<?> loadClass(String name) throws ClassNotFoundException {
        if (!name.contains(".")) {
            for (String p : packages) {
                String pkg = p + "." + name;
                try {
                    return Class.forName(pkg);
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
        }
        return Class.forName(name);
    }

    public void set(CommandSession session, String[] argv) throws Exception {
        String prefix;
        String[] usage = new String[]{"set - show session variables", "Usage: set [OPTIONS] [PREFIX]", "  -? --help                show help", "  -a --all                 show all variables, including those starting with .", "  -x                       set xtrace option", "  +x                       unset xtrace option", "If PREFIX given, then only show variable(s) starting with PREFIX"};
        Option opt = Options.compile(usage).parse(argv);
        if (opt.isSet("help")) {
            opt.usage();
            return;
        }
        List<String> args = opt.args();
        String string = prefix = args.isEmpty() ? "" : args.get(0);
        if (opt.isSet("x")) {
            session.put("echo", (Object)true);
        } else if ("+x".equals(prefix)) {
            session.put("echo", null);
        } else {
            boolean all = opt.isSet("all");
            for (String key : new TreeSet<String>(Shell.getVariables(session))) {
                if (!key.startsWith(prefix) || key.startsWith(".") && !all && prefix.length() <= 0) continue;
                Object target = session.get(key);
                String type = null;
                String value = null;
                if (target != null) {
                    Class<?> clazz = target.getClass();
                    type = clazz.getSimpleName();
                    value = target.toString();
                }
                String trunc = value == null || value.length() < 55 ? "" : "...";
                System.out.println(String.format("%-15.15s %-15s %.45s%s", type, key, value, trunc));
            }
        }
    }

    public Object tac(CommandSession session, String[] argv) throws IOException {
        String s;
        String[] usage = new String[]{"tac - capture stdin as String or List and optionally write to file.", "Usage: tac [-al] [FILE]", "  -a --append              append to FILE", "  -l --list                return List<String>", "  -? --help                show help"};
        Option opt = Options.compile(usage).parse(argv);
        if (opt.isSet("help")) {
            opt.usage();
            return null;
        }
        List<String> args = opt.args();
        BufferedWriter fw = null;
        if (args.size() == 1) {
            String path = args.get(0);
            File file = new File(Shell.cwd(session).resolve(path));
            fw = new BufferedWriter(new FileWriter(file, opt.isSet("append")));
        }
        StringWriter sw = new StringWriter();
        BufferedReader rdr = new BufferedReader(new InputStreamReader(System.in));
        ArrayList<String> list = null;
        if (opt.isSet("list")) {
            list = new ArrayList<String>();
        }
        boolean first = true;
        while ((s = rdr.readLine()) != null) {
            if (list != null) {
                list.add(s);
            } else {
                if (!first) {
                    sw.write(32);
                }
                first = false;
                sw.write(s);
            }
            if (fw == null) continue;
            fw.write(s);
            fw.newLine();
        }
        if (fw != null) {
            fw.close();
        }
        return list != null ? list : sw.toString();
    }

    public boolean type(CommandSession session, String[] argv) throws Exception {
        String arg;
        String[] usage = new String[]{"type - show command type", "Usage: type [OPTIONS] [name[:]]", "  -a --all                 show all matches", "  -? --help                show help", "  -q --quiet               don't print anything, just return status", "  -s --scope=NAME          list all commands in named scope", "  -t --types               show full java type names"};
        Option opt = Options.compile(usage).parse(argv);
        List<String> args = opt.args();
        if (opt.isSet("help")) {
            opt.usage();
            return true;
        }
        boolean all = opt.isSet("all");
        String optScope = null;
        if (opt.isSet("scope")) {
            optScope = opt.get("scope");
        }
        if (args.size() == 1 && (arg = args.get(0)).endsWith(":")) {
            optScope = args.remove(0);
        }
        if (optScope != null || args.isEmpty() && all) {
            TreeSet<String> snames = new TreeSet<String>();
            for (String string : Builtin.getCommands(session)) {
                if (optScope != null && !string.startsWith(optScope)) continue;
                snames.add(string);
            }
            for (String string : snames) {
                System.out.println(string);
            }
            return true;
        }
        if (args.size() == 0) {
            TreeMap<String, Integer> scopes = new TreeMap<String, Integer>();
            for (String string : Builtin.getCommands(session)) {
                int colon;
                String scope = string.substring(0, colon = string.indexOf(58));
                Integer count = (Integer)scopes.get(scope);
                if (count == null) {
                    count = 0;
                }
                count = count + 1;
                scopes.put(scope, count);
            }
            for (Map.Entry entry : scopes.entrySet()) {
                System.out.println((String)entry.getKey() + ":" + entry.getValue());
            }
            return true;
        }
        String name = args.get(0).toLowerCase();
        int colon = name.indexOf(58);
        String string = "_main";
        StringBuilder buf = new StringBuilder();
        LinkedHashSet<String> cmds = new LinkedHashSet<String>();
        if (colon != -1 || session.get(name) != null) {
            cmds.add(name);
        } else if (session.get("_main") != null) {
            cmds.add("_main");
        } else {
            String path = session.get("SCOPE") != null ? session.get("SCOPE").toString() : "*";
            block4: for (String s : path.split(":")) {
                if (s.equals("*")) {
                    for (String sname : Builtin.getCommands(session)) {
                        if (!sname.endsWith(":" + name)) continue;
                        cmds.add(sname);
                        if (all) continue;
                        continue block4;
                    }
                    continue;
                }
                String sname = s + ":" + name;
                if (session.get(sname) == null) continue;
                cmds.add(sname);
                if (!all) break;
            }
        }
        for (String key : cmds) {
            Object target = session.get(key);
            if (target == null) continue;
            CharSequence source = this.getClosureSource(session, key);
            if (source != null) {
                buf.append(name);
                buf.append(" is function {");
                buf.append(source);
                buf.append("}");
                continue;
            }
            for (Method m : this.getMethods(session, key)) {
                StringBuilder params = new StringBuilder();
                for (Class<?> type : m.getParameterTypes()) {
                    if (params.length() > 0) {
                        params.append(", ");
                    }
                    params.append(type.getSimpleName());
                }
                String rtype = m.getReturnType().getSimpleName();
                if (buf.length() > 0) {
                    buf.append("\n");
                }
                if (opt.isSet("types")) {
                    String cname = m.getDeclaringClass().getName();
                    buf.append(String.format("%s %s.%s(%s)", rtype, cname, m.getName(), params));
                    continue;
                }
                buf.append(String.format("%s is %s %s(%s)", name, rtype, key, params));
            }
        }
        if (buf.length() > 0) {
            if (!opt.isSet("quiet")) {
                System.out.println(buf);
            }
            return true;
        }
        if (!opt.isSet("quiet")) {
            System.err.println("type: " + name + " not found.");
        }
        return false;
    }

    static Set<String> getCommands(CommandSession session) {
        return (Set)session.get(".commands");
    }

    private boolean isClosure(Object target) {
        return target.getClass().getSimpleName().equals("Closure");
    }

    private boolean isCommand(Object target) {
        return target.getClass().getSimpleName().equals("CommandProxy");
    }

    private CharSequence getClosureSource(CommandSession session, String name) throws Exception {
        Object target = session.get(name);
        if (target == null) {
            return null;
        }
        if (!this.isClosure(target)) {
            return null;
        }
        Field sourceField = target.getClass().getDeclaredField("source");
        sourceField.setAccessible(true);
        return (CharSequence)sourceField.get(target);
    }

    private List<Method> getMethods(CommandSession session, String scmd) throws Exception {
        Method[] methods;
        int colon = scmd.indexOf(58);
        String function = colon == -1 ? scmd : scmd.substring(colon + 1);
        String name = KEYWORDS.contains(function) ? "_" + function : function;
        String get = "get" + function;
        String is = "is" + function;
        String set = "set" + function;
        String MAIN = "_main";
        Object target = session.get(scmd);
        if (target == null) {
            return null;
        }
        if (this.isClosure(target)) {
            return null;
        }
        if (this.isCommand(target)) {
            Method method = target.getClass().getMethod("getTarget", null);
            method.setAccessible(true);
            target = method.invoke(target, (Object[])null);
        }
        ArrayList<Method> list = new ArrayList<Method>();
        Class<?> tc = target instanceof Class ? (Class<?>)target : target.getClass();
        for (Method m : methods = tc.getMethods()) {
            String mname = m.getName().toLowerCase();
            if (!mname.equals(name) && !mname.equals(get) && !mname.equals(set) && !mname.equals(is) && !mname.equals("_main")) continue;
            list.add(m);
        }
        return list;
    }
}

