/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.definitions.lattice.impl;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.stem.core.STEMURI;
import org.eclipse.stem.core.common.DublinCore;
import org.eclipse.stem.core.graph.Edge;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.graph.GraphFactory;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.definitions.Activator;
import org.eclipse.stem.definitions.adapters.spatial.geo.InlineLatLongDataProvider;
import org.eclipse.stem.definitions.adapters.spatial.geo.LatLong;
import org.eclipse.stem.definitions.adapters.spatial.geo.LatLongProvider;
import org.eclipse.stem.definitions.adapters.spatial.geo.LatLongProviderAdapter;
import org.eclipse.stem.definitions.adapters.spatial.geo.LatLongProviderAdapterFactory;
import org.eclipse.stem.definitions.labels.AreaLabel;
import org.eclipse.stem.definitions.labels.LabelsFactory;
import org.eclipse.stem.definitions.lattice.impl.GraphLatticeGenerator;
import org.eclipse.stem.definitions.nodes.Region;

public class LatticeGeneratorUtilityImpl
extends GraphLatticeGenerator {
    private static final String URI_SQR_PREFIX = "LAT_SQR_";
    private static final String URI_GLBL_PREFIX = "LAT_GLB_";
    public String LATTICE_TYPE = "Square Lattice";
    public static final double DEGREES_TO_RADIANS = Math.PI / 180;
    public static final String DEFAULT_POPULATION_NAME = "human";
    public static String POPULATION_NAME = "human";
    public static final double DEFAULT_POPULATION_COUNT = 1.0;
    public static final double KM_PER_DEG_LAT = 111.13508055555556;
    public static final double KM_PER_DEG_LON = 111.13508055555556;

    public LatticeGeneratorUtilityImpl(String type) {
        this.LATTICE_TYPE = type;
    }

    @Override
    public Graph getGraph(int xSize, int ySize, double area, boolean addNearestNeighbors, boolean addNextNearestNeighbors, boolean periodicBoundaries) {
        int y;
        Graph graph = GraphFactory.eINSTANCE.createGraph();
        DublinCore dc = graph.getDublinCore();
        dc.populate();
        dc.setTitle(this.LATTICE_TYPE);
        dc.setSource(this.getClass().getSimpleName());
        Calendar c = Calendar.getInstance();
        SimpleDateFormat formatter = new SimpleDateFormat("E yyyy.MM.dd 'at' hh:mm:ss a zzz");
        String valid = formatter.format(c.getTime());
        dc.setValid(valid);
        Node[][] nodeHolder = new Node[xSize][ySize];
        int x = 0;
        while (x < xSize) {
            int y2 = 0;
            while (y2 < ySize) {
                Region regionNode = LatticeGeneratorUtilityImpl.createRegionNode(URI_SQR_PREFIX, x, y2, graph);
                AreaLabel areaLabel = LabelsFactory.eINSTANCE.createAreaLabel();
                areaLabel.getCurrentAreaValue().setArea(area);
                areaLabel.setURI(STEMURI.createURI((String)("label/" + STEMURI.generateUniquePart())));
                regionNode.getLabels().add((Object)areaLabel);
                nodeHolder[x][y2] = regionNode;
                graph.putNode((Node)regionNode);
                ++y2;
            }
            ++x;
        }
        double borderLength = Math.sqrt(area);
        if (borderLength < 1.0) {
            borderLength = 1.0;
        }
        int commonBorderLength = (int)borderLength;
        if (addNearestNeighbors) {
            int x2 = 0;
            while (x2 < xSize) {
                y = 0;
                while (y < ySize) {
                    if (y - 1 >= 0) {
                        LatticeGeneratorUtilityImpl.createEdge(graph, nodeHolder[x2][y - 1], nodeHolder[x2][y], commonBorderLength);
                    } else if (periodicBoundaries) {
                        LatticeGeneratorUtilityImpl.createEdge(graph, nodeHolder[x2][ySize - 1], nodeHolder[x2][y], commonBorderLength);
                    }
                    if (x2 - 1 >= 0) {
                        LatticeGeneratorUtilityImpl.createEdge(graph, nodeHolder[x2 - 1][y], nodeHolder[x2][y], commonBorderLength);
                    } else if (periodicBoundaries) {
                        LatticeGeneratorUtilityImpl.createEdge(graph, nodeHolder[xSize - 1][y], nodeHolder[x2][y], commonBorderLength);
                    }
                    ++y;
                }
                ++x2;
            }
        }
        if (addNextNearestNeighbors) {
            int x3 = 0;
            while (x3 < xSize) {
                y = 0;
                while (y < ySize) {
                    int y2;
                    int x2;
                    if (x3 + 1 < xSize && y + 1 < ySize) {
                        LatticeGeneratorUtilityImpl.createEdge(graph, nodeHolder[x3][y], nodeHolder[x3 + 1][y + 1], commonBorderLength);
                    } else if (periodicBoundaries) {
                        x2 = x3 + 1;
                        y2 = y + 1;
                        if (x2 >= xSize) {
                            x2 = 0;
                        }
                        if (y2 >= ySize) {
                            y2 = 0;
                        }
                        LatticeGeneratorUtilityImpl.createEdge(graph, nodeHolder[x3][y], nodeHolder[x2][y2], commonBorderLength);
                    }
                    if (x3 + 1 < xSize && y - 1 >= 0) {
                        LatticeGeneratorUtilityImpl.createEdge(graph, nodeHolder[x3][y], nodeHolder[x3 + 1][y - 1], commonBorderLength);
                    } else if (periodicBoundaries) {
                        x2 = x3 + 1;
                        y2 = y - 1;
                        if (x2 >= xSize) {
                            x2 = 0;
                        }
                        if (y2 <= -1) {
                            y2 = ySize - 1;
                        }
                        LatticeGeneratorUtilityImpl.createEdge(graph, nodeHolder[x3][y], nodeHolder[x2][y2], commonBorderLength);
                    }
                    ++y;
                }
                ++x3;
            }
        }
        LatticeGeneratorUtilityImpl.addSpatialSpecifications(nodeHolder, xSize, ySize, area);
        assert (graph.sane());
        return graph;
    }

    private static void addSpatialSpecifications(Node[][] nodeHolder, int xSize, int ySize, double area) {
        double scale = Math.sqrt(area);
        int x = 0;
        while (x < xSize) {
            int y = 0;
            while (y < ySize) {
                Node node = nodeHolder[x][y];
                LatLong nodeSegments = LatticeGeneratorUtilityImpl.createNodePolygon(x, y, scale);
                String spatialURIString = InlineLatLongDataProvider.createSpatialInlineURIString(nodeSegments);
                node.getDublinCore().setSpatial(spatialURIString);
                ++y;
            }
            ++x;
        }
    }

    private static void addSpatialSpecifications(Node[][] nodeHolder, int angularStep, int latSize, int lngSize) {
        int offset = angularStep / 2;
        int lat = -90;
        int lng = -180;
        int x = 0;
        while (x < latSize) {
            int y = 0;
            while (y < lngSize) {
                Node node = nodeHolder[x][y];
                LatLong nodeSegments = LatticeGeneratorUtilityImpl.createPlateCarreePolygon(lat + offset, lng + offset, angularStep);
                String spatialURIString = InlineLatLongDataProvider.createSpatialInlineURIString(nodeSegments);
                node.getDublinCore().setSpatial(spatialURIString);
                lng += angularStep;
                ++y;
            }
            lat += angularStep;
            lng = -180;
            ++x;
        }
    }

    private static LatLong createNodePolygon(double xi, double yi, double scale) {
        LatLong retValue = new LatLong();
        LatLong.SegmentBuilder sb = new LatLong.SegmentBuilder();
        double x = xi * scale / 111.13508055555556;
        double y = yi * scale / 111.13508055555556;
        double xstep = scale / 222.27016111111112;
        double ystep = scale / 222.27016111111112;
        sb.add(x - xstep, y + ystep);
        sb.add(x + xstep, y + ystep);
        sb.add(x + xstep, y - ystep);
        sb.add(x - xstep, y - ystep);
        retValue.add(sb.toSegment());
        return retValue;
    }

    private static LatLong createPlateCarreePolygon(double lat, double lng, double scale) {
        LatLong retValue = new LatLong();
        LatLong.SegmentBuilder sb = new LatLong.SegmentBuilder();
        double x = lat;
        double y = lng;
        double step = scale / 2.0;
        double xmin = x - step;
        double xmax = x + step;
        double ymin = y - step;
        double ymax = y + step;
        if (xmin < -90.0) {
            xmin = -90.0;
        }
        if (xmax > 90.0) {
            xmax = 90.0;
        }
        sb.add(xmin, ymax);
        sb.add(xmax, ymax);
        sb.add(xmax, ymin);
        sb.add(xmin, ymin);
        retValue.add(sb.toSegment());
        return retValue;
    }

    public Graph getPlateCareeGraph(int angularStep, double earthRadius, boolean addNearestNeighbors, boolean addNextNearestNeighbors, boolean periodicBoundaries) {
        int y;
        Graph graph = GraphFactory.eINSTANCE.createGraph();
        DublinCore dc = graph.getDublinCore();
        dc.populate();
        dc.setTitle(this.LATTICE_TYPE);
        dc.setSource(this.getClass().getSimpleName());
        Calendar c = Calendar.getInstance();
        SimpleDateFormat formatter = new SimpleDateFormat("E yyyy.MM.dd 'at' hh:mm:ss a zzz");
        String valid = formatter.format(c.getTime());
        dc.setValid(valid);
        int latSize = 180 / angularStep;
        int lngSize = 360 / angularStep;
        Node[][] nodeHolder = new Node[latSize][lngSize];
        int offset = angularStep / 2;
        int lat = -90;
        int lng = -180;
        double totalSphereSurfaceArea = 0.0;
        int x = 0;
        while (x < latSize) {
            y = 0;
            while (y < lngSize) {
                String latSTR = "";
                String lngSTR = "";
                latSTR = (double)(lat + offset) >= 0.0 ? String.valueOf(latSTR) + (lat + offset) + "N" : String.valueOf(latSTR) + Math.abs(lat + offset) + "S";
                lngSTR = (double)(lng + offset) >= 0.0 ? String.valueOf(lngSTR) + (lng + offset) + "E" : String.valueOf(lngSTR) + Math.abs(lng + offset) + "W";
                Region regionNode = LatticeGeneratorUtilityImpl.createRegionNode(URI_GLBL_PREFIX, latSTR, lngSTR, graph);
                AreaLabel areaLabel = LabelsFactory.eINSTANCE.createAreaLabel();
                double area = this.getAreaOnSphere(lat + offset, lng + offset, angularStep, earthRadius);
                totalSphereSurfaceArea += area;
                areaLabel.getCurrentAreaValue().setArea(area);
                regionNode.getLabels().add((Object)areaLabel);
                nodeHolder[x][y] = regionNode;
                graph.putNode((Node)regionNode);
                lng += angularStep;
                ++y;
            }
            lat += angularStep;
            lng = -180;
            ++x;
        }
        LatticeGeneratorUtilityImpl.addSpatialSpecifications(nodeHolder, angularStep, latSize, lngSize);
        if (addNearestNeighbors) {
            x = 0;
            while (x < latSize) {
                y = 0;
                while (y < lngSize) {
                    if (y - 1 >= 0) {
                        LatticeGeneratorUtilityImpl.createEdge(graph, nodeHolder[x][y - 1], nodeHolder[x][y], angularStep);
                    } else if (periodicBoundaries) {
                        LatticeGeneratorUtilityImpl.createEdge(graph, nodeHolder[x][lngSize - 1], nodeHolder[x][y], angularStep);
                    }
                    if (x - 1 >= 0) {
                        LatticeGeneratorUtilityImpl.createEdge(graph, nodeHolder[x - 1][y], nodeHolder[x][y], angularStep);
                    }
                    ++y;
                }
                ++x;
            }
        }
        assert (graph.sane());
        return graph;
    }

    public double getAreaOnSphere(double centerLat, double centerLng, double angularSize, double radius) {
        double step = angularSize / 2.0;
        double minLat = (90.0 + centerLat - step) * (Math.PI / 180);
        double maxLat = (90.0 + centerLat + step) * (Math.PI / 180);
        double minLng = (centerLng - step) * (Math.PI / 180);
        double maxLng = (centerLng + step) * (Math.PI / 180);
        double dLng = Math.abs(maxLng - minLng);
        double r2 = radius * radius;
        double latTerm = Math.cos(maxLat) - Math.cos(minLat);
        double area = r2 * dLng * Math.abs(latTerm);
        return area;
    }

    public boolean testCommonBorderEdges(Graph g, double maxLatticeConstant) {
        double dmax = 1.01 * Math.sqrt(2.0) * maxLatticeConstant;
        EMap edgeMap = g.getEdges();
        for (URI key : edgeMap.keySet()) {
            LatLongProviderAdapter latLongProviderB;
            double[] bC;
            Edge e = (Edge)edgeMap.get((Object)key);
            Node nA = e.getA();
            Node nB = e.getB();
            LatLongProviderAdapter latLongProviderA = (LatLongProviderAdapter)LatLongProviderAdapterFactory.INSTANCE.adapt((Notifier)nA, LatLongProvider.class);
            double[] aC = latLongProviderA.getCenter();
            double r2 = (aC[0] - (bC = (latLongProviderB = (LatLongProviderAdapter)LatLongProviderAdapterFactory.INSTANCE.adapt((Notifier)nB, LatLongProvider.class)).getCenter())[0]) * (aC[0] - bC[0]) + (aC[1] - bC[1]) * (aC[1] - bC[1]);
            double dist = Math.sqrt(r2);
            if (!(dist > dmax)) continue;
            Activator.logInformation("Error - found bond length " + dist + " xa,ya= " + aC[0] + "," + aC[1] + "==" + bC[0] + "," + bC[1]);
            return false;
        }
        return true;
    }
}

