/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.ge.kml;

public class Coordinates {
    private double _longitude;
    private double _latitude;
    private double _altitude;
    private boolean _isAltitudeSpecified;

    public Coordinates(double longitude, double latitude) {
        this._longitude = longitude;
        this._latitude = latitude;
    }

    public Coordinates(double longitude, double latitude, double altitude) {
        this(longitude, latitude);
        this._isAltitudeSpecified = true;
        this._altitude = altitude;
    }

    public String getCoordinates() {
        StringBuffer str = new StringBuffer();
        str.append(Double.toString(this._longitude));
        str.append(",");
        str.append(Double.toString(this._latitude));
        if (this._isAltitudeSpecified) {
            str.append(",");
            str.append(Double.toString(this._altitude));
        }
        return str.toString();
    }

    public double getLongitude() {
        return this._longitude;
    }

    public double getLatitude() {
        return this._latitude;
    }

    public double getAltitude() {
        return this._altitude;
    }

    public void setCoordinates(double longitude, double latitude) {
        this._longitude = longitude;
        this._latitude = latitude;
    }

    public void setCoordinates(double longitude, double latitude, int alt) {
        this._longitude = longitude;
        this._latitude = latitude;
        this._altitude = alt;
    }

    public static String toString(Coordinates[] corners) {
        StringBuffer strbuf = new StringBuffer(100);
        int i = 0;
        while (i < corners.length) {
            if (i != 0) {
                strbuf.append(",");
            }
            String v = Double.toString(corners[i].getLongitude());
            strbuf.append(v);
            strbuf.append(",");
            v = Double.toString(corners[i].getLatitude());
            strbuf.append(v);
            strbuf.append(",");
            if (corners[i]._isAltitudeSpecified) {
                v = Double.toString(corners[i].getLatitude());
                strbuf.append(v);
            }
            ++i;
        }
        return strbuf.toString();
    }

    public boolean isAltitudeSpecified() {
        return this._isAltitudeSpecified;
    }
}

