/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.net;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.core.internal.net.Activator;
import org.eclipse.core.internal.net.PreferenceManager;
import org.eclipse.core.internal.net.ProxyData;
import org.eclipse.core.internal.net.ProxyManager;
import org.eclipse.core.internal.net.ProxySelector;
import org.eclipse.core.internal.net.StringUtil;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.osgi.util.NLS;
import org.osgi.service.prefs.BackingStoreException;

public class ProxyType
implements IEclipsePreferences.INodeChangeListener,
IEclipsePreferences.IPreferenceChangeListener {
    static final String PREF_PROXY_DATA_NODE = "proxyData";
    static final String PREF_PROXY_HOST = "host";
    static final String PREF_PROXY_PORT = "port";
    static final String PREF_PROXY_HAS_AUTH = "hasAuth";
    public static final int DO_NOT_VERIFY = 1;
    public static final int VERIFY_EMPTY = 2;
    public static final int VERIFY_EQUAL = 4;
    private static final String PROP_SOCKS_SYSTEM_PROPERTY_HANDLING = "org.eclipse.net.core.setSocksSystemProperties";
    public static final int ONLY_SET_FOR_1_5_OR_LATER = 0;
    public static final int ALWAYS_SET = 1;
    public static final int NEVER_SET = 2;
    public static int socksSystemPropertySetting;
    private static final String PREFERENCES_CONTEXT = "/org.eclipse.core.net.proxy.auth";
    private static final String INFO_PROXY_USER = "user";
    private static final String INFO_PROXY_PASS = "pass";
    private String name;
    private boolean updatingPreferences;
    private PreferenceManager preferenceManager;

    static {
        String value = System.getProperty(PROP_SOCKS_SYSTEM_PROPERTY_HANDLING);
        socksSystemPropertySetting = value == null ? 0 : (value.equals("always") ? 1 : (value.equals("never") ? 2 : 0));
    }

    public static String convertHostsToPropertyString(String[] value) {
        StringBuilder buffer = new StringBuilder();
        if (value == null) {
            return "";
        }
        if (value.length > 0) {
            buffer.append(value[0]);
        }
        int index = 1;
        while (index < value.length) {
            buffer.append('|');
            buffer.append(value[index]);
            ++index;
        }
        return buffer.toString();
    }

    public static String[] convertPropertyStringToHosts(String property) {
        String[] hosts = StringUtil.split(property, new String[]{"|"});
        ArrayList<String> ret = new ArrayList<String>();
        int i = 0;
        while (i < hosts.length) {
            if (hosts[i].length() != 0) {
                ret.add(hosts[i]);
            }
            ++i;
        }
        return ret.toArray(new String[0]);
    }

    public ProxyType(String name) {
        this.name = name;
        this.preferenceManager = Activator.getInstance().getPreferenceManager();
    }

    public ProxyType(String name, PreferenceManager manager) {
        this.name = name;
        this.preferenceManager = manager;
    }

    private String getPreferenceNode() {
        return "proxyData/" + this.getName();
    }

    public IProxyData getProxyData(int verifyFlag) {
        return this.createProxyData(this.name, this.getPreferenceNode(), verifyFlag);
    }

    private IProxyData createProxyData(String type, String node, int verifyFlag) {
        String host = this.preferenceManager.getString(node, PREF_PROXY_HOST);
        if (host != null && host.length() == 0) {
            host = null;
        }
        int port = this.preferenceManager.getInt(node, PREF_PROXY_PORT);
        boolean requiresAuth = this.preferenceManager.getBoolean(node, PREF_PROXY_HAS_AUTH);
        ProxyData proxyData = new ProxyData(type, host, port, requiresAuth, null);
        this.loadProxyAuth(proxyData);
        if (verifyFlag == 2) {
            this.verifySystemPropertiesEmpty(type);
        } else if (verifyFlag == 4) {
            this.verifyDataMatchesSystemProperties(proxyData);
        }
        return proxyData;
    }

    public boolean setProxyData(IProxyData proxyData) {
        Assert.isTrue((boolean)proxyData.getType().equals(this.getName()));
        IProxyData oldData = this.getProxyData(4);
        if (oldData.equals(proxyData)) {
            return false;
        }
        this.saveProxyAuth(proxyData);
        try {
            this.updatingPreferences = true;
            this.updatePreferences(proxyData);
        }
        finally {
            this.updatingPreferences = false;
        }
        this.updateSystemProperties(proxyData);
        return true;
    }

    private void updatePreferences(IProxyData proxyData) {
        this.updatePreferences(this.getPreferenceNode(), proxyData);
    }

    void updatePreferencesIfMissing(IProxyData proxyData) {
        String node = this.getPreferenceNode();
        if (this.preferenceManager.getString(node, PREF_PROXY_HOST) == null) {
            this.updatePreferences(node, proxyData);
        }
    }

    private void updatePreferences(String node, IProxyData proxyData) {
        if (!this.hasPreferencesChanged(node, proxyData)) {
            return;
        }
        if (proxyData.getHost() == null) {
            try {
                this.preferenceManager.removeNode(node);
                this.preferenceManager.flush();
            }
            catch (BackingStoreException e) {
                Activator.logError(NLS.bind((String)"An error occurred removing the {0} proxy node from the preference store", (Object)proxyData.getType()), e);
            }
            if (!this.hasPreferencesChanged(node, proxyData)) {
                return;
            }
        }
        this.preferenceManager.putString(node, PREF_PROXY_HOST, proxyData.getHost() != null ? proxyData.getHost() : "");
        this.preferenceManager.putInt(node, PREF_PROXY_PORT, proxyData.getPort());
        this.preferenceManager.putBoolean(node, PREF_PROXY_HAS_AUTH, proxyData.getUserId() != null);
        try {
            this.preferenceManager.flush();
        }
        catch (BackingStoreException e) {
            Activator.logError(NLS.bind((String)"The {0} proxy node could not be written", (Object)proxyData.getType()), e);
        }
    }

    private boolean hasPreferencesChanged(String node, IProxyData proxyData) {
        String host = this.preferenceManager.getString(node, PREF_PROXY_HOST);
        return (host == null || !host.equals(proxyData.getHost())) && (host != null || proxyData.getHost() != null) || this.preferenceManager.getInt(node, PREF_PROXY_PORT) != proxyData.getPort() || this.preferenceManager.getBoolean(node, PREF_PROXY_HAS_AUTH) != proxyData.isRequiresAuthentication();
    }

    void updateSystemProperties(IProxyData proxyData) {
        try {
            if (proxyData.getType().equals("HTTP")) {
                this.updateHttpSystemProperties();
            } else if (proxyData.getType().equals("HTTPS")) {
                this.updateHttpsSystemProperties();
            } else if (proxyData.getType().equals("SOCKS")) {
                this.updateSocksSystemProperties();
            }
        }
        catch (SecurityException e) {
            Activator.logError("A security exception occurred while trying to put the proxy data into the system properties", e);
        }
    }

    private boolean verifyDataMatchesSystemProperties(ProxyData proxyData) {
        try {
            boolean proxiesEnabled = ProxyManager.getProxyManager().isProxiesEnabled();
            if (proxyData.getType().equals("HTTP")) {
                return this.verifyDataMatchesHttpSystemProperties(proxyData, proxiesEnabled);
            }
            if (proxyData.getType().equals("HTTPS")) {
                return this.verifyDataMatchesHttpsSystemProperties(proxyData, proxiesEnabled);
            }
            if (proxyData.getType().equals("SOCKS")) {
                return this.verifyDataMatchesSocksSystemProperties(proxyData, proxiesEnabled);
            }
        }
        catch (SecurityException securityException) {}
        return true;
    }

    private boolean verifyDataMatchesHttpSystemProperties(ProxyData proxyData, boolean proxiesEnabled) {
        if (proxiesEnabled) {
            boolean verified = true;
            String dHost = proxyData.getHost();
            if (!this.verifySystemPropertyEquals("http.proxyHost", dHost)) {
                verified = false;
            } else if (dHost != null && !Boolean.getBoolean("http.proxySet")) {
                Activator.logInfo("The HTTP proxy is enabled in the preferences but disabled in the system settings", null);
                verified = false;
            }
            int port = proxyData.getPort();
            if (!this.verifySystemPropertyEquals("http.proxyPort", port == -1 ? null : String.valueOf(port))) {
                verified = false;
            }
            return verified;
        }
        return this.verifyHttpSystemPropertiesEmpty();
    }

    private boolean verifyDataMatchesHttpsSystemProperties(ProxyData proxyData, boolean proxiesEnabled) {
        if (proxiesEnabled) {
            boolean verified = true;
            String dHost = proxyData.getHost();
            if (!this.verifySystemPropertyEquals("https.proxyHost", dHost)) {
                verified = false;
            } else if (dHost != null && !Boolean.getBoolean("https.proxySet")) {
                Activator.logInfo("The SSL proxy is enabled in the preferences but disabled in the system settings", null);
                verified = false;
            }
            int port = proxyData.getPort();
            if (!this.verifySystemPropertyEquals("https.proxyPort", port == -1 ? null : String.valueOf(port))) {
                verified = false;
            }
            return verified;
        }
        return this.verifyHttpsSystemPropertiesEmpty();
    }

    private boolean verifyDataMatchesSocksSystemProperties(ProxyData proxyData, boolean proxiesEnabled) {
        if (proxiesEnabled && this.shouldSetSocksSystemProperties()) {
            int port;
            boolean verified = true;
            String dHost = proxyData.getHost();
            if (!this.verifySystemPropertyEquals("socksProxyHost", dHost)) {
                verified = false;
            }
            if (!this.verifySystemPropertyEquals("socksProxyPort", (port = proxyData.getPort()) == -1 ? null : String.valueOf(port))) {
                verified = false;
            }
            return verified;
        }
        return this.verifySocksSystemPropertiesEmpty();
    }

    private boolean shouldSetSocksSystemProperties() {
        if (socksSystemPropertySetting == 1) {
            return true;
        }
        if (socksSystemPropertySetting == 2) {
            return false;
        }
        return this.hasJavaNetProxyClass();
    }

    private boolean verifySystemPropertyEquals(String key, String expected) {
        String value = System.getProperty(key);
        if (value == expected) {
            return true;
        }
        if (value == null && expected != null) {
            Activator.logInfo(NLS.bind((String)"System property {0} is not set but should be {1}.", (Object)key, (Object)expected), null);
            return false;
        }
        if (value != null && expected == null) {
            Activator.logInfo(NLS.bind((String)"System property {0} is set to {1} but should not be set.", (Object)key, (Object)value), null);
            return false;
        }
        if (!value.equals(expected)) {
            Activator.logInfo(NLS.bind((String)"System property {0} is set to {1} but should be {2}.", (Object[])new Object[]{key, value, expected}), null);
            return false;
        }
        return true;
    }

    private boolean verifySystemPropertiesEmpty(String proxyType) {
        try {
            if (proxyType.equals("HTTP")) {
                return this.verifyHttpSystemPropertiesEmpty();
            }
            if (proxyType.equals("HTTPS")) {
                return this.verifyHttpsSystemPropertiesEmpty();
            }
            if (proxyType.equals("SOCKS")) {
                return this.verifySocksSystemPropertiesEmpty();
            }
        }
        catch (SecurityException securityException) {}
        return true;
    }

    private boolean verifyHttpSystemPropertiesEmpty() {
        boolean verified = true;
        verified &= this.verifyIsNotSet("http.proxySet");
        verified &= this.verifyIsNotSet("http.proxyHost");
        verified &= this.verifyIsNotSet("http.proxyPort");
        verified &= this.verifyIsNotSet("http.nonProxyHosts");
        verified &= this.verifyIsNotSet("http.proxyUser");
        verified &= this.verifyIsNotSet("http.proxyUserName");
        return verified &= this.verifyIsNotSet("http.proxyPassword");
    }

    private boolean verifyIsNotSet(String key) {
        String value = System.getProperty(key);
        if (value != null) {
            Activator.logInfo(NLS.bind((String)"System property {0} has been set to {1} by an external source. This value will be overwritten using the values from the preferences", (Object)key, (Object)value), null);
        }
        return value == null;
    }

    private boolean verifyHttpsSystemPropertiesEmpty() {
        boolean verified = true;
        verified &= this.verifyIsNotSet("https.proxySet");
        verified &= this.verifyIsNotSet("https.proxyHost");
        verified &= this.verifyIsNotSet("https.proxyPort");
        verified &= this.verifyIsNotSet("https.nonProxyHosts");
        verified &= this.verifyIsNotSet("https.proxyUser");
        verified &= this.verifyIsNotSet("https.proxyUserName");
        return verified &= this.verifyIsNotSet("https.proxyPassword");
    }

    private boolean verifySocksSystemPropertiesEmpty() {
        boolean verified = true;
        verified &= this.verifyIsNotSet("socksProxyHost");
        return verified &= this.verifyIsNotSet("socksProxyPort");
    }

    public String getName() {
        return this.name;
    }

    private void updateHttpSystemProperties() {
        IProxyData data = this.getProxyData("HTTP");
        boolean proxiesEnabled = this.isProxyEnabled();
        Assert.isTrue((boolean)data.getType().equals("HTTP"));
        Properties sysProps = System.getProperties();
        if (!proxiesEnabled || data.getHost() == null || data.getHost().equals("")) {
            sysProps.remove("http.proxySet");
            sysProps.remove("http.proxyHost");
            sysProps.remove("http.proxyPort");
            sysProps.remove("http.nonProxyHosts");
            sysProps.remove("http.proxyUser");
            sysProps.remove("http.proxyUserName");
            sysProps.remove("http.proxyPassword");
        } else {
            sysProps.put("http.proxySet", "true");
            sysProps.put("http.proxyHost", data.getHost());
            int port = data.getPort();
            if (port == -1) {
                sysProps.remove("http.proxyPort");
            } else {
                sysProps.put("http.proxyPort", String.valueOf(port));
            }
            sysProps.put("http.nonProxyHosts", ProxyType.convertHostsToPropertyString(this.getNonProxiedHosts()));
            String userid = data.getUserId();
            String password = data.getPassword();
            if (userid == null || password == null || userid.length() == 0 || password.length() == 0) {
                sysProps.remove("http.proxyUser");
                sysProps.remove("http.proxyUserName");
                sysProps.remove("http.proxyPassword");
            } else {
                sysProps.put("http.proxyUser", userid);
                sysProps.put("http.proxyUserName", userid);
                sysProps.put("http.proxyPassword", password);
            }
        }
    }

    private boolean isProxyEnabled() {
        return !ProxySelector.getDefaultProvider().equalsIgnoreCase("DIRECT");
    }

    private IProxyData getProxyData(String type) {
        ProxyData[] data = ProxySelector.getProxyData(ProxySelector.getDefaultProvider());
        int i = 0;
        while (i < data.length) {
            if (data[i].getType().equalsIgnoreCase(type)) {
                return data[i];
            }
            ++i;
        }
        return new ProxyData(type, null, -1, false, null);
    }

    private String[] getNonProxiedHosts() {
        return ProxySelector.getBypassHosts(ProxySelector.getDefaultProvider());
    }

    private void updateHttpsSystemProperties() {
        IProxyData data = this.getProxyData("HTTPS");
        boolean proxiesEnabled = this.isProxyEnabled();
        Assert.isTrue((boolean)data.getType().equals("HTTPS"));
        Properties sysProps = System.getProperties();
        if (!proxiesEnabled || data.getHost() == null || data.getHost().equals("")) {
            sysProps.remove("https.proxySet");
            sysProps.remove("https.proxyHost");
            sysProps.remove("https.proxyPort");
            sysProps.remove("https.nonProxyHosts");
            sysProps.remove("https.proxyUser");
            sysProps.remove("https.proxyUserName");
            sysProps.remove("https.proxyPassword");
        } else {
            sysProps.put("https.proxySet", "true");
            sysProps.put("https.proxyHost", data.getHost());
            int port = data.getPort();
            if (port == -1) {
                sysProps.remove("https.proxyPort");
            } else {
                sysProps.put("https.proxyPort", String.valueOf(port));
            }
            sysProps.put("https.nonProxyHosts", ProxyType.convertHostsToPropertyString(this.getNonProxiedHosts()));
            String userid = data.getUserId();
            String password = data.getPassword();
            if (userid == null || password == null || userid.length() == 0 || password.length() == 0) {
                sysProps.remove("https.proxyUser");
                sysProps.remove("https.proxyUserName");
                sysProps.remove("https.proxyPassword");
            } else {
                sysProps.put("https.proxyUser", userid);
                sysProps.put("https.proxyUserName", userid);
                sysProps.put("https.proxyPassword", password);
            }
        }
    }

    private void updateSocksSystemProperties() {
        IProxyData data = this.getProxyData("SOCKS");
        boolean proxiesEnabled = this.isProxyEnabled();
        Assert.isTrue((boolean)data.getType().equals("SOCKS"));
        Properties sysProps = System.getProperties();
        if (!proxiesEnabled || data.getHost() == null || data.getHost().equals("")) {
            sysProps.remove("socksProxyHost");
            sysProps.remove("socksProxyPort");
        } else {
            if (!this.shouldSetSocksSystemProperties()) {
                if (socksSystemPropertySetting == 0) {
                    Activator.logError("Setting the SOCKS system properties for a 1.4 VM can interfere with other proxy services (e.g. JSch). Please upgrade to a 1.5 JRE or later if you need to use Java's SOCKS proxy support.", null);
                }
                return;
            }
            sysProps.put("socksProxyHost", data.getHost());
            int port = data.getPort();
            if (port == -1) {
                sysProps.remove("socksProxyPort");
            } else {
                sysProps.put("socksProxyPort", String.valueOf(port));
            }
        }
    }

    public void initialize() {
        this.updateSystemProperties(this.getProxyData(2));
        this.preferenceManager.addNodeChangeListener(PREF_PROXY_DATA_NODE, this);
        this.preferenceManager.addPreferenceChangeListener(this.getPreferenceNode(), this);
    }

    private ISecurePreferences getNode() {
        ISecurePreferences root = SecurePreferencesFactory.getDefault();
        if (root == null) {
            return null;
        }
        ISecurePreferences node = root.node(PREFERENCES_CONTEXT);
        if (this.getName() != null) {
            return node.node(this.getName());
        }
        return node;
    }

    private void loadProxyAuth(IProxyData data) {
        ISecurePreferences node = this.getNode();
        if (node == null) {
            return;
        }
        try {
            data.setUserid(node.get(INFO_PROXY_USER, null));
            data.setPassword(node.get(INFO_PROXY_PASS, null));
        }
        catch (StorageException e) {
            Activator.logError(e.getMessage(), e);
        }
    }

    private void saveProxyAuth(IProxyData data) {
        ISecurePreferences node = this.getNode();
        if (node == null) {
            return;
        }
        try {
            if (data.getUserId() != null) {
                node.put(INFO_PROXY_USER, data.getUserId(), true);
            } else {
                node.remove(INFO_PROXY_USER);
            }
            if (data.getPassword() != null) {
                node.put(INFO_PROXY_PASS, data.getPassword(), true);
            } else {
                node.remove(INFO_PROXY_PASS);
            }
        }
        catch (StorageException e) {
            Activator.logError(e.getMessage(), e);
            return;
        }
        try {
            node.flush();
        }
        catch (IOException e) {
            Activator.logError(e.getMessage(), e);
            return;
        }
    }

    private synchronized boolean hasJavaNetProxyClass() {
        try {
            Class<?> proxyClass = Class.forName("java.net.Proxy");
            return proxyClass != null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public void added(IEclipsePreferences.NodeChangeEvent event) {
        if (event.getChild().name().equals(this.getName())) {
            ((IEclipsePreferences)event.getChild()).addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        }
    }

    public void removed(IEclipsePreferences.NodeChangeEvent event) {
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        if (this.updatingPreferences) {
            return;
        }
        this.updateSystemProperties(this.getProxyData(1));
    }
}

