/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.populationmodels.standard.provider;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.ui.provider.PropertySource;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProvider;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProviderAdapter;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProviderAdapterFactory;
import org.eclipse.stem.populationmodels.standard.PopulationModelLabel;
import org.eclipse.stem.populationmodels.standard.PopulationModelLabelValue;
import org.eclipse.stem.populationmodels.standard.StandardPopulationModelLabelValue;
import org.eclipse.stem.populationmodels.standard.provider.StandardItemProviderAdapterFactory;
import org.eclipse.stem.populationmodels.standard.util.StandardAdapterFactory;

public class StandardRelativeValueProviderAdapterFactory
extends StandardAdapterFactory
implements RelativeValueProviderAdapterFactory {
    protected static final double DENOMINATOR = 1.0;
    protected ComposedAdapterFactory parentAdapterFactory;
    protected IChangeNotifier changeNotifier = new ChangeNotifier();
    private static StandardItemProviderAdapterFactory itemProviderFactory;

    public StandardRelativeValueProviderAdapterFactory() {
        RelativeValueProviderAdapterFactory.INSTANCE.addAdapterFactory((AdapterFactory)this);
    }

    @Override
    public Adapter createPopulationModelLabelAdapter() {
        return new PopulationModelLabelRelativeValueProvider();
    }

    @Override
    public Adapter createPopulationModelLabelValueAdapter() {
        return new PopulationModelLabelValueRelativeValueProvider();
    }

    public void addListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.addListener(notifyChangedListener);
    }

    public void fireNotifyChanged(Notification notification) {
        this.changeNotifier.fireNotifyChanged(notification);
        if (this.parentAdapterFactory != null) {
            this.parentAdapterFactory.fireNotifyChanged(notification);
        }
    }

    public void removeListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.removeListener(notifyChangedListener);
    }

    public ComposeableAdapterFactory getRootAdapterFactory() {
        return this.parentAdapterFactory == null ? this : this.parentAdapterFactory.getRootAdapterFactory();
    }

    public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
        this.parentAdapterFactory = parentAdapterFactory;
    }

    @Override
    public boolean isFactoryForType(Object type) {
        return type == RelativeValueProvider.class || super.isFactoryForType(type);
    }

    public void dispose() {
    }

    private static RelativeValueProviderAdapterFactory getRelativeValueProviderAdapterFactory() {
        return RelativeValueProviderAdapterFactory.INSTANCE;
    }

    private static StandardItemProviderAdapterFactory getItemProviderFactory() {
        if (itemProviderFactory == null) {
            itemProviderFactory = new StandardItemProviderAdapterFactory();
        }
        return itemProviderFactory;
    }

    public static class PopulationModelLabelRelativeValueProvider
    extends RelativeValueProviderAdapter
    implements RelativeValueProvider {
        public List<IItemPropertyDescriptor> getProperties() {
            PopulationModelLabel dml = (PopulationModelLabel)this.getTarget();
            RelativeValueProvider rvp = (RelativeValueProvider)StandardRelativeValueProviderAdapterFactory.getRelativeValueProviderAdapterFactory().adapt((Notifier)dml.getCurrentValue(), RelativeValueProvider.class);
            return rvp.getProperties();
        }

        public double getRelativeValue(EStructuralFeature feature) {
            PopulationModelLabel dml = (PopulationModelLabel)this.getTarget();
            RelativeValueProvider rvp = (RelativeValueProvider)StandardRelativeValueProviderAdapterFactory.getRelativeValueProviderAdapterFactory().adapt((Notifier)dml.getCurrentValue(), RelativeValueProvider.class);
            return rvp.getRelativeValue(feature);
        }

        public double getDenominator(EStructuralFeature feature) {
            return 1.0;
        }
    }

    public static class PopulationModelLabelValueRelativeValueProvider
    extends RelativeValueProviderAdapter
    implements RelativeValueProvider {
        public List<IItemPropertyDescriptor> getProperties() {
            ArrayList<IItemPropertyDescriptor> retValue = new ArrayList<IItemPropertyDescriptor>();
            StandardItemProviderAdapterFactory itemProviderFactory = StandardRelativeValueProviderAdapterFactory.getItemProviderFactory();
            PopulationModelLabelValue dmlv = (PopulationModelLabelValue)this.getTarget();
            IItemPropertySource propertySource = (IItemPropertySource)itemProviderFactory.adapt((Notifier)dmlv, (Object)PropertySource.class);
            List properties = propertySource.getPropertyDescriptors(null);
            for (IItemPropertyDescriptor descriptor : properties) {
                EStructuralFeature feature = (EStructuralFeature)descriptor.getFeature(null);
                if (feature instanceof EReference) continue;
                retValue.add(descriptor);
            }
            return retValue;
        }

        public double getRelativeValue(EStructuralFeature feature) {
            StandardPopulationModelLabelValue dmlv = (StandardPopulationModelLabelValue)this.getTarget();
            double populationCount = dmlv.getCount();
            double retVal = populationCount / 1.0;
            return retVal;
        }

        public double getDenominator(EStructuralFeature feature) {
            return 1.0;
        }
    }
}

