/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.grapheditor;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.eclipse.stem.definitions.adapters.spatial.geo.LatLong;

public class Polygon {
    public int npoints;
    public double[] x;
    public double[] y;
    private double area;
    private double cx;
    private double cy;
    private double xMin;
    private double yMin;
    private double xMax;
    private double yMax;

    public Polygon(LatLong.Segment segment) {
        this.getPolygon(segment);
        this.computeAreaAndCentroid();
        this.computeMinAndMax();
    }

    public double getArea() {
        return this.area;
    }

    public Point2D.Double getCentroid() {
        return new Point2D.Double(this.cx, this.cy);
    }

    public Rectangle2D.Double getBounds() {
        return new Rectangle2D.Double(this.xMin, this.yMin, this.xMax - this.xMin, this.yMax - this.yMin);
    }

    public String getData() {
        StringBuffer sb = new StringBuffer(this.npoints * 24);
        int i = 0;
        while (i < this.npoints) {
            sb.append(String.valueOf(this.y[i]) + " " + this.x[i] + " ");
            ++i;
        }
        return sb.substring(0, sb.length() - 1);
    }

    private void getPolygon(LatLong.Segment segment) {
        this.npoints = segment.size();
        this.y = new double[this.npoints];
        this.x = new double[this.npoints];
        int i = 0;
        while (i < this.npoints) {
            this.y[i] = segment.latitude(i);
            this.x[i] = segment.longitude(i);
            ++i;
        }
        if (this.y[0] != this.y[this.npoints - 1] || this.x[0] != this.x[this.npoints - 1]) {
            double[] y_new = new double[this.npoints + 1];
            double[] x_new = new double[this.npoints + 1];
            int i2 = 0;
            while (i2 < this.npoints) {
                y_new[i2] = this.y[i2];
                x_new[i2] = this.x[i2];
                ++i2;
            }
            y_new[this.npoints] = this.y[0];
            x_new[this.npoints] = this.x[0];
            this.x = x_new;
            this.y = y_new;
            ++this.npoints;
        }
    }

    private void computeAreaAndCentroid() {
        this.area = 0.0;
        this.cx = 0.0;
        this.cy = 0.0;
        int i = 0;
        while (i < this.npoints - 1) {
            double mem = this.x[i] * this.y[i + 1] - this.x[i + 1] * this.y[i];
            this.area += mem;
            this.cx += (this.x[i] + this.x[i + 1]) * mem;
            this.cy += (this.y[i] + this.y[i + 1]) * mem;
            ++i;
        }
        this.area /= 2.0;
        this.cx /= 6.0 * this.area;
        this.cy /= 6.0 * this.area;
        this.area = Math.abs(this.area);
    }

    private void computeMinAndMax() {
        this.xMin = this.x[0];
        this.yMin = this.y[0];
        this.xMax = this.x[0];
        this.yMax = this.y[0];
        int i = 1;
        while (i < this.npoints) {
            this.xMin = Math.min(this.xMin, this.x[i]);
            this.yMin = Math.min(this.yMin, this.y[i]);
            this.xMax = Math.max(this.xMax, this.x[i]);
            this.yMax = Math.max(this.yMax, this.y[i]);
            ++i;
        }
    }
}

