/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.grapheditor;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Stroke;
import java.util.Deque;
import java.util.LinkedList;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.LineAttributes;

public class GraphicsToAWT
extends Graphics {
    private Graphics2D awtGraphics;
    private Rectangle clip;
    private org.eclipse.swt.graphics.Color foregroundColor;
    private org.eclipse.swt.graphics.Color backgroundColor;
    private LineAttributes lineAttributes;
    private Deque<State> states;

    public GraphicsToAWT(Graphics2D awtGraphics, Dimension size) {
        this.awtGraphics = awtGraphics;
        this.clip = new Rectangle(0, 0, size.width, size.height);
        this.foregroundColor = ColorConstants.black;
        this.backgroundColor = ColorConstants.black;
        this.lineAttributes = new LineAttributes(0.0f);
        this.states = new LinkedList<State>();
        awtGraphics.setClip(this.clip.x, this.clip.y, this.clip.width, this.clip.height);
    }

    public void clipRect(Rectangle r) {
    }

    public void dispose() {
        this.awtGraphics.dispose();
    }

    public void drawArc(int x, int y, int w, int h, int offset, int length) {
        this.awtGraphics.drawArc(x, y, w, h, offset, length);
    }

    public void drawFocus(int x, int y, int w, int h) {
    }

    public void drawImage(Image srcImage, int x, int y) {
    }

    public void drawImage(Image srcImage, int x1, int y1, int w1, int h1, int x2, int y2, int w2, int h2) {
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        this.awtGraphics.setColor(this.convertToAWT(this.foregroundColor));
        this.awtGraphics.setStroke(this.convertToAWT(this.lineAttributes));
        this.awtGraphics.drawLine(x1, y1, x2, y2);
    }

    public void drawOval(int x, int y, int w, int h) {
        this.awtGraphics.setColor(this.convertToAWT(this.foregroundColor));
        this.awtGraphics.setStroke(this.convertToAWT(this.lineAttributes));
        this.awtGraphics.drawOval(x, y, w, h);
    }

    public void drawPolygon(PointList points) {
        this.awtGraphics.setColor(this.convertToAWT(this.foregroundColor));
        this.awtGraphics.setStroke(this.convertToAWT(this.lineAttributes));
        this.awtGraphics.drawPolygon(this.convertToAWT(points));
    }

    public void drawPolyline(PointList points) {
        Polygon p = this.convertToAWT(points);
        this.awtGraphics.setColor(this.convertToAWT(this.foregroundColor));
        this.awtGraphics.setStroke(this.convertToAWT(this.lineAttributes));
        this.awtGraphics.drawPolyline(p.xpoints, p.ypoints, p.npoints);
    }

    public void drawRectangle(int x, int y, int w, int h) {
        this.awtGraphics.setColor(this.convertToAWT(this.foregroundColor));
        this.awtGraphics.setStroke(this.convertToAWT(this.lineAttributes));
        this.awtGraphics.drawRect(x, y, w, h);
    }

    public void drawRoundRectangle(Rectangle r, int arcWidth, int arcHeight) {
        this.awtGraphics.setColor(this.convertToAWT(this.foregroundColor));
        this.awtGraphics.setStroke(this.convertToAWT(this.lineAttributes));
        this.awtGraphics.drawRoundRect(r.x, r.y, r.width, r.height, arcWidth, arcHeight);
    }

    public void drawString(String s, int x, int y) {
        this.awtGraphics.setColor(this.convertToAWT(this.foregroundColor));
        this.awtGraphics.drawString(s, x, y);
    }

    public void drawText(String s, int x, int y) {
        this.awtGraphics.setColor(this.convertToAWT(this.foregroundColor));
        this.awtGraphics.drawString(s, x, y);
    }

    public void fillArc(int x, int y, int w, int h, int offset, int length) {
        this.awtGraphics.setColor(this.convertToAWT(this.backgroundColor));
        this.awtGraphics.fillArc(x, y, w, h, offset, length);
    }

    public void fillGradient(int x, int y, int w, int h, boolean vertical) {
        this.awtGraphics.setColor(this.convertToAWT(this.backgroundColor));
        this.awtGraphics.fillRect(x, y, w, h);
    }

    public void fillOval(int x, int y, int w, int h) {
        this.awtGraphics.setColor(this.convertToAWT(this.backgroundColor));
        this.awtGraphics.fillOval(x, y, w, h);
    }

    public void fillPolygon(PointList points) {
        this.awtGraphics.setColor(this.convertToAWT(this.backgroundColor));
        this.awtGraphics.fillPolygon(this.convertToAWT(points));
    }

    public void fillRectangle(int x, int y, int w, int h) {
        this.awtGraphics.setColor(this.convertToAWT(this.backgroundColor));
        this.awtGraphics.fillRect(x, y, w, h);
    }

    public void fillRoundRectangle(Rectangle r, int arcWidth, int arcHeight) {
        this.awtGraphics.setColor(this.convertToAWT(this.backgroundColor));
        this.awtGraphics.fillRoundRect(r.x, r.y, r.width, r.height, arcWidth, arcHeight);
    }

    public void fillString(String s, int x, int y) {
        this.awtGraphics.setColor(this.convertToAWT(this.backgroundColor));
        this.awtGraphics.drawString(s, x, y);
    }

    public void fillText(String s, int x, int y) {
        this.awtGraphics.setColor(this.convertToAWT(this.backgroundColor));
        this.awtGraphics.drawString(s, x, y);
    }

    public org.eclipse.swt.graphics.Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public Rectangle getClip(Rectangle rect) {
        return this.clip;
    }

    public Font getFont() {
        return null;
    }

    public FontMetrics getFontMetrics() {
        return null;
    }

    public org.eclipse.swt.graphics.Color getForegroundColor() {
        return this.foregroundColor;
    }

    public int getLineStyle() {
        return this.lineAttributes.style;
    }

    public int getLineWidth() {
        return (int)this.lineAttributes.width;
    }

    public float getLineWidthFloat() {
        return this.lineAttributes.width;
    }

    public boolean getXORMode() {
        return false;
    }

    public void popState() {
        this.restoreState();
        this.states.removeFirst();
    }

    public void pushState() {
        this.states.addFirst(new State(this.backgroundColor, this.foregroundColor, this.lineAttributes));
    }

    public void restoreState() {
        State s = this.states.getFirst();
        this.backgroundColor = s.backgroundColor;
        this.foregroundColor = s.foregroundColor;
        this.lineAttributes = s.lineAttributes;
    }

    public void scale(double amount) {
    }

    public void setBackgroundColor(org.eclipse.swt.graphics.Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void setClip(Rectangle r) {
    }

    public void setFont(Font f) {
    }

    public void setForegroundColor(org.eclipse.swt.graphics.Color foregroundColor) {
        this.foregroundColor = foregroundColor;
    }

    public void setLineStyle(int style) {
        this.lineAttributes.style = style;
    }

    public void setLineWidth(int width) {
        this.lineAttributes.width = Math.max(1.0f, (float)width);
    }

    public void setLineWidthFloat(float width) {
        this.lineAttributes.width = Math.max(1.0f, width);
    }

    public void setLineMiterLimit(float miterLimit) {
        this.lineAttributes.miterLimit = miterLimit;
    }

    public void setXORMode(boolean b) {
    }

    public void translate(int dx, int dy) {
    }

    public void setLineAttributes(LineAttributes lineAttributes) {
        this.lineAttributes = lineAttributes;
    }

    private Color convertToAWT(org.eclipse.swt.graphics.Color color) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue());
    }

    private Polygon convertToAWT(PointList points) {
        int[] xs = new int[points.size()];
        int[] ys = new int[points.size()];
        int i = 0;
        while (i < points.size()) {
            Point p = points.getPoint(i);
            xs[i] = p.x;
            ys[i] = p.y;
            ++i;
        }
        return new Polygon(xs, ys, points.size());
    }

    private Stroke convertToAWT(LineAttributes lineAttributes) {
        float width = 1.0f;
        int cap = 2;
        int join = 0;
        float miterLimit = 10.0f;
        float[] dash = null;
        float dashOffset = 0.0f;
        switch (lineAttributes.style) {
            case 6: {
                dash = lineAttributes.dash;
                dashOffset = lineAttributes.dashOffset;
                break;
            }
            case 2: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            case 3: {
                dash = new float[]{1.0f, 2.0f};
                dashOffset = 0.0f;
                break;
            }
            case 1: {
                dash = null;
                dashOffset = 0.0f;
            }
        }
        return new BasicStroke(width, cap, join, miterLimit, dash, dashOffset);
    }

    private class State {
        private org.eclipse.swt.graphics.Color backgroundColor;
        private org.eclipse.swt.graphics.Color foregroundColor;
        private LineAttributes lineAttributes;

        public State(org.eclipse.swt.graphics.Color backgroundColor, org.eclipse.swt.graphics.Color foregroundColor, LineAttributes lineAttributes) {
            this.backgroundColor = backgroundColor;
            this.foregroundColor = foregroundColor;
            this.lineAttributes = lineAttributes;
        }
    }
}

