/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.grapheditor;

import org.eclipse.emf.common.util.URI;
import org.eclipse.stem.core.graph.Edge;
import org.eclipse.stem.core.graph.EdgeLabel;
import org.eclipse.stem.definitions.edges.MigrationEdge;
import org.eclipse.stem.definitions.labels.CommonBorderRelationshipLabelValue;
import org.eclipse.stem.definitions.labels.RoadTransportRelationshipLabelValue;
import org.eclipse.stem.definitions.transport.PipeTransportEdge;
import org.eclipse.stem.definitions.transport.PipeTransportEdgeLabelValue;

public class ConnectionData {
    private Edge edge;
    private int curveDepth;

    public ConnectionData(Edge edge, int curveDepth) {
        this.edge = edge;
        this.curveDepth = curveDepth;
    }

    public Edge getEdge() {
        return this.edge;
    }

    public URI getURI() {
        return this.edge.getURI();
    }

    public URI getNodeAURI() {
        return this.edge.getNodeAURI();
    }

    public URI getNodeBURI() {
        return this.edge.getNodeBURI();
    }

    public EdgeLabel getEdgeLabel() {
        return this.edge.getLabel();
    }

    public String getEdgeTitle() {
        if (this.edge.getDublinCore().getTitle() != null) {
            return this.edge.getDublinCore().getTitle();
        }
        return "";
    }

    public void setEdgeTitle(String edgeTitle) {
        this.edge.getDublinCore().setTitle(edgeTitle);
    }

    public double getCommonBorderLength() {
        CommonBorderRelationshipLabelValue borderValue = (CommonBorderRelationshipLabelValue)this.edge.getLabel().getCurrentValue();
        return borderValue.getBorderLength();
    }

    public void setCommonBorderLength(double value) {
        CommonBorderRelationshipLabelValue borderValue = (CommonBorderRelationshipLabelValue)this.edge.getLabel().getCurrentValue();
        borderValue.setBorderLength(value);
    }

    public String getMigrationPopulation() {
        MigrationEdge migrationEdge = (MigrationEdge)this.edge;
        if (migrationEdge.getPopulationIdentifier() != null) {
            return migrationEdge.getPopulationIdentifier();
        }
        return "";
    }

    public void setMigrationPopulation(String value) {
        MigrationEdge migrationEdge = (MigrationEdge)this.edge;
        migrationEdge.setPopulationIdentifier(value);
    }

    public boolean getMigrationAbsolute() {
        MigrationEdge migrationEdge = (MigrationEdge)this.edge;
        return migrationEdge.isUseAbsoluteValues();
    }

    public void setMigrationAbsolute(boolean value) {
        MigrationEdge migrationEdge = (MigrationEdge)this.edge;
        migrationEdge.setUseAbsoluteValues(value);
    }

    public double getMigrationRate() {
        MigrationEdge migrationEdge = (MigrationEdge)this.edge;
        return migrationEdge.getLabel().getCurrentValue().getMigrationRate();
    }

    public void setMigrationRate(double value) {
        MigrationEdge migrationEdge = (MigrationEdge)this.edge;
        migrationEdge.getLabel().getCurrentValue().setMigrationRate(value);
    }

    public long getMigrationPeriod() {
        MigrationEdge migrationEdge = (MigrationEdge)this.edge;
        return migrationEdge.getLabel().getCurrentValue().getTimePeriod();
    }

    public void setMigrationPeriod(long value) {
        MigrationEdge migrationEdge = (MigrationEdge)this.edge;
        migrationEdge.getLabel().getCurrentValue().setTimePeriod(value);
    }

    public String getRoadName() {
        RoadTransportRelationshipLabelValue roadValue = (RoadTransportRelationshipLabelValue)this.edge.getLabel().getCurrentValue();
        if (roadValue.getRoadName() != null) {
            return roadValue.getRoadName();
        }
        return "";
    }

    public void setRoadName(String roadName) {
        RoadTransportRelationshipLabelValue roadValue = (RoadTransportRelationshipLabelValue)this.edge.getLabel().getCurrentValue();
        roadValue.setRoadName(roadName);
    }

    public String getRoadClass() {
        RoadTransportRelationshipLabelValue roadValue = (RoadTransportRelationshipLabelValue)this.edge.getLabel().getCurrentValue();
        if (roadValue.getRoadClass() != null) {
            return roadValue.getRoadClass();
        }
        return "";
    }

    public void setRoadClass(String roadClass) {
        RoadTransportRelationshipLabelValue roadValue = (RoadTransportRelationshipLabelValue)this.edge.getLabel().getCurrentValue();
        roadValue.setRoadClass(roadClass);
    }

    public int getRoadCrossings() {
        RoadTransportRelationshipLabelValue roadValue = (RoadTransportRelationshipLabelValue)this.edge.getLabel().getCurrentValue();
        return roadValue.getNumberCrossings();
    }

    public void setRoadCrossings(int crossings) {
        RoadTransportRelationshipLabelValue roadValue = (RoadTransportRelationshipLabelValue)this.edge.getLabel().getCurrentValue();
        roadValue.setNumberCrossings(crossings);
    }

    public String getPipePopulation() {
        PipeTransportEdge pipe = (PipeTransportEdge)this.edge;
        if (pipe.getPopulationIdentifier() != null) {
            return pipe.getPopulationIdentifier();
        }
        return "";
    }

    public void setPipePopulation(String population) {
        PipeTransportEdge pipe = (PipeTransportEdge)this.edge;
        pipe.setPopulationIdentifier(population);
    }

    public double getPipeFlow() {
        PipeTransportEdgeLabelValue pipeValue = (PipeTransportEdgeLabelValue)this.edge.getLabel().getCurrentValue();
        return pipeValue.getMaxFlow();
    }

    public void setPipeFlow(double flow) {
        PipeTransportEdgeLabelValue pipeValue = (PipeTransportEdgeLabelValue)this.edge.getLabel().getCurrentValue();
        pipeValue.setMaxFlow(flow);
    }

    public long getPipePeriod() {
        PipeTransportEdgeLabelValue pipeValue = (PipeTransportEdgeLabelValue)this.edge.getLabel().getCurrentValue();
        return pipeValue.getTimePeriod();
    }

    public void setPipePeriod(long period) {
        PipeTransportEdgeLabelValue pipeValue = (PipeTransportEdgeLabelValue)this.edge.getLabel().getCurrentValue();
        pipeValue.setTimePeriod(period);
    }

    public int getCurveDepth() {
        return this.curveDepth;
    }

    public void setCurveDepth(int curveDepth) {
        this.curveDepth = curveDepth;
    }
}

