/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.model.ui.editor.parts;

import java.util.List;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.GraphicalNodeEditPolicy;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.stem.model.metamodel.Compartment;
import org.eclipse.stem.model.metamodel.CompartmentGroup;
import org.eclipse.stem.model.metamodel.Model;
import org.eclipse.stem.model.ui.editor.commands.TransitionCreateCommand;
import org.eclipse.stem.model.ui.editor.commands.TransitionReconnectCommand;
import org.eclipse.stem.model.ui.editor.controls.ModelCompartmentEditorDialog;
import org.eclipse.stem.model.ui.editor.figures.CompartmentFigure;
import org.eclipse.stem.model.ui.editor.parts.CompartmentComponentEditPolicy;
import org.eclipse.stem.model.ui.editor.vismodel.CompartmentElement;
import org.eclipse.stem.model.ui.editor.vismodel.ModelElement;
import org.eclipse.stem.model.ui.editor.vismodel.TransitionElement;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class CompartmentElementEditPart
extends AbstractGraphicalEditPart
implements NodeEditPart,
Adapter {
    private ConnectionAnchor anchor;

    public void activate() {
        if (!this.isActive()) {
            super.activate();
            this.getCastedModel().eAdapters().add((Object)this);
            this.getCastedModel().getCompartment().eAdapters().add((Object)this);
        }
    }

    public void deactivate() {
        if (this.isActive()) {
            this.getCastedModel().getCompartment().eAdapters().remove((Object)this);
            this.getCastedModel().eAdapters().remove((Object)this);
            super.deactivate();
        }
    }

    public void performRequest(Request req) {
        super.performRequest(req);
        if (req.getType().equals("open")) {
            CompartmentElement ce = this.getCastedModel();
            Compartment c = ce.getCompartment();
            ModelElement me = ce.getModelElement();
            Model m = me.getModel();
            CompartmentGroup cg = m.getCompartments();
            if (cg.getCompartments().contains((Object)c)) {
                ModelCompartmentEditorDialog dialog = new ModelCompartmentEditorDialog(Display.getCurrent().getActiveShell(), 0, cg, c);
                dialog.open();
                this.refreshVisuals();
            } else {
                MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Read only compartment", (String)"You cannot edit inherited compartments in this model.");
            }
        }
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new CompartmentComponentEditPolicy());
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new GraphicalNodeEditPolicy(){

            protected Command getConnectionCompleteCommand(CreateConnectionRequest request) {
                TransitionCreateCommand cmd = (TransitionCreateCommand)request.getStartCommand();
                cmd.setTarget((CompartmentElement)this.getHost().getModel());
                return cmd;
            }

            protected Command getConnectionCreateCommand(CreateConnectionRequest request) {
                CompartmentElement source = (CompartmentElement)this.getHost().getModel();
                TransitionCreateCommand cmd = new TransitionCreateCommand(source);
                request.setStartCommand((Command)cmd);
                return cmd;
            }

            protected Command getReconnectSourceCommand(ReconnectRequest request) {
                TransitionElement conn = (TransitionElement)request.getConnectionEditPart().getModel();
                CompartmentElement newSource = (CompartmentElement)this.getHost().getModel();
                TransitionReconnectCommand cmd = new TransitionReconnectCommand(conn);
                cmd.setNewSource(newSource);
                return cmd;
            }

            protected Command getReconnectTargetCommand(ReconnectRequest request) {
                TransitionElement conn = (TransitionElement)request.getConnectionEditPart().getModel();
                CompartmentElement newTarget = (CompartmentElement)this.getHost().getModel();
                TransitionReconnectCommand cmd = new TransitionReconnectCommand(conn);
                cmd.setNewTarget(newTarget);
                return cmd;
            }
        });
    }

    protected IFigure createFigure() {
        return new CompartmentFigure(this.getCastedModel());
    }

    private CompartmentElement getCastedModel() {
        return (CompartmentElement)this.getModel();
    }

    protected ConnectionAnchor getConnectionAnchor() {
        if (this.anchor == null) {
            this.anchor = new ChopboxAnchor(this.getFigure());
        }
        return this.anchor;
    }

    protected List<TransitionElement> getModelSourceConnections() {
        return this.getCastedModel().getSourceTransitions();
    }

    protected List<TransitionElement> getModelTargetConnections() {
        return this.getCastedModel().getTargetTransitions();
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        return this.getConnectionAnchor();
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return this.getConnectionAnchor();
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        return this.getConnectionAnchor();
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return this.getConnectionAnchor();
    }

    public void refreshVisuals() {
        CompartmentElement ce = this.getCastedModel();
        Rectangle bounds = new Rectangle(ce.getX(), ce.getY(), ce.getWidth(), ce.getHeight());
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)bounds);
        ((CompartmentFigure)this.getFigure()).setName(ce.getCompartment().getName());
    }

    public void notifyChanged(Notification notification) {
        this.refreshVisuals();
        this.refreshSourceConnections();
        this.refreshTargetConnections();
    }

    public Notifier getTarget() {
        return this.getCastedModel();
    }

    public void setTarget(Notifier newTarget) {
    }

    public boolean isAdapterForType(Object type) {
        return type instanceof CompartmentElement;
    }
}

