/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.io.File;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DirectoryDialog
extends Dialog {
    String message = "";
    String filterPath = "";
    static final String SEPARATOR = File.separator;
    private static final int PATH_MAX = 1024;

    public DirectoryDialog(Shell parent) {
        this(parent, 65536);
    }

    public DirectoryDialog(Shell parent, int style) {
        super(parent, DirectoryDialog.checkStyle(parent, style));
        this.checkSubclass();
    }

    public String getFilterPath() {
        return this.filterPath;
    }

    public String getMessage() {
        return this.message;
    }

    public String open() {
        return this.openChooserDialog();
    }

    String openChooserDialog() {
        int path;
        byte[] titleBytes = Converter.wcsToMbcs(this.title, true);
        int shellHandle = this.parent.topHandle();
        Display display = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
        int handle = 0;
        handle = display.getDismissalAlignment() == 131072 ? (GTK.GTK3 ? GTK.gtk_file_chooser_dialog_new(titleBytes, shellHandle, 2, GTK.GTK_NAMED_LABEL_CANCEL, -6, GTK.GTK_NAMED_LABEL_OK, -5, 0) : GTK.gtk_file_chooser_dialog_new(titleBytes, shellHandle, 2, GTK.GTK_STOCK_CANCEL(), -6, GTK.GTK_STOCK_OK(), -5, 0)) : (GTK.GTK3 ? GTK.gtk_file_chooser_dialog_new(titleBytes, shellHandle, 2, GTK.GTK_NAMED_LABEL_OK, -5, GTK.GTK_NAMED_LABEL_CANCEL, -6, 0) : GTK.gtk_file_chooser_dialog_new(titleBytes, shellHandle, 2, GTK.GTK_STOCK_OK(), -5, GTK.GTK_STOCK_CANCEL(), -6, 0));
        if (handle == 0) {
            this.error(2);
        }
        int group = GTK.gtk_window_get_group(0);
        GTK.gtk_window_group_add_window(group, handle);
        GTK.gtk_window_set_modal(handle, true);
        int pixbufs = GTK.gtk_window_get_icon_list(shellHandle);
        if (pixbufs != 0) {
            GTK.gtk_window_set_icon_list(handle, pixbufs);
            OS.g_list_free(pixbufs);
        }
        if (this.filterPath != null && this.filterPath.length() > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            if (!this.filterPath.startsWith(SEPARATOR)) {
                stringBuilder.append(SEPARATOR);
            }
            stringBuilder.append(this.filterPath);
            byte[] buffer = Converter.wcsToMbcs(stringBuilder.toString(), true);
            if (OS.IsAIX) {
                byte[] outputBuffer = new byte[1024];
                int ptr = OS.realpath(buffer, outputBuffer);
                if (ptr != 0) {
                    GTK.gtk_file_chooser_set_current_folder(handle, ptr);
                }
            } else {
                int ptr = OS.realpath(buffer, null);
                if (ptr != 0) {
                    GTK.gtk_file_chooser_set_current_folder(handle, ptr);
                    OS.g_free(ptr);
                }
            }
        }
        if (this.message.length() > 0) {
            int label;
            byte[] buffer = Converter.wcsToMbcs(this.message, true);
            int box = 0;
            if (GTK.GTK3) {
                box = GTK.gtk_box_new(0, 0);
                GTK.gtk_box_set_homogeneous(box, false);
            } else {
                box = GTK.gtk_hbox_new(false, 0);
            }
            if (box == 0) {
                this.error(2);
            }
            if ((label = GTK.gtk_label_new(buffer)) == 0) {
                this.error(2);
            }
            GTK.gtk_container_add(box, label);
            GTK.gtk_widget_show(label);
            GTK.gtk_label_set_line_wrap(label, true);
            GTK.gtk_label_set_justify(label, 2);
            GTK.gtk_file_chooser_set_extra_widget(handle, box);
        }
        String answer = null;
        display.addIdleProc();
        Dialog oldModal = null;
        if (GTK.gtk_window_get_modal(handle)) {
            oldModal = display.getModalDialog();
            display.setModalDialog(this);
        }
        int signalId = 0;
        int hookId = 0;
        if ((this.style & 0x4000000) != 0) {
            signalId = OS.g_signal_lookup(OS.map, GTK.GTK_TYPE_WIDGET());
            hookId = OS.g_signal_add_emission_hook(signalId, 0, display.emissionProc, handle, 0);
        }
        display.sendPreExternalEventDispatchEvent();
        int response = GTK.gtk_dialog_run(handle);
        GDK.gdk_threads_leave();
        display.sendPostExternalEventDispatchEvent();
        if ((this.style & 0x4000000) != 0) {
            OS.g_signal_remove_emission_hook(signalId, hookId);
        }
        if (GTK.gtk_window_get_modal(handle)) {
            display.setModalDialog(oldModal);
        }
        if (response == -5 && (path = GTK.gtk_file_chooser_get_filename(handle)) != 0) {
            int utf8Ptr = OS.g_filename_to_utf8(path, -1, null, null, null);
            if (utf8Ptr == 0) {
                utf8Ptr = OS.g_filename_display_name(path);
            }
            if (path != utf8Ptr) {
                OS.g_free(path);
            }
            if (utf8Ptr != 0) {
                int[] items_written = new int[1];
                int utf16Ptr = OS.g_utf8_to_utf16(utf8Ptr, -1, null, items_written, null);
                OS.g_free(utf8Ptr);
                if (utf16Ptr != 0) {
                    int clength = items_written[0];
                    char[] chars = new char[clength];
                    C.memmove(chars, utf16Ptr, clength * 2);
                    OS.g_free(utf16Ptr);
                    this.filterPath = answer = new String(chars);
                }
            }
        }
        display.removeIdleProc();
        GTK.gtk_widget_destroy(handle);
        return answer;
    }

    public void setFilterPath(String string) {
        this.filterPath = string;
    }

    public void setMessage(String string) {
        if (string == null) {
            this.error(4);
        }
        this.message = string;
    }
}

