/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.diseasemodels.experimental.impl;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.stem.core.graph.DynamicLabel;
import org.eclipse.stem.core.graph.IntegrationLabel;
import org.eclipse.stem.core.graph.IntegrationLabelValue;
import org.eclipse.stem.core.math.BinomialDistributionUtil;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.diseasemodels.experimental.ExperimentalFactory;
import org.eclipse.stem.diseasemodels.experimental.ExperimentalPackage;
import org.eclipse.stem.diseasemodels.experimental.TBDiseaseModel;
import org.eclipse.stem.diseasemodels.experimental.TBDiseaseModelLabelValue;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabel;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabelValue;
import org.eclipse.stem.diseasemodels.standard.Infector;
import org.eclipse.stem.diseasemodels.standard.SIInfector;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModelLabel;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModelLabelValue;
import org.eclipse.stem.diseasemodels.standard.StandardFactory;
import org.eclipse.stem.diseasemodels.standard.StandardPackage;
import org.eclipse.stem.diseasemodels.standard.impl.StandardDiseaseModelImpl;

public class TBDiseaseModelImpl
extends StandardDiseaseModelImpl
implements TBDiseaseModel {
    protected static final double TRANSMISSION_RATE_EDEFAULT = 1.2;
    protected double transmissionRate = 1.2;
    protected static final double ACTIVE_INF_PROB_EDEFAULT = 0.8;
    protected double activeInfProb = 0.8;

    protected EClass eStaticClass() {
        return ExperimentalPackage.Literals.TB_DISEASE_MODEL;
    }

    @Override
    public double getTransmissionRate() {
        return this.transmissionRate;
    }

    @Override
    public void setTransmissionRate(double newTransmissionRate) {
        this.transmissionRate = newTransmissionRate;
    }

    @Override
    public double getActiveInfProb() {
        return this.activeInfProb;
    }

    @Override
    public void setActiveInfProb(double newActiveInfProb) {
        this.activeInfProb = newActiveInfProb;
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 19: {
                return this.getTransmissionRate();
            }
            case 20: {
                return this.getActiveInfProb();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 19: {
                this.setTransmissionRate((Double)newValue);
                return;
            }
            case 20: {
                this.setActiveInfProb((Double)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 19: {
                this.setTransmissionRate(1.2);
                return;
            }
            case 20: {
                this.setActiveInfProb(0.8);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 19: {
                return this.transmissionRate != 1.2;
            }
            case 20: {
                return this.activeInfProb != 0.8;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (transmissionRate: ");
        result.append(this.transmissionRate);
        result.append(", activeInfProb: ");
        result.append(this.activeInfProb);
        result.append(')');
        return result.toString();
    }

    public void calculateDeltas(STEMTime time, double t, long timeDelta, EList<DynamicLabel> labels) {
        double adjustedTransmissionRate = this.getTransmissionRate() * (double)timeDelta / (double)this.getTimePeriod();
        int _i = 0;
        while (_i < labels.size()) {
            DynamicLabel label = (DynamicLabel)labels.get(_i);
            IntegrationLabel ilabel = (IntegrationLabel)label;
            StandardDiseaseModelLabel diseaseLabel = (StandardDiseaseModelLabel)ilabel;
            StandardDiseaseModelLabelValue currentState = (StandardDiseaseModelLabelValue)ilabel.getProbeValue();
            StandardDiseaseModelLabelValue deltaValue = (StandardDiseaseModelLabelValue)ilabel.getDeltaValue();
            deltaValue.reset();
            double beta = adjustedTransmissionRate;
            double p = this.getActiveInfProb();
            TBDiseaseModelLabelValue tbdelta = (TBDiseaseModelLabelValue)deltaValue;
            TBDiseaseModelLabelValue tbcurr = (TBDiseaseModelLabelValue)currentState;
            double S = tbcurr.getS();
            double iaEff = this.getNormalizedEffectiveInfectious(diseaseLabel.getNode(), diseaseLabel, tbcurr.getIa(), ExperimentalPackage.Literals.TB_DISEASE_MODEL_LABEL_VALUE__IA, StandardPackage.Literals.STANDARD_DISEASE_MODEL__CHARACTERISTIC_MIXING_DISTANCE, StandardPackage.Literals.STANDARD_DISEASE_MODEL__ROAD_NETWORK_INFECTIOUS_PROPORTION);
            tbdelta.setIa(beta * S * p * iaEff);
            tbdelta.setIl(beta * S * (1.0 - p) * iaEff);
            double incidence = beta * S * tbcurr.getIa() / tbcurr.getPopulationCount();
            tbdelta.setS(-incidence);
            tbdelta.setIncidence(incidence);
            this.computeAdditionalDeltasAndExchanges(ilabel, time, t, timeDelta);
            ++_i;
        }
    }

    public void doStochasticProcess(IntegrationLabel iLabel) {
        IntegrationLabelValue nextVal = (IntegrationLabelValue)iLabel.getNextValue();
        EList attrs = nextVal.eClass().getEAllAttributes();
        int i = 0;
        while (i < attrs.size()) {
            EAttribute attr = (EAttribute)attrs.get(i);
            if (attr.getEType().getClassifierID() == 31 && attr.isChangeable()) {
                nextVal.eSetDouble(attr.getFeatureID(), (double)Math.round(nextVal.eGetDouble(attr.getFeatureID())));
            }
            ++i;
        }
        if (this.getBinomialDistribution() == null) {
            this.setBinomialDistribution(new BinomialDistributionUtil(this.getRandomSeed()));
        }
        if (iLabel.getNextValue() instanceof TBDiseaseModelLabelValue) {
            TBDiseaseModelLabelValue nextTBVal = (TBDiseaseModelLabelValue)iLabel.getNextValue();
            TBDiseaseModelLabelValue previousTBVal = (TBDiseaseModelLabelValue)iLabel.getCurrentValue();
            double toIA = this.getActiveInfProb();
            double toIL = 1.0 - this.getActiveInfProb();
            this.addNoise((IntegrationLabelValue)previousTBVal, (IntegrationLabelValue)nextTBVal, StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_S(), StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_Incidence(), ExperimentalPackage.eINSTANCE.getTBDiseaseModelLabelValue_Ia(), toIA);
            this.addNoise((IntegrationLabelValue)previousTBVal, (IntegrationLabelValue)nextTBVal, StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_S(), StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_Incidence(), ExperimentalPackage.eINSTANCE.getTBDiseaseModelLabelValue_Il(), toIL);
        }
    }

    public DiseaseModelLabel createDiseaseModelLabel(String populationIdentifier) {
        return ExperimentalFactory.eINSTANCE.createTBDiseaseModelLabel();
    }

    public DiseaseModelLabelValue createDiseaseModelLabelValue(String populationIdentifier) {
        return ExperimentalFactory.eINSTANCE.createTBDiseaseModelLabelValue();
    }

    public Infector createInfector() {
        SIInfector retValue = StandardFactory.eINSTANCE.createSIInfector();
        retValue.setDiseaseName(this.getDiseaseName());
        retValue.setPopulationIdentifier(this.getPopulationIdentifier());
        return retValue;
    }
}

