/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.junit;

import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import java.util.stream.Stream;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.optional.junit.BaseTest;
import org.apache.tools.ant.taskdefs.optional.junit.Enumerations;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTest;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.Resources;

public final class BatchTest
extends BaseTest {
    private Project project;
    private Resources resources = new Resources();

    public BatchTest(Project project) {
        this.project = project;
        this.resources.setCache(true);
    }

    public void addFileSet(FileSet fs) {
        this.add((ResourceCollection)fs);
        if (fs.getProject() == null) {
            fs.setProject(this.project);
        }
    }

    public void add(ResourceCollection rc) {
        this.resources.add(rc);
    }

    public Enumeration<JUnitTest> elements() {
        JUnitTest[] tests = this.createAllJUnitTest();
        return Enumerations.fromArray(tests);
    }

    void addTestsTo(Vector<? super JUnitTest> v) {
        JUnitTest[] tests = this.createAllJUnitTest();
        v.ensureCapacity(v.size() + tests.length);
        for (int i = 0; i < tests.length; ++i) {
            v.addElement(tests[i]);
        }
    }

    private JUnitTest[] createAllJUnitTest() {
        return (JUnitTest[])Stream.of(this.getFilenames()).map(BatchTest::javaToClass).map(this::createJUnitTest).toArray(JUnitTest[]::new);
    }

    private String[] getFilenames() {
        return (String[])this.resources.stream().filter(Resource::isExists).map(Resource::getName).filter(name -> name.endsWith(".java") || name.endsWith(".class")).map(name -> name.substring(0, name.lastIndexOf(46))).toArray(String[]::new);
    }

    public static String javaToClass(String filename) {
        return filename.replace(File.separatorChar, '.').replace('/', '.').replace('\\', '.');
    }

    private JUnitTest createJUnitTest(String classname) {
        JUnitTest test = new JUnitTest();
        test.setName(classname);
        test.setHaltonerror(this.haltOnError);
        test.setHaltonfailure(this.haltOnFail);
        test.setFiltertrace(this.filtertrace);
        test.setFork(this.fork);
        test.setIf(this.getIfCondition());
        test.setUnless(this.getUnlessCondition());
        test.setTodir(this.destDir);
        test.setFailureProperty(this.failureProperty);
        test.setErrorProperty(this.errorProperty);
        test.setSkipNonTests(this.isSkipNonTests());
        this.formatters.forEach(test::addFormatter);
        return test;
    }
}

