/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.util.analysis;

import org.eclipse.stem.analysis.impl.ReferenceScenarioDataMapImpl;
import org.eclipse.stem.util.analysis.Activator;
import org.eclipse.stem.util.analysis.NonLinearSEIRParameterEstimator;
import org.eclipse.stem.util.analysis.ParameterEstimator;
import org.eclipse.stem.util.analysis.ParameterEstimatorMethod;
import org.eclipse.stem.util.analysis.SEIRparameterEstimator;
import org.eclipse.stem.util.analysis.SIRparameterEstimator;
import org.eclipse.stem.util.analysis.SIparameterEstimator;

public class ParameterEstimatorFactory {
    public static ParameterEstimator createEstimator(ParameterEstimatorMethod method, ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance data) {
        ParameterEstimator result = null;
        switch (method) {
            case SEIR: {
                result = new SEIRparameterEstimator(data);
                break;
            }
            case SIR: {
                result = new SIRparameterEstimator(data);
                break;
            }
            case SI: {
                result = new SIparameterEstimator(data);
                break;
            }
            case NONLINEARSEIR: {
                result = new NonLinearSEIRParameterEstimator(data);
                break;
            }
            default: {
                Activator.logError("Unknown method: " + (Object)((Object)method), null);
            }
        }
        return result;
    }
}

