/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.widgets;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.stem.definitions.LocationUtility;
import org.eclipse.stem.geography.names.GeographicNames;
import org.eclipse.stem.ui.Activator;
import org.eclipse.stem.ui.widgets.ISOKeyPickedEvent;
import org.eclipse.stem.ui.widgets.ISOKeyPickedEventListener;
import org.eclipse.stem.ui.widgets.ISOKeyPicker;
import org.eclipse.stem.ui.wizards.Messages;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class LocationPickerDialog
extends Dialog {
    private String title;
    private ISOKeyPicker isoKeyPicker2;
    private ISOKeyPicker isoKeyPicker1;
    private ISOKeyPicker isoKeyPicker0;
    private ISOKeyPicker isoKeyPicker3;
    String isoKey = "";
    URI targetURI = null;
    String tempISOKey = null;
    IProject project;
    private boolean selectGlobal = true;
    boolean cancelPressed = false;
    protected Shell shell;
    Composite mainComposite;

    public LocationPickerDialog(Shell parent, int style, String title, String prevLoc, IProject p) {
        super(parent, style);
        this.title = title;
        this.project = p;
    }

    public Object[] open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 68720);
        Point minS = new Point(1024, 768);
        this.shell.setMinimumSize(minS);
        GridLayout gl1 = new GridLayout();
        gl1.numColumns = 1;
        this.shell.setLayout((Layout)gl1);
        this.shell.setText(this.title);
        this.mainComposite = new Composite((Composite)this.shell, 1024);
        this.shell.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                LocationPickerDialog.this.shell.pack();
            }
        });
        GridLayout mainLayout = new GridLayout();
        mainLayout.numColumns = 2;
        mainLayout.makeColumnsEqualWidth = true;
        this.mainComposite.setLayout((Layout)mainLayout);
        GridData gridData = new GridData(4, 4, true, false);
        gridData.heightHint = 768;
        gridData.widthHint = 667;
        this.mainComposite.setLayoutData((Object)gridData);
        Composite radioComposite = new Composite(this.mainComposite, 2048);
        FillLayout fillLayout = new FillLayout();
        fillLayout.type = 256;
        radioComposite.setLayout((Layout)fillLayout);
        final Button[] radioButtons = new Button[2];
        radioButtons[0] = new Button(radioComposite, 16);
        radioButtons[0].setSelection(true);
        radioButtons[0].setText(Messages.getString("NLocPickerWiz.global"));
        radioButtons[1] = new Button(radioComposite, 16);
        radioButtons[1].setText(Messages.getString("NLocPickerWiz.inproject"));
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                if (event.widget == radioButtons[0]) {
                    if (radioButtons[0].getSelection()) {
                        LocationPickerDialog.this.selectGlobal = true;
                        LocationPickerDialog.this.reinit();
                    } else {
                        LocationPickerDialog.this.selectGlobal = false;
                        LocationPickerDialog.this.reinit();
                    }
                }
            }
        };
        radioButtons[0].addListener(13, listener);
        GridData gd_radio = new GridData(4, 0x1000000, true, false);
        gd_radio.horizontalSpan = 2;
        radioComposite.setLayoutData((Object)gd_radio);
        LocationUtility.reset();
        Label isoKeyLabel = new Label(this.mainComposite, 0);
        isoKeyLabel.setText(Messages.getString("NLocWizISOK"));
        GridData gd_isoKeyLabel = new GridData(4, 0x1000000, true, false);
        isoKeyLabel.setLayoutData((Object)gd_isoKeyLabel);
        final Label isokeyValueLabel = new Label(this.mainComposite, 0);
        isokeyValueLabel.setText(this.isoKey);
        GridData gd_isoKeyLabelValue = new GridData(4, 0x1000000, true, false);
        isokeyValueLabel.setLayoutData((Object)gd_isoKeyLabelValue);
        this.isoKeyPicker0 = new ISOKeyPicker(this.mainComposite, 0, 0);
        this.isoKeyPicker0.setISOKeyLevel(0);
        this.isoKeyPicker0.setISOKeyLevelDescription(Messages.getString("NLocWizCNTRY"));
        this.isoKeyPicker0.addISOKeyPickedListener(new ISOKeyPickedEventListener(){

            @Override
            public void isoKeyPicked(ISOKeyPickedEvent ikpe) {
                Object[] isoKeys = null;
                isoKeys = LocationPickerDialog.this.selectGlobal ? GeographicNames.getSubISOKeys((String)GeographicNames.getAlpha2((String)ikpe.getIsoKey()), (int)LocationPickerDialog.this.isoKeyPicker1.getISOKeyLevel()) : LocationUtility.getKeys((IProject)LocationPickerDialog.this.project, (int)LocationPickerDialog.this.isoKeyPicker1.getISOKeyLevel(), (String)ikpe.getIsoKey()).toArray();
                LocationPickerDialog.this.isoKeyPicker1.setISOKeys(isoKeys);
                LocationPickerDialog.this.isoKeyPicker2.setISOKeys(new Object[0]);
                LocationPickerDialog.this.isoKeyPicker3.setISOKeys(new Object[0]);
                LocationPickerDialog.this.isoKey = ikpe.getIsoKey();
                if (!LocationPickerDialog.this.selectGlobal) {
                    LocationPickerDialog.this.targetURI = LocationUtility.getURIFromISOKey((String)LocationPickerDialog.this.isoKey);
                }
                LocationPickerDialog.this.tempISOKey = LocationPickerDialog.this.isoKey;
                isokeyValueLabel.setText(LocationPickerDialog.this.isoKey);
            }
        });
        this.isoKeyPicker1 = new ISOKeyPicker(this.mainComposite, 0, 1);
        this.isoKeyPicker1.setISOKeyLevelDescription(Messages.getString("NLocWizL1"));
        this.isoKeyPicker1.addISOKeyPickedListener(new ISOKeyPickedEventListener(){

            @Override
            public void isoKeyPicked(ISOKeyPickedEvent ikpe) {
                Object[] isoKeys = null;
                isoKeys = LocationPickerDialog.this.selectGlobal ? GeographicNames.getSubISOKeys((String)ikpe.getIsoKey(), (int)LocationPickerDialog.this.isoKeyPicker2.getISOKeyLevel()) : LocationUtility.getKeys((IProject)LocationPickerDialog.this.project, (int)LocationPickerDialog.this.isoKeyPicker2.getISOKeyLevel(), (String)ikpe.getIsoKey()).toArray();
                LocationPickerDialog.this.isoKeyPicker2.setISOKeys(isoKeys);
                LocationPickerDialog.this.isoKey = ikpe.getIsoKey();
                if (!LocationPickerDialog.this.selectGlobal) {
                    LocationPickerDialog.this.targetURI = LocationUtility.getURIFromISOKey((String)LocationPickerDialog.this.isoKey);
                }
                String string = LocationPickerDialog.this.tempISOKey = LocationPickerDialog.this.tempISOKey == null ? LocationPickerDialog.this.isoKey : LocationPickerDialog.this.tempISOKey;
                if (isoKeys.length == 0) {
                    LocationPickerDialog.this.isoKey = LocationPickerDialog.this.tempISOKey;
                    isokeyValueLabel.setText(LocationPickerDialog.this.isoKey);
                    if (!LocationPickerDialog.this.selectGlobal) {
                        LocationPickerDialog.this.targetURI = LocationUtility.getURIFromISOKey((String)LocationPickerDialog.this.isoKey);
                    }
                    LocationPickerDialog.this.tempISOKey = null;
                }
            }
        });
        this.isoKeyPicker2 = new ISOKeyPicker(this.mainComposite, 0, 2);
        this.isoKeyPicker2.setISOKeyLevelDescription(Messages.getString("NLocWizL2"));
        this.isoKeyPicker2.addISOKeyPickedListener(new ISOKeyPickedEventListener(){

            @Override
            public void isoKeyPicked(ISOKeyPickedEvent ikpe) {
                Object[] isoKeys = null;
                isoKeys = LocationPickerDialog.this.selectGlobal ? GeographicNames.getSubISOKeys((String)ikpe.getIsoKey(), (int)LocationPickerDialog.this.isoKeyPicker3.getISOKeyLevel()) : LocationUtility.getKeys((IProject)LocationPickerDialog.this.project, (int)LocationPickerDialog.this.isoKeyPicker3.getISOKeyLevel(), (String)ikpe.getIsoKey()).toArray();
                LocationPickerDialog.this.isoKeyPicker3.setISOKeys(isoKeys);
                LocationPickerDialog.this.isoKey = ikpe.getIsoKey();
                if (!LocationPickerDialog.this.selectGlobal) {
                    LocationPickerDialog.this.targetURI = LocationUtility.getURIFromISOKey((String)LocationPickerDialog.this.isoKey);
                }
                String string = LocationPickerDialog.this.tempISOKey = LocationPickerDialog.this.tempISOKey == null ? LocationPickerDialog.this.isoKey : LocationPickerDialog.this.tempISOKey;
                if (isoKeys.length == 0) {
                    LocationPickerDialog.this.isoKey = LocationPickerDialog.this.tempISOKey;
                    isokeyValueLabel.setText(LocationPickerDialog.this.isoKey);
                    if (!LocationPickerDialog.this.selectGlobal) {
                        LocationPickerDialog.this.targetURI = LocationUtility.getURIFromISOKey((String)LocationPickerDialog.this.isoKey);
                    }
                    LocationPickerDialog.this.tempISOKey = null;
                }
            }
        });
        this.isoKeyPicker3 = new ISOKeyPicker(this.mainComposite, 0, 3);
        this.isoKeyPicker3.setISOKeyLevelDescription(Messages.getString("NLocWizL3"));
        this.isoKeyPicker3.addISOKeyPickedListener(new ISOKeyPickedEventListener(){

            @Override
            public void isoKeyPicked(ISOKeyPickedEvent ikpe) {
                LocationPickerDialog.this.isoKey = LocationPickerDialog.this.tempISOKey == null ? ikpe.getIsoKey() : LocationPickerDialog.this.tempISOKey;
                isokeyValueLabel.setText(LocationPickerDialog.this.isoKey);
                LocationPickerDialog.this.tempISOKey = null;
                if (!LocationPickerDialog.this.selectGlobal) {
                    LocationPickerDialog.this.targetURI = LocationUtility.getURIFromISOKey((String)LocationPickerDialog.this.isoKey);
                }
            }
        });
        this.setKeyPickerLayouts();
        Button okayButton = new Button(this.mainComposite, 0);
        GridData gd = new GridData();
        okayButton.setText(Messages.getString("NLocWizOk"));
        okayButton.setLayoutData((Object)gd);
        Button cancelButton = new Button(this.mainComposite, 0);
        gd = new GridData();
        cancelButton.setText(Messages.getString("NLocWizCancel"));
        cancelButton.setLayoutData((Object)gd);
        this.shell.pack();
        this.shell.open();
        okayButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                LocationPickerDialog.this.cancelPressed = false;
                LocationPickerDialog.this.shell.dispose();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        cancelButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                LocationPickerDialog.this.cancelPressed = true;
                LocationPickerDialog.this.shell.dispose();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        Display display = parent.getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        if (this.cancelPressed) {
            return null;
        }
        Object[] ret = new Object[]{this.isoKey, this.targetURI};
        return ret;
    }

    public void setKeyPickerLayouts() {
        GridData gd_isoKeyPicker0 = new GridData(1808);
        gd_isoKeyPicker0.verticalSpan = 1;
        gd_isoKeyPicker0.horizontalSpan = 1;
        this.isoKeyPicker0.setLayoutData(gd_isoKeyPicker0);
        this.isoKeyPicker0.setISOKeys(GeographicNames.getSubISOKeys((String)"ZZZ", (int)-1));
        GridData gd_isoKeyPicker1 = new GridData(1808);
        gd_isoKeyPicker1.verticalSpan = 1;
        gd_isoKeyPicker1.horizontalSpan = 1;
        this.isoKeyPicker1.setLayoutData(gd_isoKeyPicker1);
        GridData gd_isoKeyPicker2 = new GridData(1808);
        gd_isoKeyPicker2.verticalSpan = 1;
        gd_isoKeyPicker2.horizontalSpan = 1;
        this.isoKeyPicker2.setLayoutData(gd_isoKeyPicker2);
        GridData gd_isoKeyPicker3 = new GridData(1808);
        gd_isoKeyPicker3.verticalSpan = 1;
        gd_isoKeyPicker3.horizontalSpan = 1;
        this.isoKeyPicker3.setLayoutData(gd_isoKeyPicker3);
    }

    public void reSetKeyPickerBounds(int width, int height, int x0, int y0) {
        this.isoKeyPicker0.setRegionListSize(width, height);
        this.isoKeyPicker1.setRegionListSize(width, height);
        this.isoKeyPicker2.setRegionListSize(width, height);
        this.isoKeyPicker3.setRegionListSize(width, height);
        this.isoKeyPicker0.setRegionListBounds(x0, y0, width, height);
        this.isoKeyPicker1.setRegionListBounds(x0 + width, y0, width, height);
        this.isoKeyPicker2.setRegionListBounds(x0, y0 + height, width, height);
        this.isoKeyPicker3.setRegionListBounds(x0 + width, y0 + height, width, height);
    }

    public void reSetKeyPickerSize(int width, int height) {
        this.isoKeyPicker0.setRegionListSize(width, height);
        this.isoKeyPicker1.setRegionListSize(width, height);
        this.isoKeyPicker2.setRegionListSize(width, height);
        this.isoKeyPicker3.setRegionListSize(width, height);
    }

    public void reinit() {
        if (this.selectGlobal) {
            this.isoKeyPicker0.setISOKeys(GeographicNames.getSubISOKeys((String)"ZZZ", (int)-1));
        } else {
            IRunnableWithProgress getKeys = new IRunnableWithProgress(){

                public void run(IProgressMonitor progress) {
                    progress.beginTask(Messages.getString("NLocPickerWiz.gettingLocations"), 100);
                    Object[] entries = LocationUtility.getKeys((IProject)LocationPickerDialog.this.project, (int)0, null).toArray();
                    int nextLevel = 0;
                    while ((entries == null || entries.length == 0) && nextLevel <= 2) {
                        entries = LocationUtility.getKeys((IProject)LocationPickerDialog.this.project, (int)(++nextLevel), null).toArray();
                    }
                    LocationPickerDialog.this.isoKeyPicker0.setISOKeys(entries);
                    progress.worked(100);
                    progress.done();
                }
            };
            ProgressMonitorDialog context = new ProgressMonitorDialog(this.shell);
            try {
                context.run(true, true, getKeys);
            }
            catch (Exception e) {
                Activator.logError(e.getMessage(), e);
            }
        }
        this.isoKeyPicker1.setISOKeys(new Object[0]);
        this.isoKeyPicker2.setISOKeys(new Object[0]);
        this.isoKeyPicker3.setISOKeys(new Object[0]);
    }

    public String getISOKey() {
        return this.isoKey;
    }
}

