/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.widgets;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.stem.core.graph.DynamicLabel;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.model.Decorator;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProvider;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProviderAdapter;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProviderAdapterFactory;
import org.eclipse.stem.diseasemodels.standard.DiseaseModel;
import org.eclipse.stem.jobs.simulation.ISimulation;
import org.eclipse.stem.populationmodels.standard.PopulationModel;
import org.eclipse.stem.ui.views.geographic.map.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class DecoratorSelector
extends Composite {
    private final List<DecoratorSelectionListener> propertySelectionListeners = new CopyOnWriteArrayList<DecoratorSelectionListener>();
    private ISimulation simulation = null;
    private final Label displayLabel;
    Combo decoratorsCombo;
    Combo populationIdCombo;
    List<Decorator> decorators;
    Decorator selectedDecorator;
    String selectedProperty;
    String[] popIds;
    private DecoratorFilter decoratorFilter = new DecoratorFilter(){

        @Override
        public boolean accept(Decorator decorator) {
            return true;
        }
    };
    private PropertySieve propertySieve = new PropertySieve(){

        @Override
        public List<ItemPropertyDescriptor> sieve(DynamicLabel dynamicLabel) {
            ArrayList<ItemPropertyDescriptor> retValue = new ArrayList<ItemPropertyDescriptor>();
            RelativeValueProviderAdapter rvp = (RelativeValueProviderAdapter)RelativeValueProviderAdapterFactory.INSTANCE.adapt((Notifier)dynamicLabel, RelativeValueProvider.class);
            if (rvp != null) {
                rvp.setTarget((Notifier)dynamicLabel);
                for (Object element : rvp.getProperties()) {
                    ItemPropertyDescriptor property = (ItemPropertyDescriptor)element;
                    retValue.add(property);
                }
            }
            return retValue;
        }
    };

    public DecoratorSelector(Composite parent, int style, boolean allowDecoratorSelection) {
        super(parent, style);
        FormLayout retValueLayout = new FormLayout();
        this.setLayout((Layout)retValueLayout);
        this.displayLabel = new Label((Composite)this, 0x1000000);
        this.displayLabel.setText(String.valueOf(Messages.getString("IMView.MProp")) + " :");
        this.decoratorsCombo = new Combo((Composite)this, 0x100000C);
        this.populationIdCombo = new Combo((Composite)this, 0x100000C);
        FormData decoratorsComboFormData = new FormData();
        decoratorsComboFormData.top = new FormAttachment((Control)this.displayLabel, 0);
        decoratorsComboFormData.left = new FormAttachment(0, 0);
        decoratorsComboFormData.right = new FormAttachment(100, 0);
        this.decoratorsCombo.setLayoutData((Object)decoratorsComboFormData);
        FormData populationIdComboData = new FormData();
        populationIdComboData.top = new FormAttachment((Control)this.decoratorsCombo, 0);
        populationIdComboData.left = new FormAttachment(0, 0);
        populationIdComboData.right = new FormAttachment(100, 0);
        this.populationIdCombo.setLayoutData((Object)populationIdComboData);
        this.pack();
        this.decoratorsCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Decorator tempDecorator;
                if (!DecoratorSelector.this.decorators.isEmpty() && DecoratorSelector.this.selectedDecorator != (tempDecorator = DecoratorSelector.this.decorators.get(DecoratorSelector.this.decoratorsCombo.getSelectionIndex()))) {
                    DecoratorSelector.this.selectedDecorator = tempDecorator;
                    DecoratorSelector.this.popIds = DecoratorSelector.this.getPopulationIdsToDisplay(DecoratorSelector.this.selectedDecorator);
                    DecoratorSelector.this.initializeCombo(DecoratorSelector.this.populationIdCombo, DecoratorSelector.this.popIds, 0);
                    DecoratorSelector.this.selectedProperty = DecoratorSelector.this.popIds[0];
                    DecoratorSelector.this.notifyDecoratorSelection(DecoratorSelector.this.selectedProperty);
                }
            }
        });
        this.populationIdCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String temp;
                if (DecoratorSelector.this.popIds != null && !DecoratorSelector.this.selectedProperty.equals(temp = DecoratorSelector.this.popIds[DecoratorSelector.this.populationIdCombo.getSelectionIndex()])) {
                    DecoratorSelector.this.selectedProperty = temp;
                    DecoratorSelector.this.notifyDecoratorSelection(DecoratorSelector.this.selectedProperty);
                }
            }
        });
        if (!allowDecoratorSelection) {
            this.populationIdCombo.setEnabled(false);
        }
        this.setSimulation(null);
    }

    void notifyDecoratorSelection(String selectedId) {
        if (this.selectedProperty != null) {
            this.fireDecoratorSelectionEvent(new DecoratorSelectionEvent(this.selectedDecorator, selectedId, (Object)this));
        }
    }

    public boolean isInitialized() {
        return this.decorators != null && !this.decorators.isEmpty();
    }

    public void setDecorators(List<Decorator> decorators) {
        this.decorators = decorators;
        int selectionIndex = 0;
        if (decorators != null && decorators.size() >= 2) {
            int i = 0;
            while (i < decorators.size()) {
                Decorator dec = decorators.get(i);
                if (dec instanceof DiseaseModel) {
                    selectionIndex = i;
                    break;
                }
                ++i;
            }
        }
        this.selectedDecorator = decorators.isEmpty() ? null : decorators.get(selectionIndex);
        this.popIds = this.getPopulationIdsToDisplay(this.selectedDecorator);
        if (this.popIds == null) {
            this.popIds = new String[0];
        }
        this.selectedProperty = this.popIds.length == 0 ? "" : this.popIds[0];
        this.initializeCombo(this.decoratorsCombo, this.getDecoratorNames(decorators), this.getDecoratorIndex(this.selectedDecorator, decorators));
        this.initializeCombo(this.populationIdCombo, this.popIds, 0);
        this.notifyDecoratorSelection(this.selectedProperty);
    }

    public void setSimulation(ISimulation simulation) {
        this.simulation = simulation;
        this.setDecorators(this.getDecoratorsToDisplay(simulation));
    }

    public final ISimulation getSimulation() {
        return this.simulation;
    }

    public void setDecoratorFilter(DecoratorFilter decoratorFilter) {
        this.decoratorFilter = decoratorFilter;
    }

    private List<Decorator> getDecoratorsToDisplay(ISimulation simulation) {
        Graph canonicalGraph;
        ArrayList<Decorator> retValue = new ArrayList<Decorator>();
        if (simulation != null && (canonicalGraph = simulation.getScenario().getCanonicalGraph()) != null) {
            for (Object element : canonicalGraph.getDecorators()) {
                Decorator decorator = (Decorator)element;
                if (!this.decoratorFilter.accept(decorator)) continue;
                retValue.add(decorator);
            }
        }
        return retValue;
    }

    String[] getPopulationIdsToDisplay(Decorator decorator) {
        if (decorator instanceof DiseaseModel) {
            EList ids = ((DiseaseModel)decorator).getAllLabelIdentifiers();
            return ids.toArray(new String[0]);
        }
        if (decorator instanceof PopulationModel) {
            EList ids = ((PopulationModel)decorator).getAllLabelIdentifiers();
            return ids.toArray(new String[0]);
        }
        return null;
    }

    void initializeCombo(Combo combo, String[] names, int selectionIndex) {
        if (!combo.isDisposed()) {
            combo.setItems(names);
            combo.select(selectionIndex);
        }
    }

    private String[] getDecoratorNames(List<Decorator> decorators) {
        ArrayList<String> retValue = new ArrayList<String>();
        if (decorators != null) {
            Iterator<Decorator> iterator = decorators.iterator();
            while (iterator.hasNext()) {
                ComposedAdapterFactory itemProviderFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
                Decorator decorator = iterator.next();
                IItemLabelProvider lp = (IItemLabelProvider)itemProviderFactory.adapt((Notifier)decorator, IItemLabelProvider.class);
                String title = lp.getText((Object)decorator);
                title = title == null ? "null" : title;
                retValue.add(title);
            }
        }
        return retValue.toArray(new String[0]);
    }

    private int getDecoratorIndex(Decorator selectedDecorator, List<Decorator> decorators) {
        if (selectedDecorator != null && decorators != null && !decorators.isEmpty()) {
            return decorators.indexOf(selectedDecorator);
        }
        return 0;
    }

    int getPropertyIndex(ItemPropertyDescriptor selectedDecoratorProperty, List<ItemPropertyDescriptor> decoratorProperties) {
        if (selectedDecoratorProperty != null) {
            return decoratorProperties.indexOf(selectedDecoratorProperty);
        }
        return 0;
    }

    public void addDecoratorSelectionListener(DecoratorSelectionListener listener) {
        this.propertySelectionListeners.add(listener);
    }

    public void removeDecoratorSelectionListener(DecoratorSelectionListener listener) {
        this.propertySelectionListeners.remove(listener);
    }

    private void fireDecoratorSelectionEvent(DecoratorSelectionEvent pse) {
        for (DecoratorSelectionListener listener : this.propertySelectionListeners) {
            listener.decoratorSelected(pse);
        }
    }

    public String getDisplayLabel() {
        return this.displayLabel.getText();
    }

    public void setDisplayLabel(String displayLabel) {
        this.displayLabel.setText(displayLabel);
    }

    public static interface DecoratorFilter {
        public boolean accept(Decorator var1);
    }

    public static class DecoratorSelectionEvent
    extends EventObject {
        private static final long serialVersionUID = 1L;
        private final transient String id;
        private final transient Decorator decorator;

        public DecoratorSelectionEvent(Decorator decorator, String id, Object source) {
            super(source);
            this.decorator = decorator;
            this.id = id;
        }

        public final Decorator getDecorator() {
            return this.decorator;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder(this.decorator == null ? "null," : this.decorator.getDublinCore().getTitle());
            sb.append(this.id == null ? "null" : this.id);
            return sb.toString();
        }
    }

    public static interface DecoratorSelectionListener {
        public void decoratorSelected(DecoratorSelectionEvent var1);
    }

    public static interface PropertySieve {
        public List<ItemPropertyDescriptor> sieve(DynamicLabel var1);
    }
}

