/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.views.geographic.map;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.stem.ui.views.geographic.map.MapCanvas;

public class SelectedReportsManager {
    private static SelectedReportsManager instance;
    private final Map<MapCanvas, List<String>> enabledReportsMap = new HashMap<MapCanvas, List<String>>();
    private final Map<MapCanvas, List<String>> alreadySelectedReports = new HashMap<MapCanvas, List<String>>();
    private MapCanvas recentClickedMapCanvas = null;

    private SelectedReportsManager() {
    }

    public static SelectedReportsManager getInstance() {
        if (instance == null) {
            instance = new SelectedReportsManager();
        }
        return instance;
    }

    public void enableReportForIdentifiable(String reportID) {
        List<String> enabledReports = null;
        if (this.enabledReportsMap.containsKey((Object)this.recentClickedMapCanvas)) {
            enabledReports = this.enabledReportsMap.get((Object)this.recentClickedMapCanvas);
            this.enabledReportsMap.remove((Object)this.recentClickedMapCanvas);
        }
        if (enabledReports == null) {
            enabledReports = new ArrayList<String>();
        }
        enabledReports.add(reportID);
        this.enabledReportsMap.put(this.recentClickedMapCanvas, enabledReports);
    }

    public void disableReportForIdentifiable(String reportID) {
        List<String> initializedReports;
        List<String> enabledReports = null;
        if (this.enabledReportsMap.containsKey((Object)this.recentClickedMapCanvas)) {
            enabledReports = this.enabledReportsMap.get((Object)this.recentClickedMapCanvas);
            this.enabledReportsMap.remove((Object)this.recentClickedMapCanvas);
        }
        if (enabledReports != null) {
            enabledReports.remove(reportID);
        }
        if ((initializedReports = this.alreadySelectedReports.get((Object)this.recentClickedMapCanvas)) == null) {
            initializedReports = new ArrayList<String>();
        }
        initializedReports.add(reportID);
        if (this.alreadySelectedReports.containsKey((Object)this.recentClickedMapCanvas)) {
            this.alreadySelectedReports.remove((Object)this.recentClickedMapCanvas);
        }
        this.alreadySelectedReports.put(this.recentClickedMapCanvas, initializedReports);
    }

    public boolean isReportEnabled(String reportID) {
        List<String> initializedReports = this.alreadySelectedReports.get((Object)this.recentClickedMapCanvas);
        if (initializedReports == null || !initializedReports.contains(reportID)) {
            return true;
        }
        if (!this.enabledReportsMap.containsKey((Object)this.recentClickedMapCanvas)) {
            return false;
        }
        List<String> enabledReports = this.enabledReportsMap.get((Object)this.recentClickedMapCanvas);
        return enabledReports != null && enabledReports.contains(reportID);
    }

    public MapCanvas getRecentClickedMapCanvas() {
        return this.recentClickedMapCanvas;
    }

    public void setRecentClickedMapCanvas(MapCanvas recentClickedMapCanvas) {
        this.recentClickedMapCanvas = recentClickedMapCanvas;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }
}

