/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.stem.adapters.file.File;
import org.eclipse.stem.ui.Activator;
import org.eclipse.stem.ui.views.explorer.IdentifiableTreeNode;
import org.eclipse.stem.ui.widgets.RefactorWizard;
import org.eclipse.stem.ui.wizards.STEMWizardDialog;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public class DeleteHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        TreePath parent;
        Object parentSeg;
        TreeSelection ts;
        TreePath[] paths;
        ISelection selection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)executionEvent);
        if (selection instanceof StructuredSelection) {
            for (Object obj : ((StructuredSelection)selection).toList()) {
                File file = (File)Platform.getAdapterManager().getAdapter(obj, File.class);
                if (file != null) {
                    this.doit(file, executionEvent);
                    continue;
                }
                Activator.logError("STEM Internal error delete command applied to \"" + obj.getClass().getName() + "\"", null);
            }
        }
        if (selection instanceof TreeSelection && (paths = (ts = (TreeSelection)selection).getPaths()).length > 0 && (parentSeg = (parent = paths[0].getParentPath()).getLastSegment()) != null) {
            IProject project = null;
            if (parentSeg instanceof IdentifiableTreeNode) {
                project = ((IdentifiableTreeNode)parentSeg).getProject();
            }
            if (parentSeg instanceof IProject) {
                project = (IProject)parentSeg;
            }
            try {
                project.refreshLocal(2, null);
            }
            catch (Exception e) {
                Activator.logError(e.getMessage(), e);
            }
        }
        return null;
    }

    protected void doit(File file, ExecutionEvent executionEvent) {
        IWorkbenchWindow window = null;
        try {
            window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)executionEvent);
        }
        catch (ExecutionException e1) {
            e1.printStackTrace();
        }
        RefactorWizard refWizard = new RefactorWizard(file.getIdentifiable(), file.getResource(), true);
        refWizard.init(window.getWorkbench(), (IStructuredSelection)StructuredSelection.EMPTY);
        STEMWizardDialog wizardDialog = new STEMWizardDialog(window.getShell(), (IWizard)refWizard);
        wizardDialog.open();
    }
}

