/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.adapters.color;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.stem.ui.Activator;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;

public class StandardColorProvider {
    private Device device = null;
    private IPreferenceStore preferenceStore;

    public StandardColorProvider(Device device) {
        this.device = device;
        this.preferenceStore = Activator.getDefault().getPreferenceStore();
    }

    public Color getBackgroundColor() {
        return this.getColorFromString(this.preferenceStore.getString("org.eclipse.stem.ui.views.geographic.map.preferences.backgroundcolor"));
    }

    public Color getBordersColor() {
        return this.getColorFromString(this.preferenceStore.getString("org.eclipse.stem.ui.views.geographic.map.preferences.borderscolor"));
    }

    public int getBordersAlpha() {
        return this.preferenceStore.getInt("org.eclipse.stem.ui.views.geographic.map.preferences.bordersalpha");
    }

    public Color getEdgesColor() {
        return this.getColorFromString(this.preferenceStore.getString("org.eclipse.stem.ui.views.geographic.map.preferences.edgescolor"));
    }

    public Color getForegroundColor() {
        return this.getColorFromString(this.preferenceStore.getString("org.eclipse.stem.ui.views.geographic.map.preferences.foregroundcolor"));
    }

    public Color getColorFromString(String rgbString) {
        if (rgbString.equals("")) {
            return this.device.getSystemColor(2);
        }
        RGB rgb = StringConverter.asRGB((String)rgbString);
        return new Color(this.device, rgb.red, rgb.green, rgb.blue);
    }
}

