/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.adapters.color;

import java.text.DecimalFormat;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ColorScaleComposite
extends Composite {
    Group scaleGroup = new Group((Composite)this, 0);
    CLabel colorScale;
    static final int NUM_AXIS_LABELS = 5;
    Label[] valueScale = new Label[5];
    static final int SCALE_HEIGHT = 20;
    static final int SCALE_WIDTH = 100;
    DecimalFormat sciFormat = new DecimalFormat("0.#E0");
    boolean useLogScale = false;
    static final int NUM_STEPS = 5;

    public ColorScaleComposite(Composite parent, Color saturatedColor, double[] axis, boolean logScale, int style, Color backGround, Color textColor) {
        super(parent, style);
        this.scaleGroup.setText("Scale");
        FormLayout scaleLayout = new FormLayout();
        this.scaleGroup.setLayout((Layout)scaleLayout);
        this.colorScale = new CLabel((Composite)this.scaleGroup, 16384);
        this.colorScale.setBackground(backGround);
        this.colorScale.setForeground(textColor);
        this.colorScale.setLayoutData((Object)new GridData(768));
        FormData scaleData = new FormData();
        scaleData.top = new FormAttachment(0, 0);
        scaleData.bottom = new FormAttachment(50, 0);
        scaleData.left = new FormAttachment(0, 0);
        scaleData.right = new FormAttachment(100, 0);
        this.colorScale.setLayoutData((Object)scaleData);
        int leftMargin = 0;
        int step = 20;
        int i = 0;
        while (i < 5) {
            this.valueScale[i] = new Label((Composite)this.scaleGroup, 16384);
            FormData valueData = new FormData();
            valueData.top = new FormAttachment(50, 0);
            valueData.bottom = new FormAttachment(100, 0);
            valueData.left = new FormAttachment(leftMargin, 0);
            valueData.right = new FormAttachment(leftMargin + step, 0);
            this.valueScale[i].setLayoutData((Object)valueData);
            this.valueScale[i].setText(" ");
            leftMargin += step;
            this.valueScale[i].setBackground(backGround);
            this.valueScale[i].setForeground(textColor);
            ++i;
        }
        this.updateColorScale(saturatedColor, axis, logScale, backGround, textColor);
        this.scaleGroup.setVisible(true);
        this.scaleGroup.pack();
        this.layout();
        this.pack();
        this.setVisible(true);
    }

    public void updateColorScale(Color saturatedColor, double[] axis, boolean logScale, Color textBackGround, Color textForeground) {
        Color[] scaleColors = new Color[5];
        int size = 4;
        double r = saturatedColor.getRed();
        double g = saturatedColor.getGreen();
        double b = saturatedColor.getBlue();
        int i = 0;
        while (i < 5) {
            double alphaF = (double)i / 4.0;
            int ir = (int)(alphaF * r);
            int ig = (int)(alphaF * g);
            int ib = (int)(alphaF * b);
            scaleColors[i] = new Color((Device)this.getDisplay(), ir, ig, ib);
            ++i;
        }
        int[] spacing = new int[size];
        if (size <= 0) {
            size = 1;
        }
        int delta = 100 / size;
        int i2 = 0;
        while (i2 < size) {
            spacing[i2] = delta * (i2 + 1);
            ++i2;
        }
        this.colorScale.setBackground(scaleColors, spacing);
        i2 = 0;
        while (i2 < 5) {
            this.valueScale[i2].setBackground(textBackGround);
            this.valueScale[i2].setForeground(textForeground);
            ++i2;
        }
        int last = 4;
        this.valueScale[last].setAlignment(131072);
        if (axis[1] == 1.0) {
            this.valueScale[last].setText("1.0");
        } else {
            this.valueScale[last].setText(this.sciFormat.format(axis[1]));
        }
        if (logScale) {
            double min = 0.01 * axis[1];
            this.valueScale[0].setText("< " + this.sciFormat.format(min));
        } else {
            this.valueScale[0].setText("" + axis[0]);
        }
    }

    public boolean isUseLogScale() {
        return this.useLogScale;
    }

    public void setUseLogScale(boolean useLogScale) {
        this.useLogScale = useLogScale;
    }
}

