/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.search.ui.incquery.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.sphinx.emf.incquery.IncQueryEngineHelper;
import org.eclipse.sphinx.emf.model.IModelDescriptor;
import org.eclipse.sphinx.emf.search.ui.ModelSearchMatch;
import org.eclipse.sphinx.emf.search.ui.QuerySpecification;
import org.eclipse.sphinx.emf.search.ui.incquery.internal.Activator;
import org.eclipse.sphinx.emf.search.ui.services.IModelSearchService;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;

public abstract class AbstractIncQueryModelSearchService
implements IModelSearchService {
    protected abstract List<ModelSearchMatch> getMatches(IncQueryEngine var1, QuerySpecification var2);

    public List<ModelSearchMatch> getMatches(Collection<Resource> resources, QuerySpecification querySpec) {
        ArrayList<ModelSearchMatch> result = new ArrayList<ModelSearchMatch>();
        for (Resource resource : resources) {
            try {
                IncQueryEngine engine = this.getIncQueryEngineHelper().getEngine(resource, true);
                result.addAll(this.getMatches(engine, querySpec));
            }
            catch (IncQueryException ex) {
                PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)((Object)ex));
            }
        }
        return result;
    }

    public List<ModelSearchMatch> getMatches(IModelDescriptor modelDescriptor, QuerySpecification querySpec) {
        Collection loadedResources = modelDescriptor.getLoadedResources(false);
        return this.getMatches(loadedResources, querySpec);
    }

    protected IncQueryEngineHelper getIncQueryEngineHelper() {
        return new IncQueryEngineHelper();
    }
}

