/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.platform.cli;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.sphinx.platform.cli.ICommonCLIConstants;
import org.eclipse.sphinx.platform.internal.Activator;
import org.eclipse.sphinx.platform.internal.messages.Messages;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;

public abstract class AbstractCLIApplication
implements IApplication {
    public static final Object ERROR_NO = 0;
    public static final Object ERROR_UNSPECIFIED = 1;
    protected static final int DEFAULT_HELP_WIDTH = 160;
    private String[] applicationArgs;
    private Options options = new Options();
    private CommandLineParser parser;
    private CommandLine commandLine = null;
    protected PrintStream out = System.out;
    protected PrintStream err = System.err;

    @Deprecated
    protected String getApplicationName() {
        return null;
    }

    protected String getApplicationDescription() {
        return null;
    }

    protected String getCommandLineSyntax() {
        return this.getApplicationName();
    }

    protected String[] getApplicationArgs() {
        return this.applicationArgs;
    }

    protected Options getOptions() {
        return this.options;
    }

    protected void addOption(Option option) {
        if (option != null) {
            this.options.addOption(option);
        }
    }

    protected CommandLine getCommandLine() {
        return this.commandLine;
    }

    public void setOutputStream(PrintStream out) {
        this.out = out;
    }

    public void setErrorStream(PrintStream err) {
        this.err = err;
    }

    public Object start(IApplicationContext context) {
        this.initApplicationArgs(context);
        return this.doRun();
    }

    public void stop() {
    }

    public Object run(String[] args) {
        this.initApplicationArgs(args);
        return this.doRun();
    }

    private Object doRun() {
        try {
            this.defineOptions();
            this.parse();
            return this.interrogate();
        }
        catch (Throwable t) {
            return this.handleError(t);
        }
    }

    private void initApplicationArgs(IApplicationContext context) {
        Map arguments = context.getArguments();
        Object args = arguments.get("application.args");
        this.applicationArgs = args instanceof String[] ? (String[])args : new String[]{};
    }

    private void initApplicationArgs(String[] args) {
        this.applicationArgs = args != null ? args : new String[]{};
    }

    protected void defineOptions() {
        this.addOption(new Option("help", ICommonCLIConstants.OPTION_HELP_DESCRIPTION));
    }

    protected void parse() throws ParseException {
        this.commandLine = this.getParser().parse(this.getOptions(), this.getApplicationArgs());
    }

    protected CommandLineParser getParser() {
        if (this.parser == null) {
            this.parser = this.createParser();
        }
        return this.parser;
    }

    protected CommandLineParser createParser() {
        return new PosixParser(){

            protected void checkRequiredOptions() throws MissingOptionException {
                if (AbstractCLIApplication.this.isHelpNeeded(this.cmd)) {
                    return;
                }
                super.checkRequiredOptions();
            }
        };
    }

    protected Object interrogate() throws Throwable {
        if (this.isHelpNeeded(this.getCommandLine())) {
            this.printHelp();
            throw new OperationCanceledException();
        }
        return ERROR_NO;
    }

    protected boolean isHelpNeeded(CommandLine commandLine) {
        return commandLine.getOptions().length == 0 || commandLine.hasOption("help");
    }

    protected void printHelp() {
        String description = this.getApplicationDescription();
        if (description != null && description.length() > 0) {
            this.out.println(description);
            this.out.println();
        }
        HelpFormatter formatter = new HelpFormatter();
        formatter.setSyntaxPrefix(Messages.cliHelp_usagePrefix);
        PrintWriter pw = new PrintWriter(this.out);
        formatter.printHelp(pw, 160, this.getCommandLineSyntax(), "\n" + Messages.cliHelp_optionsHeader, this.getOptions(), 1, 3, null);
        pw.flush();
    }

    protected Object handleError(Throwable throwable) {
        if (throwable instanceof OperationCanceledException) {
            return ERROR_NO;
        }
        if (throwable instanceof ParseException) {
            this.err.println(throwable.getMessage());
            this.err.println(Messages.cliHelp_useHelpOptionForMoreInformation);
        } else {
            this.err.println(throwable.getMessage());
            PlatformLogUtil.logAsError(Activator.getDefault(), throwable);
        }
        return ERROR_UNSPECIFIED;
    }
}

