/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.workspace.ui.wizards.pages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ListIterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sphinx.emf.metamodel.IMetaModelDescriptor;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.emf.workspace.ui.internal.Activator;
import org.eclipse.sphinx.emf.workspace.ui.internal.messages.Messages;
import org.eclipse.sphinx.emf.workspace.ui.wizards.pages.InitialModelProperties;
import org.eclipse.sphinx.platform.preferences.IProjectWorkspacePreference;
import org.eclipse.sphinx.platform.util.ExtendedPlatform;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;

public class NewModelFileCreationPage<T extends IMetaModelDescriptor>
extends WizardNewFileCreationPage {
    protected IStructuredSelection selection;
    protected IProjectWorkspacePreference<T> metaModelVersionPreference = null;
    protected InitialModelProperties<T> initialModelProperties = null;
    private String requiredProjectTypeName = null;
    protected boolean noValidFileExtensionsForContentTypeIdFoundProblemLoggedOnce = false;

    public NewModelFileCreationPage(String pageId, IStructuredSelection selection, IProjectWorkspacePreference<T> metaModelVersionPreference) {
        super(pageId, selection);
        this.selection = selection;
        this.metaModelVersionPreference = metaModelVersionPreference;
        String metaModelName = this.getMetaModelName();
        this.setTitle(NLS.bind((String)Messages.page_newModelFileCreation_title, (Object)(metaModelName != null ? metaModelName : Messages.default_metamodelName_cap)));
        this.setDescription(NLS.bind((String)Messages.page_newModelFileCreation_description, (Object)(metaModelName != null ? metaModelName : Messages.default_metamodelName)));
    }

    public NewModelFileCreationPage(String pageId, IStructuredSelection selection, InitialModelProperties<T> initialModelProperties) {
        this(pageId, selection, null, initialModelProperties);
    }

    public NewModelFileCreationPage(String pageId, IStructuredSelection selection, IProjectWorkspacePreference<T> metaModelVersionPreference, InitialModelProperties<T> initialModelProperties) {
        this(pageId, selection, metaModelVersionPreference);
        this.initialModelProperties = initialModelProperties;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.createAdditionalControls((Composite)this.getControl());
        Dialog.applyDialogFont((Control)this.getControl());
    }

    protected void createAdditionalControls(Composite parent) {
    }

    public IProject getContainerProject() {
        IPath containerFullPath = this.getContainerFullPath();
        if (containerFullPath != null && containerFullPath.segmentCount() >= 1) {
            return ResourcesPlugin.getWorkspace().getRoot().getProject(containerFullPath.segment(0));
        }
        return null;
    }

    public IFile getNewFile() {
        return ResourcesPlugin.getWorkspace().getRoot().getFile(this.getContainerFullPath().append(this.getFileName()));
    }

    protected String getUniqueDefaultFileName(IContainer container) {
        String baseName = this.getDefaultBaseName();
        String extension = this.getDefaultFileExtension();
        if (baseName != null || extension != null) {
            String fileName = this.createFileName(baseName, extension, -1);
            int i = 1;
            while (container.findMember(fileName) != null) {
                fileName = this.createFileName(baseName, extension, i);
                ++i;
            }
            return fileName;
        }
        return null;
    }

    protected String createFileName(String baseName, String extension, int number) {
        StringBuilder fileName = new StringBuilder();
        if (baseName != null) {
            fileName.append(baseName);
            if (number != -1) {
                fileName.append(number);
            }
        }
        if (extension != null) {
            fileName.append(".");
            fileName.append(extension);
            if (baseName == null && number != -1) {
                fileName.append(number);
            }
        }
        return fileName.toString();
    }

    protected String getDefaultBaseName() {
        return Messages.default_modelFileBaseName;
    }

    protected String getDefaultFileExtension() {
        Collection<String> validFileExtensions = this.getValidFileExtensions();
        if (!validFileExtensions.isEmpty()) {
            return validFileExtensions.iterator().next();
        }
        return null;
    }

    protected String getContentTypeId() {
        T mmDescriptor = this.getMetaModelDescriptor();
        if (mmDescriptor != null) {
            return mmDescriptor.getDefaultContentTypeId();
        }
        return null;
    }

    protected String getRequiredProjectTypeName() {
        if (this.requiredProjectTypeName == null) {
            String metaModelName = this.getMetaModelName();
            this.requiredProjectTypeName = metaModelName != null ? metaModelName : Messages.default_metamodelName;
        }
        return this.requiredProjectTypeName;
    }

    public void setRequiredProjectTypeName(String requiredProjectTypeName) {
        this.requiredProjectTypeName = requiredProjectTypeName;
    }

    protected T getMetaModelDescriptor() {
        if (this.initialModelProperties != null) {
            return this.initialModelProperties.getMetaModelDescriptor();
        }
        if (this.metaModelVersionPreference != null) {
            return (T)((IMetaModelDescriptor)this.metaModelVersionPreference.get(this.getContainerProject()));
        }
        return null;
    }

    protected String getMetaModelName() {
        IMetaModelDescriptor mmDescriptor = null;
        if (this.initialModelProperties != null) {
            mmDescriptor = (IMetaModelDescriptor)this.initialModelProperties.getMetaModelDescriptor();
        }
        if (this.metaModelVersionPreference != null) {
            mmDescriptor = (IMetaModelDescriptor)this.metaModelVersionPreference.getFromWorkspace();
        }
        if (mmDescriptor != null) {
            if (mmDescriptor.getBaseDescriptor() != null) {
                return mmDescriptor.getBaseDescriptor().getName();
            }
            return mmDescriptor.getName();
        }
        return null;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.selection != null && !this.selection.isEmpty()) {
            Object selected = this.selection.iterator().next();
            IFile file = EcorePlatformUtil.getFile(selected);
            if (file != null) {
                selected = file.getParent();
            }
            if (selected instanceof IContainer) {
                this.setContainerFullPath(((IContainer)selected).getFullPath());
                String fileName = this.getUniqueDefaultFileName((IContainer)selected);
                if (fileName != null) {
                    this.setFileName(fileName);
                }
            }
        }
    }

    protected boolean validatePage() {
        if (!super.validatePage()) {
            return false;
        }
        IProject containerProject = this.getContainerProject();
        if (containerProject != null && !this.hasRequiredProjectNature(containerProject)) {
            this.setErrorMessage(this.getRequiredProjectNatureErrorMessage());
            return false;
        }
        if (containerProject != null && !this.hasMatchingMetaModelVersion(containerProject)) {
            this.setErrorMessage(this.getMatchingMetaModelVersionErrorMessage());
            return false;
        }
        String fileExtension = new Path(this.getFileName()).getFileExtension();
        Collection<String> validFileExtensions = this.getValidFileExtensions();
        if (!validFileExtensions.isEmpty() && !validFileExtensions.contains(fileExtension)) {
            this.setErrorMessage(this.getFileExtensionErrorMessage(validFileExtensions));
            return false;
        }
        return true;
    }

    protected boolean hasRequiredProjectNature(IProject project) {
        Assert.isNotNull((Object)project);
        Assert.isTrue((boolean)project.isAccessible());
        if (this.metaModelVersionPreference == null) {
            return true;
        }
        try {
            return project.hasNature(this.metaModelVersionPreference.getRequiredProjectNatureId());
        }
        catch (CoreException ex) {
            PlatformLogUtil.logAsError((Plugin)Activator.getDefault(), (Object)((Object)ex));
            return false;
        }
    }

    protected boolean hasMatchingMetaModelVersion(IProject project) {
        Assert.isNotNull((Object)project);
        Assert.isTrue((boolean)project.isAccessible());
        if (this.metaModelVersionPreference == null) {
            return true;
        }
        T mmDescriptor = this.getMetaModelDescriptor();
        return mmDescriptor == null || mmDescriptor.equals(this.metaModelVersionPreference.get(project));
    }

    protected Collection<String> getValidFileExtensions() {
        String contentTypeId = this.getContentTypeId();
        if (contentTypeId != null) {
            Collection validFileExtensions = ExtendedPlatform.getContentTypeFileExtensions((String)contentTypeId);
            if (validFileExtensions.isEmpty() && !this.noValidFileExtensionsForContentTypeIdFoundProblemLoggedOnce) {
                PlatformLogUtil.logAsWarning((Plugin)Activator.getPlugin(), (Object)new RuntimeException("No valid file extensions for content type identifer '" + contentTypeId + "' found."));
                this.noValidFileExtensionsForContentTypeIdFoundProblemLoggedOnce = true;
            }
            return validFileExtensions;
        }
        return Collections.emptySet();
    }

    protected String getRequiredProjectNatureErrorMessage() {
        String requiredProjectTypeName = this.getRequiredProjectTypeName();
        return NLS.bind((String)Messages.error_requiredProjectNature, (Object)(requiredProjectTypeName != null ? requiredProjectTypeName : Messages.default_requiredProjectType));
    }

    protected String getMatchingMetaModelVersionErrorMessage() {
        T mmDescriptor = this.getMetaModelDescriptor();
        return NLS.bind((String)Messages.error_matchingMetaModelVersion, (Object)(mmDescriptor != null ? mmDescriptor.getName() : ""));
    }

    protected String getFileExtensionErrorMessage(Collection<String> validFileExtensions) {
        return NLS.bind((String)Messages.error_fileExtension, (Object)this.convertFileExtensionsToString(validFileExtensions));
    }

    protected String convertFileExtensionsToString(Collection<String> fileExtensions) {
        Assert.isNotNull(fileExtensions);
        StringBuilder buf = new StringBuilder();
        ListIterator<String> iter = new ArrayList<String>(fileExtensions).listIterator();
        while (iter.hasNext()) {
            if (iter.hasPrevious()) {
                buf.append(", ");
            }
            buf.append("*.");
            buf.append(iter.next());
        }
        return buf.toString();
    }
}

