/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.scoping;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.sphinx.emf.Activator;
import org.eclipse.sphinx.emf.resource.ScopingResourceSet;
import org.eclipse.sphinx.emf.scoping.IResourceScope;
import org.eclipse.sphinx.emf.util.EcoreResourceUtil;
import org.eclipse.sphinx.platform.util.ExtendedPlatform;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;

public abstract class AbstractResourceScope
implements IResourceScope {
    @Override
    public boolean exists() {
        return this.getRoot() != null && this.getRoot().isAccessible();
    }

    @Override
    public Collection<IFile> getPersistedFiles(boolean includeReferencedScopes) {
        HashSet<IFile> files = new HashSet<IFile>();
        files.addAll(this.getFilesUnderRoot(this.getRoot()));
        if (includeReferencedScopes) {
            Collection<IResource> dependingRoots = this.getReferencedRoots();
            for (IResource dependingRoot : dependingRoots) {
                files.addAll(this.getFilesUnderRoot(dependingRoot));
            }
        }
        return Collections.unmodifiableCollection(files);
    }

    protected Collection<IFile> getFilesUnderRoot(IResource root) {
        HashSet<IFile> files = new HashSet<IFile>();
        if (root instanceof IProject) {
            IProject project = (IProject)root;
            files.addAll(ExtendedPlatform.getAllFiles((IProject)project, (boolean)false));
        } else if (root instanceof IFile) {
            files.add((IFile)root);
        } else if (root instanceof IFolder) {
            IFolder folder = (IFolder)root;
            files.addAll(ExtendedPlatform.getAllFiles((IFolder)folder));
        }
        return files;
    }

    @Override
    public Collection<Resource> getLoadedResources(final TransactionalEditingDomain editingDomain, final boolean includeReferencedScopes) {
        try {
            return (Collection)TransactionUtil.runExclusive((TransactionalEditingDomain)editingDomain, (RunnableWithResult)new RunnableWithResult.Impl<List<Resource>>(){

                public void run() {
                    ResourceSet resourceSet = editingDomain.getResourceSet();
                    if (resourceSet instanceof ScopingResourceSet) {
                        this.setResult(((ScopingResourceSet)resourceSet).getResourcesInScope(AbstractResourceScope.this, includeReferencedScopes));
                    } else {
                        this.setResult(resourceSet.getResources());
                    }
                }
            });
        }
        catch (InterruptedException ex) {
            PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)ex);
            return Collections.emptyList();
        }
    }

    @Override
    public boolean isShared(IFile file) {
        return false;
    }

    @Override
    public boolean isShared(Resource resource) {
        if (resource != null) {
            URIConverter converter;
            URI normalizedUri;
            boolean shared = this.isShared(resource.getURI());
            if (shared) {
                return true;
            }
            URI uri = resource.getURI();
            if (!uri.isPlatformResource() && !uri.equals(normalizedUri = (converter = EcoreResourceUtil.getURIConverter(resource.getResourceSet())).normalize(uri))) {
                return this.isShared(normalizedUri);
            }
        }
        return false;
    }

    @Override
    public boolean isShared(URI uri) {
        if (uri != null) {
            return uri.isPlatformPlugin();
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object instanceof IResourceScope) {
            return ((IResourceScope)object).getRoot().equals((Object)this.getRoot()) && object.getClass().equals(this.getClass());
        }
        return false;
    }

    public int hashCode() {
        return this.getRoot().hashCode() + this.getClass().hashCode();
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "@" + this.getRoot().getName();
    }
}

