/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.ui.actions.providers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.SubContributionItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sphinx.emf.edit.TransientItemProvider;
import org.eclipse.sphinx.emf.messages.EMFMessages;
import org.eclipse.sphinx.emf.ui.internal.Activator;
import org.eclipse.sphinx.emf.util.WorkspaceEditingDomainUtil;
import org.eclipse.sphinx.platform.ui.util.SelectionUtil;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;
import org.eclipse.ui.views.properties.PropertySheet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicActionProvider
extends CommonActionProvider {
    protected IWorkbenchPart workbenchPart;
    protected Viewer viewer;
    protected String viewerId;
    protected ISelectionProvider selectionProvider;

    public final void init(ICommonActionExtensionSite site) {
        super.init(site);
        ICommonViewerSite viewSite = site.getViewSite();
        if (viewSite instanceof ICommonViewerWorkbenchSite) {
            ICommonViewerWorkbenchSite workbenchSite = (ICommonViewerWorkbenchSite)viewSite;
            this.workbenchPart = workbenchSite.getPart();
            if (this.workbenchPart instanceof CommonNavigator) {
                CommonNavigator navigator = (CommonNavigator)this.workbenchPart;
                this.viewer = navigator.getCommonViewer();
                this.selectionProvider = navigator.getCommonViewer();
            } else {
                this.selectionProvider = workbenchSite.getSelectionProvider();
            }
            this.viewerId = workbenchSite.getId();
            this.doInit();
        }
    }

    public void fillContextMenu(IMenuManager contextMenuManager) {
        IMenuManager subMenuManager = this.addSubMenu(contextMenuManager);
        this.fillSubMenu(subMenuManager != null ? subMenuManager : contextMenuManager);
    }

    protected void doInit() {
    }

    protected boolean isActivePropertySheet() {
        IWorkbenchPart activePart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
        return activePart instanceof PropertySheet;
    }

    protected IMenuManager addSubMenu(IMenuManager contextMenuManager) {
        return null;
    }

    protected void fillSubMenu(IMenuManager subMenuManager) {
    }

    protected TransactionalEditingDomain getEditingDomainFromSelection(ISelection selection) {
        IStructuredSelection structuredSelection;
        if (selection instanceof IStructuredSelection && !(structuredSelection = (IStructuredSelection)selection).isEmpty()) {
            TransactionalEditingDomain previousEditingDomain = null;
            TransactionalEditingDomain currentEditingDomain = null;
            for (Object seletedObject : structuredSelection.toList()) {
                if (seletedObject instanceof EObject && ((EObject)seletedObject).eIsProxy()) {
                    PlatformLogUtil.logAsWarning((Plugin)Activator.getPlugin(), (Object)new RuntimeException(NLS.bind((String)EMFMessages.warning_selectionContainsUnresolvedModelElement, seletedObject)));
                }
                if ((currentEditingDomain = WorkspaceEditingDomainUtil.getEditingDomain(seletedObject)) == null) {
                    return null;
                }
                if (previousEditingDomain == null) {
                    previousEditingDomain = currentEditingDomain;
                    continue;
                }
                if (previousEditingDomain.equals(currentEditingDomain)) continue;
                return null;
            }
            return currentEditingDomain;
        }
        return null;
    }

    protected void populateManager(IContributionManager manager, Collection<? extends IAction> actions, String contributionId) {
        if (actions != null) {
            for (IAction iAction : actions) {
                if (contributionId != null) {
                    manager.insertBefore(contributionId, iAction);
                    continue;
                }
                manager.add(iAction);
            }
        }
    }

    protected void populateManager(IContributionManager manager, Map<String, Collection<IAction>> submenuActions, String contributionId) {
        if (submenuActions != null) {
            for (Map.Entry<String, Collection<IAction>> entry : submenuActions.entrySet()) {
                MenuManager submenuManager = new MenuManager(entry.getKey());
                if (contributionId != null) {
                    manager.insertBefore(contributionId, (IContributionItem)submenuManager);
                } else {
                    manager.add((IContributionItem)submenuManager);
                }
                this.populateManager((IContributionManager)submenuManager, entry.getValue(), null);
            }
        }
    }

    protected void depopulateManager(IContributionManager manager, Collection<? extends IAction> actions) {
        if (actions != null) {
            IContributionItem[] items;
            IContributionItem[] iContributionItemArray = items = manager.getItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                IAction action;
                IContributionItem contributionItem = iContributionItemArray[n2];
                while (contributionItem instanceof SubContributionItem) {
                    contributionItem = ((SubContributionItem)contributionItem).getInnerItem();
                }
                if (contributionItem instanceof ActionContributionItem && actions.contains(action = ((ActionContributionItem)contributionItem).getAction())) {
                    manager.remove(contributionItem);
                }
                ++n2;
            }
        }
    }

    protected void depopulateManager(IContributionManager manager, Map<String, Collection<IAction>> submenuActions) {
        if (submenuActions != null) {
            IContributionItem[] items;
            IContributionItem[] iContributionItemArray = items = manager.getItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                MenuManager submenuManager;
                IContributionItem contributionItem = iContributionItemArray[n2];
                if (contributionItem instanceof MenuManager && submenuActions.containsKey((submenuManager = (MenuManager)contributionItem).getMenuText())) {
                    this.depopulateManager((IContributionManager)submenuManager, submenuActions.get(contributionItem));
                    manager.remove(contributionItem);
                }
                ++n2;
            }
        }
    }

    protected Map<String, Collection<IAction>> extractSubmenuActions(Collection<IAction> createActions, ISelection selection) {
        LinkedHashMap<String, Collection<IAction>> createSubmenuActions = new LinkedHashMap<String, Collection<IAction>>();
        if (createActions != null) {
            Iterator<IAction> actions = createActions.iterator();
            while (actions.hasNext()) {
                StringTokenizer st;
                IAction action = actions.next();
                if (action.getText() == null || (st = new StringTokenizer(action.getText(), "|")).countTokens() != 2) continue;
                String text = st.nextToken().trim();
                IStructuredSelection structuredSelection = SelectionUtil.getStructuredSelection((ISelection)selection);
                if (this.isTransient(structuredSelection.getFirstElement())) {
                    action.setText(st.nextToken().trim());
                    continue;
                }
                ArrayList<IAction> submenuActions = (ArrayList<IAction>)createSubmenuActions.get(text);
                if (submenuActions == null) {
                    submenuActions = new ArrayList<IAction>();
                    createSubmenuActions.put(text, submenuActions);
                }
                action.setText(st.nextToken().trim());
                submenuActions.add(action);
                actions.remove();
            }
        }
        return createSubmenuActions;
    }

    protected boolean isTransient(Object object) {
        return object instanceof TransientItemProvider;
    }
}

