/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.testutils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.Platform;
import org.eclipse.sphinx.testutils.internal.Activator;
import org.junit.Assert;
import org.junit.internal.runners.ErrorReportingRunner;
import org.junit.internal.runners.JUnit38ClassRunner;
import org.junit.runner.Request;
import org.junit.runner.Runner;
import org.junit.runners.Parameterized;
import org.junit.runners.Suite;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoTestSuite {
    public static Test suite() {
        String pluginPatternProperty = System.getProperty("autotestsuite.plugin.pattern");
        if (pluginPatternProperty != null) {
            Bundle[] bs;
            TestSuite testSuite = new TestSuite(pluginPatternProperty);
            Bundle[] bundleArray = bs = Activator.getPlugin().getBundle().getBundleContext().getBundles();
            int n = bs.length;
            int n2 = 0;
            while (n2 < n) {
                Bundle b = bundleArray[n2];
                if (b.getSymbolicName().matches(pluginPatternProperty)) {
                    TestSuite ts = new TestSuite(b.getSymbolicName());
                    AutoTestSuite.setup(ts, b);
                    testSuite.addTest((Test)ts);
                }
                ++n2;
            }
            return testSuite;
        }
        String pluginProperty = System.getProperty("autotestsuite.plugin");
        if (pluginProperty != null) {
            return AutoTestSuite.setup(pluginProperty);
        }
        String pluginsProperty = System.getProperty("autotestsuite.plugins");
        if (pluginsProperty != null) {
            if (pluginsProperty.startsWith("@")) {
                TestSuite testSuite = new TestSuite("Running tests from " + pluginsProperty);
                Iterable<String> lines = AutoTestSuite.readLines(new File(pluginsProperty.substring(1)));
                for (String line : lines) {
                    testSuite.addTest((Test)AutoTestSuite.setup(line));
                }
                return testSuite;
            }
            String[] plugins = pluginsProperty.split(",");
            TestSuite testSuite = new TestSuite("Running tests from " + plugins.length + " plugins");
            String[] stringArray = plugins;
            int n = plugins.length;
            int n3 = 0;
            while (n3 < n) {
                String pluginName = stringArray[n3];
                testSuite.addTest((Test)AutoTestSuite.setup(pluginName));
                ++n3;
            }
            return testSuite;
        }
        throw new AssertionError((Object)"Exactly one of the system properties 'autotestsuite.plugin.pattern', 'autotestsuite.plugin' or 'autotestsuite.plugins' need to be set");
    }

    private static void setup(TestSuite ts, Bundle plugin) {
        Enumeration entries = plugin.findEntries("/", "*.class", true);
        int i = 0;
        if (entries != null) {
            for (URL url : Collections.list(entries)) {
                String path = url.getPath();
                path = path.replaceAll("^/(bin/)?(.*)\\.class$", "$2");
                String classname = path = path.replaceAll("/", ".");
                try {
                    JUnit4TestAdapter test;
                    Class<?> c = AutoTestSuite.loadClass(plugin, classname);
                    if (AutoTestSuite.isAbstract(c)) continue;
                    if (AutoTestSuite.isJUnit4Test(c)) {
                        test = new JUnit4TestAdapter(c);
                    } else {
                        if (!AutoTestSuite.isTestCase(c)) continue;
                        test = new TestSuite(c);
                    }
                    ts.addTest((Test)test);
                    ++i;
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        AutoTestSuite.log("Found " + i + " test classes in '" + plugin.getSymbolicName() + "'.");
    }

    private static TestSuite setup(String pluginName) {
        TestSuite ts = new TestSuite(pluginName);
        Bundle bundle = Platform.getBundle((String)pluginName);
        Assert.assertNotNull((String)("Cannot locate bundle " + pluginName), (Object)bundle);
        AutoTestSuite.setup(ts, bundle);
        return ts;
    }

    private static Class<?> loadClass(Bundle b, String classname) throws ClassNotFoundException {
        if (Platform.isFragment((Bundle)b)) {
            return Platform.getHosts((Bundle)b)[0].loadClass(classname);
        }
        return b.loadClass(classname);
    }

    private static boolean isJUnit4Test(Class<?> c) {
        Runner runner = Request.classWithoutSuiteMethod(c).getRunner();
        if (runner == null) {
            return false;
        }
        if (runner instanceof ErrorReportingRunner) {
            return false;
        }
        if (runner instanceof JUnit38ClassRunner) {
            return false;
        }
        if (runner instanceof Parameterized) {
            return true;
        }
        return !(runner instanceof Suite);
    }

    private static boolean isTestCase(Class<?> c) {
        return TestCase.class.isAssignableFrom(c);
    }

    private static boolean isAbstract(Class<?> c) {
        int modifiers = c.getModifiers();
        return (modifiers & 0x400) > 0;
    }

    private static Iterable<String> readLines(File file) {
        ArrayList<String> lines = new ArrayList<String>();
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            try {
                String line = reader.readLine();
                while (line != null) {
                    if ((line = line.trim()).length() > 0 && line.charAt(0) != '#') {
                        lines.add(line);
                    }
                    line = reader.readLine();
                }
            }
            finally {
                reader.close();
            }
        }
        catch (IOException ex) {
            throw new AssertionError((Object)ex);
        }
        return lines;
    }

    private static void log(String message) {
        System.out.println("AutoTestSuite: " + message);
    }
}

