/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.workspace.referentialintegrity;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.sphinx.emf.resource.ExtendedResource;
import org.eclipse.sphinx.emf.resource.ExtendedResourceAdapterFactory;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.emf.workspace.Activator;
import org.eclipse.sphinx.emf.workspace.referentialintegrity.IURIChangeDetectorDelegate;
import org.eclipse.sphinx.emf.workspace.referentialintegrity.URIChangeNotification;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMIURIChangeDetectorDelegate
implements IURIChangeDetectorDelegate {
    @Override
    public List<URIChangeNotification> detectChangedURIs(Notification notification) {
        notification.getNotifier();
        ArrayList<URIChangeNotification> notifications = new ArrayList<URIChangeNotification>();
        if (notification.getNotifier() instanceof EObject) {
            EObject eObject = (EObject)notification.getNotifier();
            eObject.eResource().getURIFragment(eObject);
            URIChangeNotification uriNotification = new URIChangeNotification(eObject, XMIURIChangeDetectorDelegate.getURI(eObject));
            notifications.add(uriNotification);
        }
        return notifications;
    }

    @Override
    public List<URIChangeNotification> detectChangedURIs(IFile oldFile, IFile newFile) {
        EObject modelRoot;
        URI newUri;
        ArrayList<URIChangeNotification> notifications = new ArrayList<URIChangeNotification>();
        URI oldUri = EcorePlatformUtil.createURI((IPath)oldFile.getFullPath());
        if (!oldUri.equals((Object)(newUri = EcorePlatformUtil.createURI((IPath)newFile.getFullPath()))) && (modelRoot = EcorePlatformUtil.getModelRoot((IFile)oldFile)) != null) {
            TreeIterator eAllContents = modelRoot.eAllContents();
            notifications.add(new URIChangeNotification(modelRoot, XMIURIChangeDetectorDelegate.getURI(modelRoot)));
            while (eAllContents.hasNext()) {
                EObject containedEObject = (EObject)eAllContents.next();
                notifications.add(new URIChangeNotification(containedEObject, XMIURIChangeDetectorDelegate.getURI(containedEObject)));
            }
        }
        return notifications;
    }

    protected static URI getURI(final EObject eObject) {
        TransactionalEditingDomain editingDomain;
        if (eObject != null && (editingDomain = TransactionUtil.getEditingDomain((EObject)eObject)) != null) {
            try {
                return (URI)TransactionUtil.runExclusive((TransactionalEditingDomain)editingDomain, (RunnableWithResult)new RunnableWithResult.Impl<URI>(){

                    public void run() {
                        Resource resource = eObject.eResource();
                        ExtendedResource extendedResource = ExtendedResourceAdapterFactory.INSTANCE.adapt((Notifier)resource);
                        if (extendedResource != null) {
                            this.setResult(extendedResource.getURI(eObject));
                        } else {
                            this.setResult(EcoreUtil.getURI((EObject)eObject));
                        }
                    }
                });
            }
            catch (InterruptedException ex) {
                PlatformLogUtil.logAsWarning((Plugin)Activator.getDefault(), (Object)ex);
            }
        }
        return null;
    }
}

