/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.workspace.internal.loading;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.sphinx.emf.metamodel.IMetaModelDescriptor;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.emf.workspace.internal.loading.LoadJob;
import org.eclipse.sphinx.emf.workspace.internal.messages.Messages;
import org.eclipse.sphinx.platform.util.ExtendedPlatform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ModelLoadJob
extends LoadJob {
    protected Set<IProject> fProjects;
    protected boolean fIncludeReferencedProjects;

    public ModelLoadJob(Collection<IProject> projects, boolean includeReferencedProjects, IMetaModelDescriptor mmDescriptor) {
        super(mmDescriptor != null ? Messages.job_loadingModel : Messages.job_loadingModels, mmDescriptor);
        this.fIncludeReferencedProjects = includeReferencedProjects;
        this.fProjects = new HashSet<IProject>(projects);
        if (includeReferencedProjects) {
            for (IProject p : projects) {
                this.fProjects.addAll(this.getProjectGroup(p, false));
            }
        }
    }

    public boolean covers(Collection<IProject> projects, boolean includeReferencedProjects, IMetaModelDescriptor mmDescriptor) {
        int mmDescriptorsComparison;
        int projectsComparison;
        HashSet<IProject> projectGroup = new HashSet<IProject>(projects);
        if (includeReferencedProjects) {
            for (IProject p : projects) {
                projectGroup.addAll(this.getProjectGroup(p, false));
            }
        }
        return !((projectsComparison = ModelLoadJob.compare(this.fProjects, projectGroup)) != EQUAL && projectsComparison != GREATER_THAN || (mmDescriptorsComparison = ModelLoadJob.compare(this.fMMDescriptor, mmDescriptor)) != EQUAL && mmDescriptorsComparison != GREATER_THAN);
    }

    private Collection<IProject> getProjectGroup(Object contextObject, boolean includeReferencingProjects) {
        if (contextObject instanceof IResource) {
            IResource contextResource = (IResource)contextObject;
            return ExtendedPlatform.getProjectGroup((IProject)contextResource.getProject(), (boolean)includeReferencingProjects);
        }
        IFile contextFile = EcorePlatformUtil.getFile((Object)contextObject);
        if (contextFile != null) {
            return ExtendedPlatform.getProjectGroup((IProject)contextFile.getProject(), (boolean)includeReferencingProjects);
        }
        return Collections.emptySet();
    }
}

