/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.check.ui.markers.fields;

import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.sphinx.emf.check.ui.internal.Activator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.views.markers.MarkerField;
import org.eclipse.ui.views.markers.MarkerItem;

public class DescriptionMarkerField
extends MarkerField {
    public String getValue(MarkerItem item) {
        String message = item.getAttributeValue("message", "");
        String prefix = this.getCheckPrefix(item);
        if (prefix == null) {
            return message;
        }
        return prefix.concat(message);
    }

    private String getCheckPrefix(MarkerItem item) {
        if (item.getMarker() == null) {
            return null;
        }
        IMarker marker = item.getMarker();
        if (marker != null && IDE.getMarkerHelpRegistry().hasResolutions(marker)) {
            return "[@Check] ";
        }
        return null;
    }

    public String getColumnHeaderText() {
        return "Description";
    }

    public int getDefaultColumnWidth(Control control) {
        return 250;
    }

    private Image getImage(MarkerItem item) {
        if (item.getMarker() == null) {
            return Activator.getDefault().getImageRegistry().get("icons/group.png");
        }
        int severity = item.getAttributeValue("severity", -1);
        if (severity == 2) {
            return Activator.getDefault().getImageRegistry().get("icons/error.png");
        }
        if (severity == 1) {
            return Activator.getDefault().getImageRegistry().get("icons/warning.png");
        }
        if (severity == 0) {
            return Activator.getDefault().getImageRegistry().get("icons/info.png");
        }
        return null;
    }

    public void update(ViewerCell cell) {
        super.update(cell);
        MarkerItem item = (MarkerItem)cell.getElement();
        cell.setImage(this.annotateImage(item, this.getImage(item)));
        cell.setBackground(PlatformUI.getWorkbench().getDisplay().getSystemColor(29));
        cell.setForeground(PlatformUI.getWorkbench().getDisplay().getSystemColor(28));
    }
}

