/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.platform.ui.groups;

import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.sphinx.platform.ui.groups.AbstractGroup;
import org.eclipse.sphinx.platform.ui.groups.messages.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class NameValueTableGroup
extends AbstractGroup {
    protected static final String DEFAULT_NAME = Messages.cell_name_default;
    protected TableViewer nameValueViewer;
    protected Button addButton;
    protected Button removeButton;

    public NameValueTableGroup(String groupName) {
        super(groupName);
    }

    public NameValueTableGroup(String groupName, IDialogSettings dialogSettings) {
        super(groupName, dialogSettings);
    }

    @Override
    protected void doCreateContent(Composite parent, int numColumns) {
        parent.setLayout((Layout)new GridLayout(2, false));
        this.createTableArea(parent);
        this.createButtonArea(parent);
        this.handleTableSelectionChanged((ISelection)StructuredSelection.EMPTY);
    }

    protected void createTableArea(Composite parent) {
        Composite tableComposite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)tableComposite);
        tableComposite.setFont(parent.getFont());
        this.nameValueViewer = new TableViewer(tableComposite, this.getTableStyle());
        Table nameValueTable = this.nameValueViewer.getTable();
        GridDataFactory.fillDefaults().applyTo((Control)nameValueTable);
        nameValueTable.setFont(parent.getFont());
        nameValueTable.setHeaderVisible(true);
        nameValueTable.setLinesVisible(true);
        this.nameValueViewer.setContentProvider((IContentProvider)new NameValueViewerContentProvider());
        this.nameValueViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                NameValueTableGroup.this.handleTableSelectionChanged(event.getSelection());
            }
        });
        TableViewerColumn nameColumn = new TableViewerColumn(this.nameValueViewer, 0);
        nameColumn.getColumn().setText(Messages.column_name_label);
        nameColumn.setLabelProvider((CellLabelProvider)new NameColumnLabelProvider());
        nameColumn.setEditingSupport((EditingSupport)new NameEditingSupport(this.nameValueViewer));
        TableViewerColumn valueColumn = new TableViewerColumn(this.nameValueViewer, 0);
        valueColumn.getColumn().setText(Messages.column_value_label);
        valueColumn.setLabelProvider((CellLabelProvider)new ValueColumnLabelProvider());
        valueColumn.setEditingSupport((EditingSupport)new ValueEditingSupport(this.nameValueViewer));
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        PixelConverter pixelConverter = new PixelConverter(parent.getFont());
        tableColumnLayout.setColumnData((Widget)nameColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(1, pixelConverter.convertWidthInCharsToPixels(20)));
        tableColumnLayout.setColumnData((Widget)valueColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(2, pixelConverter.convertWidthInCharsToPixels(20)));
        tableComposite.setLayout((Layout)tableColumnLayout);
    }

    protected int getTableStyle() {
        return 68354;
    }

    protected void createButtonArea(Composite parent) {
        Composite buttonComposite = new Composite(parent, 0);
        GridDataFactory.swtDefaults().align(3, 1).applyTo((Control)buttonComposite);
        buttonComposite.setFont(parent.getFont());
        buttonComposite.setLayout((Layout)new GridLayout(1, false));
        this.addButton = new Button(buttonComposite, 8);
        GridDataFactory.swtDefaults().align(4, 1).hint(this.computeButtonHint(this.addButton)).applyTo((Control)this.addButton);
        this.addButton.setFont(parent.getFont());
        this.addButton.setText(Messages.button_add_label);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                NameValueTableGroup.this.handleAddButtonSelected();
            }
        });
        this.removeButton = new Button(buttonComposite, 8);
        GridDataFactory.swtDefaults().align(4, 1).hint(this.computeButtonHint(this.removeButton)).applyTo((Control)this.removeButton);
        this.removeButton.setFont(parent.getFont());
        this.removeButton.setText(Messages.button_remove_label);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                NameValueTableGroup.this.handleRemoveButtonSelected();
            }
        });
    }

    protected Point computeButtonHint(Button button) {
        PixelConverter converter = new PixelConverter((Control)button);
        int dialogWidthHint = converter.convertHorizontalDLUsToPixels(61);
        Point preferredSize = button.computeSize(-1, -1, true);
        return new Point(Math.max(dialogWidthHint, preferredSize.x), preferredSize.y);
    }

    protected void handleTableSelectionChanged(ISelection selection) {
        int size = ((IStructuredSelection)selection).size();
        this.removeButton.setEnabled(size > 0);
        Map entries = (Map)this.nameValueViewer.getInput();
        this.addButton.setEnabled(entries != null && !entries.containsKey(DEFAULT_NAME));
    }

    protected void handleAddButtonSelected() {
        this.addEntry(DEFAULT_NAME, Messages.cell_value_default);
        Map.Entry<String, String> entry = this.findEntry(DEFAULT_NAME);
        this.nameValueViewer.setSelection((ISelection)new StructuredSelection(entry));
    }

    protected void handleRemoveButtonSelected() {
        int newSelectionIdx;
        Assert.isNotNull((Object)this.nameValueViewer);
        int oldSelectionIdx = this.nameValueViewer.getTable().getSelectionIndex();
        Map entries = (Map)this.nameValueViewer.getInput();
        for (Object selected : ((IStructuredSelection)this.nameValueViewer.getSelection()).toList()) {
            Map.Entry entry = (Map.Entry)selected;
            entries.remove(entry.getKey());
        }
        this.nameValueViewer.refresh();
        int n = newSelectionIdx = oldSelectionIdx < entries.size() ? oldSelectionIdx : entries.size() - 1;
        if (newSelectionIdx != -1) {
            TableItem newSelected = this.nameValueViewer.getTable().getItem(newSelectionIdx);
            this.nameValueViewer.setSelection((ISelection)new StructuredSelection(newSelected.getData()));
        }
    }

    public void setInput(Map<String, String> entries) {
        Assert.isNotNull((Object)this.nameValueViewer);
        this.nameValueViewer.setInput(entries);
        this.handleTableSelectionChanged((ISelection)StructuredSelection.EMPTY);
    }

    public Map<String, String> getInput() {
        Assert.isNotNull((Object)this.nameValueViewer);
        return (Map)this.nameValueViewer.getInput();
    }

    public void addEntry(String name, String value) {
        Assert.isNotNull((Object)this.nameValueViewer);
        Map entries = (Map)this.nameValueViewer.getInput();
        entries.put(name, value);
        Map.Entry<String, String> entry = this.findEntry(name);
        this.nameValueViewer.add(entry);
    }

    protected Map.Entry<String, String> findEntry(String name) {
        Assert.isNotNull((Object)this.nameValueViewer);
        Map entries = (Map)this.nameValueViewer.getInput();
        for (Map.Entry<String, String> entry : entries.entrySet()) {
            if (!name.equals(entry.getKey())) continue;
            return entry;
        }
        return null;
    }

    protected abstract class AbstractTextEditingSupport
    extends EditingSupport {
        protected TableViewer viewer;
        protected CellEditor editor;

        public AbstractTextEditingSupport(TableViewer viewer) {
            super((ColumnViewer)viewer);
            this.viewer = viewer;
            this.editor = new TextCellEditor((Composite)viewer.getTable());
        }

        protected CellEditor getCellEditor(Object element) {
            return this.editor;
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected final void setValue(Object element, Object value) {
            this.doSetValue(element, value);
            NameValueTableGroup.this.notifyGroupChanged(null);
        }

        protected abstract void doSetValue(Object var1, Object var2);
    }

    protected static class NameColumnLabelProvider
    extends ColumnLabelProvider {
        protected NameColumnLabelProvider() {
        }

        public String getText(Object element) {
            Map.Entry entry = (Map.Entry)element;
            return (String)entry.getKey();
        }
    }

    protected class NameEditingSupport
    extends AbstractTextEditingSupport {
        public NameEditingSupport(TableViewer viewer) {
            super(viewer);
        }

        protected Object getValue(Object element) {
            Map.Entry entry = (Map.Entry)element;
            return entry.getKey();
        }

        @Override
        protected void doSetValue(Object element, Object value) {
            Map.Entry oldEntry = (Map.Entry)element;
            final String newName = String.valueOf(value);
            Map entries = (Map)this.viewer.getInput();
            entries.remove(oldEntry.getKey());
            entries.put(newName, (String)oldEntry.getValue());
            this.viewer.refresh();
            this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (NameEditingSupport.this.viewer != null && NameEditingSupport.this.viewer.getControl() != null && !NameEditingSupport.this.viewer.getControl().isDisposed()) {
                        Map.Entry<String, String> newEntry = NameValueTableGroup.this.findEntry(newName);
                        ((NameEditingSupport)NameEditingSupport.this).NameValueTableGroup.this.nameValueViewer.editElement(newEntry, 1);
                    }
                }
            });
        }
    }

    protected static class NameValueViewerContentProvider
    implements IStructuredContentProvider {
        protected NameValueViewerContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Map) {
                Map entries = (Map)inputElement;
                return entries.entrySet().toArray(new Object[entries.size()]);
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput == null) {
                return;
            }
            if (viewer instanceof TableViewer) {
                TableViewer tableViewer = (TableViewer)viewer;
                if (tableViewer.getTable().isDisposed()) {
                    return;
                }
                tableViewer.setComparator(new ViewerComparator(){

                    public int compare(Viewer viewer, Object e1, Object e2) {
                        if (e1 == null) {
                            return -1;
                        }
                        if (e2 == null) {
                            return 1;
                        }
                        Map.Entry entry1 = (Map.Entry)e1;
                        Map.Entry entry2 = (Map.Entry)e2;
                        if (entry1.getKey() == null) {
                            return -1;
                        }
                        if (entry2.getKey() == null) {
                            return 1;
                        }
                        return ((String)entry1.getKey()).compareToIgnoreCase((String)entry2.getKey());
                    }
                });
            }
        }
    }

    protected static class ValueColumnLabelProvider
    extends ColumnLabelProvider {
        protected ValueColumnLabelProvider() {
        }

        public String getText(Object element) {
            Map.Entry entry = (Map.Entry)element;
            return (String)entry.getValue();
        }
    }

    protected class ValueEditingSupport
    extends AbstractTextEditingSupport {
        public ValueEditingSupport(TableViewer viewer) {
            super(viewer);
        }

        protected Object getValue(Object element) {
            Map.Entry entry = (Map.Entry)element;
            return entry.getValue();
        }

        @Override
        protected void doSetValue(Object element, Object value) {
            String newName = String.valueOf(value);
            Map.Entry entry = (Map.Entry)element;
            entry.setValue(newName);
            this.viewer.update(element, null);
        }
    }
}

