/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.workspace.ui.viewers.state.providers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.IWrapperItemProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.sphinx.emf.edit.TransientItemProvider;
import org.eclipse.sphinx.emf.model.IModelDescriptor;
import org.eclipse.sphinx.emf.model.ModelDescriptorRegistry;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.emf.util.EcoreResourceUtil;
import org.eclipse.sphinx.emf.workspace.loading.ModelLoadManager;
import org.eclipse.sphinx.emf.workspace.ui.viewers.state.providers.AbstractTreeElementStateProvider;
import org.eclipse.sphinx.emf.workspace.ui.viewers.state.providers.TreeElementStateProviderFactory;
import org.eclipse.ui.IMemento;

public class TransientElementStateProvider
extends AbstractTreeElementStateProvider {
    protected static final String TRANSIENT_CHILDREN_SEPARATOR = "/";
    private URI parentURI = null;
    private EObject parentEObject = null;
    private List<Object> transientChildren;
    private boolean stale = false;

    public TransientElementStateProvider(TreeViewer viewer, IMemento memento) {
        super(viewer);
        Assert.isNotNull((Object)memento);
        String parentURIAsString = memento.getString("parentURI");
        if (parentURIAsString != null) {
            this.parentURI = URI.createURI((String)parentURIAsString, (boolean)true);
        }
        String transientChildrenAsString = memento.getString("transientChildren");
        this.transientChildren = this.readTransientChildrenFromString(transientChildrenAsString);
    }

    public TransientElementStateProvider(TreeViewer viewer, URI parentURI, List<Object> transientChildren) {
        super(viewer);
        Assert.isNotNull(transientChildren);
        this.parentURI = parentURI;
        this.transientChildren = this.deresolveTransientChildren(transientChildren);
    }

    protected EObject getParentEObject() {
        if (this.parentEObject == null) {
            this.parentEObject = EcorePlatformUtil.getEObject((URI)this.parentURI);
            if (this.parentEObject == null && this.isUnderlyingModelLoaded()) {
                this.stale = true;
            }
        }
        return this.parentEObject;
    }

    protected List<Object> readTransientChildrenFromString(String transientChildrenAsString) {
        if (transientChildrenAsString != null) {
            return new ArrayList<Object>(Arrays.asList(transientChildrenAsString.split(TRANSIENT_CHILDREN_SEPARATOR)));
        }
        return Collections.emptyList();
    }

    protected String writeTransientChildrenToString(List<Object> transientChildren) {
        Assert.isNotNull(transientChildren);
        List<Object> deresolvedTransientChildren = this.deresolveTransientChildren(transientChildren);
        StringBuilder transientChildrenAsString = new StringBuilder();
        Iterator<Object> iter = deresolvedTransientChildren.iterator();
        while (iter.hasNext()) {
            Object transientChild = iter.next();
            transientChildrenAsString.append(transientChild);
            if (!iter.hasNext()) continue;
            transientChildrenAsString.append(TRANSIENT_CHILDREN_SEPARATOR);
        }
        return transientChildrenAsString.toString();
    }

    protected List<Object> resolveTransientChildren(List<Object> transientChildren) {
        Assert.isNotNull(transientChildren);
        if (transientChildren.isEmpty() || !(transientChildren.get(transientChildren.size() - 1) instanceof String)) {
            return transientChildren;
        }
        if (this.stale) {
            return transientChildren;
        }
        Object parent = this.getParentEObject();
        if (parent == null) {
            return transientChildren;
        }
        ArrayList<Object> resolvedTransientChildren = new ArrayList<Object>();
        for (Object transientChild : transientChildren) {
            if (transientChild instanceof String) {
                Object resolvedTransientChild = this.resolveTransientChild(parent, (String)transientChild);
                resolvedTransientChildren.add(resolvedTransientChild);
            } else {
                resolvedTransientChildren.add(transientChild);
            }
            parent = transientChild;
        }
        return resolvedTransientChildren;
    }

    protected Object resolveTransientChild(Object parent, String transientChildAsString) {
        IContentProvider contentProvider = this.viewer.getContentProvider();
        if (contentProvider instanceof ITreeContentProvider && this.isTreeContentProviderAvailable(parent)) {
            Object[] objectArray = ((ITreeContentProvider)contentProvider).getChildren(parent);
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                EStructuralFeature feature;
                IWrapperItemProvider wrapperItemProvider;
                Object value;
                Object child = objectArray[n2];
                if (child instanceof TransientItemProvider && child.getClass().getName().equals(transientChildAsString)) {
                    return child;
                }
                if (child instanceof IWrapperItemProvider && ((value = (wrapperItemProvider = (IWrapperItemProvider)child).getValue()) instanceof EObject ? (feature = wrapperItemProvider.getFeature()) != null && feature.getName().equals(transientChildAsString) : value instanceof TransientItemProvider && value.getClass().getName().equals(transientChildAsString))) {
                    return child;
                }
                ++n2;
            }
            this.stale = true;
        }
        return transientChildAsString;
    }

    protected List<Object> deresolveTransientChildren(List<Object> transientChildren) {
        Assert.isNotNull(transientChildren);
        ArrayList<Object> deresolvedTransientChildren = new ArrayList<Object>();
        for (Object transientChild : transientChildren) {
            if (!(transientChild instanceof String)) {
                Object deresolvedTransientChild = this.deresolveTransientChild(transientChild);
                deresolvedTransientChildren.add(deresolvedTransientChild);
                continue;
            }
            deresolvedTransientChildren.add(transientChild);
        }
        return deresolvedTransientChildren;
    }

    protected Object deresolveTransientChild(Object transientChild) {
        if (transientChild instanceof TransientItemProvider) {
            return transientChild.getClass().getName();
        }
        if (transientChild instanceof IWrapperItemProvider) {
            IWrapperItemProvider wrapperItemProvider = (IWrapperItemProvider)transientChild;
            Object value = wrapperItemProvider.getValue();
            if (value instanceof EObject) {
                EStructuralFeature feature = wrapperItemProvider.getFeature();
                if (feature != null) {
                    return feature.getName();
                }
            } else if (value instanceof TransientItemProvider) {
                return value.getClass().getName();
            }
        }
        return transientChild;
    }

    protected Object getLastTransientChild() {
        Object lastTransientChild;
        if (!this.transientChildren.isEmpty() && !((lastTransientChild = this.transientChildren.get(this.transientChildren.size() - 1)) instanceof String)) {
            return lastTransientChild;
        }
        return null;
    }

    @Override
    public boolean hasUnderlyingModel() {
        return true;
    }

    @Override
    public boolean canUnderlyingModelBeLoaded() {
        return EcoreResourceUtil.exists((URI)this.parentURI);
    }

    @Override
    public boolean isUnderlyingModelLoaded() {
        return EcorePlatformUtil.getResource((URI)this.parentURI) != null;
    }

    @Override
    public void loadUnderlyingModel() {
        IFile file = EcorePlatformUtil.getFile((URI)this.parentURI);
        IModelDescriptor modelDescriptor = ModelDescriptorRegistry.INSTANCE.getModel(file);
        if (modelDescriptor != null) {
            ModelLoadManager.INSTANCE.loadModel(modelDescriptor, true, null);
        }
    }

    @Override
    public boolean isStale() {
        return this.stale;
    }

    @Override
    public Object getTreeElement() {
        this.transientChildren = this.resolveTransientChildren(this.transientChildren);
        return this.getLastTransientChild();
    }

    @Override
    public void appendToMemento(IMemento parentMemento) {
        if (this.parentURI != null) {
            IMemento memento = parentMemento.createChild(TreeElementStateProviderFactory.MEMENTO_TYPE_ELEMENT_TRANSIENT);
            memento.putString("parentURI", this.parentURI.toString());
            String transientChildrenAsString = this.writeTransientChildrenToString(this.transientChildren);
            memento.putString("transientChildren", transientChildrenAsString);
        }
    }

    public String toString() {
        return "TransientElementProvider [parentURI=" + this.parentURI + ", transientChildren=" + this.writeTransientChildrenToString(this.transientChildren) + "]";
    }
}

