/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.workspace.operations;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.sphinx.emf.Activator;
import org.eclipse.sphinx.emf.splitting.IModelSplitOperation;
import org.eclipse.sphinx.emf.splitting.IModelSplitPolicy;
import org.eclipse.sphinx.emf.splitting.ModelSplitProcessor;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.emf.util.EcoreResourceUtil;
import org.eclipse.sphinx.emf.util.WorkspaceEditingDomainUtil;
import org.eclipse.sphinx.emf.util.WorkspaceTransactionUtil;
import org.eclipse.sphinx.emf.workspace.internal.messages.Messages;
import org.eclipse.sphinx.emf.workspace.loading.ModelLoadManager;
import org.eclipse.sphinx.platform.operations.AbstractLabeledWorkspaceRunnable;
import org.eclipse.sphinx.platform.operations.AbstractWorkspaceOperation;
import org.eclipse.sphinx.platform.operations.ILabeledWorkspaceRunnable;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;
import org.eclipse.sphinx.platform.util.StatusUtil;

public class BasicModelSplitOperation
extends AbstractWorkspaceOperation
implements IModelSplitOperation {
    private Collection<Resource> resources;
    private Collection<URI> resourceURIs;
    private IModelSplitPolicy modelSplitPolicy;
    private boolean deleteOriginalResources = false;
    private TransactionalEditingDomain editingDomain = null;

    public BasicModelSplitOperation(IModelSplitPolicy modelSplitPolicy) {
        super(Messages.operation_splitModel_label);
        Assert.isNotNull((Object)modelSplitPolicy);
        this.modelSplitPolicy = modelSplitPolicy;
    }

    public BasicModelSplitOperation(Resource resource, IModelSplitPolicy modelSplitPolicy) {
        super(Messages.operation_splitModel_label);
        Assert.isNotNull((Object)resource);
        Assert.isNotNull((Object)modelSplitPolicy);
        this.getResources().add(resource);
        this.modelSplitPolicy = modelSplitPolicy;
    }

    public BasicModelSplitOperation(URI resourceURI, IModelSplitPolicy modelSplitPolicy) {
        super(Messages.operation_splitModel_label);
        Assert.isNotNull((Object)resourceURI);
        Assert.isNotNull((Object)modelSplitPolicy);
        this.getResourceURIs().add(resourceURI);
        this.modelSplitPolicy = modelSplitPolicy;
    }

    public Collection<Resource> getResources() {
        if (this.resources == null) {
            this.resources = new ArrayList<Resource>();
        }
        return this.resources;
    }

    public Collection<URI> getResourceURIs() {
        if (this.resourceURIs == null) {
            this.resourceURIs = new ArrayList<URI>();
        }
        return this.resourceURIs;
    }

    public IModelSplitPolicy getModelSplitPolicy() {
        return this.modelSplitPolicy;
    }

    public boolean isDeleteOriginalResources() {
        return this.deleteOriginalResources;
    }

    public void setDeleteOriginalResources(boolean deleteOriginalResources) {
        this.deleteOriginalResources = deleteOriginalResources;
    }

    public ISchedulingRule getRule() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    protected TransactionalEditingDomain getEditingDomain() {
        if (this.editingDomain == null) {
            Collection<URI> resourceURIs;
            Collection<Resource> resources = this.getResources();
            if (!resources.isEmpty()) {
                this.editingDomain = TransactionUtil.getEditingDomain((Resource)resources.iterator().next());
            }
            if (!(resourceURIs = this.getResourceURIs()).isEmpty()) {
                this.editingDomain = WorkspaceEditingDomainUtil.getEditingDomain((URI)resourceURIs.iterator().next());
            }
        }
        return this.editingDomain;
    }

    protected Map<?, ?> getSaveOptions() {
        return EcoreResourceUtil.getDefaultSaveOptions();
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        try {
            AbstractLabeledWorkspaceRunnable runnable = new AbstractLabeledWorkspaceRunnable(this.getLabel()){

                public void run(IProgressMonitor monitor) throws CoreException {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                    if (progress.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    ModelSplitProcessor processor = new ModelSplitProcessor(BasicModelSplitOperation.this.modelSplitPolicy);
                    try {
                        BasicModelSplitOperation.this.loadResourcesToSplit(processor, (IProgressMonitor)progress.newChild(25));
                        if (progress.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        processor.run((IProgressMonitor)progress.newChild(25));
                        if (progress.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        BasicModelSplitOperation.this.saveSplitResources(processor, (IProgressMonitor)progress.newChild(25));
                        if (progress.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        if (BasicModelSplitOperation.this.deleteOriginalResources) {
                            BasicModelSplitOperation.this.deleteOriginalResources((IProgressMonitor)progress.newChild(25));
                        } else {
                            progress.worked(25);
                        }
                    }
                    finally {
                        processor.dispose();
                    }
                }
            };
            TransactionalEditingDomain editingDomain = this.getEditingDomain();
            if (editingDomain != null) {
                WorkspaceTransactionUtil.executeInWriteTransaction((TransactionalEditingDomain)editingDomain, (ILabeledWorkspaceRunnable)runnable, (IProgressMonitor)monitor);
            } else {
                runnable.run(monitor);
            }
        }
        catch (OperationCanceledException ex) {
            throw ex;
        }
        catch (ExecutionException ex) {
            IStatus status = StatusUtil.createErrorStatus((Plugin)Activator.getPlugin(), (Object)((Object)ex));
            throw new CoreException(status);
        }
    }

    protected void loadResourcesToSplit(ModelSplitProcessor processor, IProgressMonitor monitor) {
        Assert.isNotNull((Object)processor);
        Collection<URI> resourceURIs = this.getResourceURIs();
        ModelLoadManager.INSTANCE.loadURIs(resourceURIs, false, monitor);
        for (URI resourceURI : resourceURIs) {
            Resource resource = EcorePlatformUtil.getResource((URI)resourceURI);
            if (resource == null) continue;
            this.resources.add(resource);
        }
        processor.getResourcesToSplit().addAll(this.resources);
    }

    protected void saveSplitResources(ModelSplitProcessor processor, IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull((Object)processor);
        EcorePlatformUtil.saveNewModelResources((TransactionalEditingDomain)this.getEditingDomain(), (Collection)processor.getSplitResourceDescriptors(), (boolean)false, (IProgressMonitor)monitor);
    }

    protected void deleteOriginalResources(IProgressMonitor monitor) throws CoreException {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                Collection<Resource> resources = BasicModelSplitOperation.this.getResources();
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)resources.size());
                if (progress.isCanceled()) {
                    throw new OperationCanceledException();
                }
                for (Resource resource : resources) {
                    if (EcoreResourceUtil.exists((URI)resource.getURI())) {
                        try {
                            resource.delete(Collections.emptyMap());
                        }
                        catch (IOException ex) {
                            PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)ex);
                        }
                    } else {
                        EcoreResourceUtil.unloadResource((Resource)resource);
                    }
                    progress.worked(1);
                    if (!progress.isCanceled()) continue;
                    throw new OperationCanceledException();
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, null, 1, monitor);
    }
}

