/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.editors.forms.layouts;

import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class LayoutFactory {
    public static final int DEFAULT_CLEAR_MARGIN = 2;
    public static final int CONTROL_HORIZONTAL_INDENT = 3;
    public static final int CLEAR_MARGIN_TOP = 2;
    public static final int CLEAR_MARGIN_BOTTOM = 2;
    public static final int CLEAR_MARGIN_LEFT = 2;
    public static final int CLEAR_MARGIN_RIGHT = 2;
    public static final int CLEAR_HORIZONTAL_SPACING = 0;
    public static final int CLEAR_VERTICAL_SPACING = 0;
    public static final int CLEAR_MARGIN_HEIGHT = 0;
    public static final int CLEAR_MARGIN_WIDTH = 0;
    public static final int FORM_BODY_MARGIN_TOP = 12;
    public static final int FORM_BODY_MARGIN_BOTTOM = 12;
    public static final int FORM_BODY_MARGIN_LEFT = 6;
    public static final int FORM_BODY_MARGIN_RIGHT = 6;
    public static final int FORM_BODY_HORIZONTAL_SPACING = 20;
    public static final int FORM_BODY_VERTICAL_SPACING = 17;
    public static final int FORM_BODY_MARGIN_HEIGHT = 0;
    public static final int FORM_BODY_MARGIN_WIDTH = 0;
    public static final int FORM_PANE_MARGIN_TOP = 0;
    public static final int FORM_PANE_MARGIN_BOTTOM = 0;
    public static final int FORM_PANE_MARGIN_LEFT = 0;
    public static final int FORM_PANE_MARGIN_RIGHT = 0;
    public static final int FORM_PANE_HORIZONTAL_SPACING = 20;
    public static final int FORM_PANE_VERTICAL_SPACING = 17;
    public static final int FORM_PANE_MARGIN_HEIGHT = 0;
    public static final int FORM_PANE_MARGIN_WIDTH = 0;
    public static final int MASTER_DETAILS_MARGIN_TOP = 0;
    public static final int MASTER_DETAILS_MARGIN_BOTTOM = 0;
    public static final int MASTER_DETAILS_MARGIN_LEFT = 0;
    public static final int MASTER_DETAILS_MARGIN_RIGHT = 1;
    public static final int MASTER_DETAILS_HORIZONTAL_SPACING = 20;
    public static final int MASTER_DETAILS_VERTICAL_SPACING = 17;
    public static final int MASTER_DETAILS_MARGIN_HEIGHT = 0;
    public static final int MASTER_DETAILS_MARGIN_WIDTH = 0;
    public static final int SECTION_CLIENT_MARGIN_TOP = 5;
    public static final int SECTION_CLIENT_MARGIN_BOTTOM = 10;
    public static final int SECTION_CLIENT_MARGIN_LEFT = 2;
    public static final int SECTION_CLIENT_MARGIN_RIGHT = 2;
    public static final int SECTION_CLIENT_HORIZONTAL_SPACING = 8;
    public static final int SECTION_CLIENT_VERTICAL_SPACING = 5;
    public static final int SECTION_CLIENT_MARGIN_HEIGHT = 0;
    public static final int SECTION_CLIENT_MARGIN_WIDTH = 0;
    public static final int SECTION_HEADER_VERTICAL_SPACING = 6;

    private LayoutFactory() {
    }

    public static GridLayout createClearGridLayout(boolean makeColumnsEqualWidth, int numColumns) {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginTop = 2;
        layout.marginBottom = 2;
        layout.marginLeft = 2;
        layout.marginRight = 2;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.makeColumnsEqualWidth = makeColumnsEqualWidth;
        layout.numColumns = numColumns;
        return layout;
    }

    public static TableWrapLayout createClearTableWrapLayout(boolean makeColumnsEqualWidth, int numColumns) {
        TableWrapLayout layout = new TableWrapLayout();
        layout.topMargin = 2;
        layout.bottomMargin = 2;
        layout.leftMargin = 2;
        layout.rightMargin = 2;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.makeColumnsEqualWidth = makeColumnsEqualWidth;
        layout.numColumns = numColumns;
        return layout;
    }

    public static GridLayout createFormBodyGridLayout(boolean makeColumnsEqualWidth, int numColumns) {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginTop = 12;
        layout.marginBottom = 12;
        layout.marginLeft = 6;
        layout.marginRight = 6;
        layout.horizontalSpacing = 20;
        layout.verticalSpacing = 17;
        layout.makeColumnsEqualWidth = makeColumnsEqualWidth;
        layout.numColumns = numColumns;
        return layout;
    }

    public static TableWrapLayout createFormBodyTableWrapLayout(boolean makeColumnsEqualWidth, int numColumns) {
        TableWrapLayout layout = new TableWrapLayout();
        layout.topMargin = 12;
        layout.bottomMargin = 12;
        layout.leftMargin = 6;
        layout.rightMargin = 6;
        layout.horizontalSpacing = 20;
        layout.verticalSpacing = 17;
        layout.makeColumnsEqualWidth = makeColumnsEqualWidth;
        layout.numColumns = numColumns;
        return layout;
    }

    public static GridLayout createFormPaneGridLayout(boolean makeColumnsEqualWidth, int numColumns) {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginTop = 0;
        layout.marginBottom = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.horizontalSpacing = 20;
        layout.verticalSpacing = 17;
        layout.makeColumnsEqualWidth = makeColumnsEqualWidth;
        layout.numColumns = numColumns;
        return layout;
    }

    public static TableWrapLayout createFormPaneTableWrapLayout(boolean makeColumnsEqualWidth, int numColumns) {
        TableWrapLayout layout = new TableWrapLayout();
        layout.topMargin = 0;
        layout.bottomMargin = 0;
        layout.leftMargin = 0;
        layout.rightMargin = 0;
        layout.horizontalSpacing = 20;
        layout.verticalSpacing = 17;
        layout.makeColumnsEqualWidth = makeColumnsEqualWidth;
        layout.numColumns = numColumns;
        return layout;
    }

    public static GridLayout createMasterGridLayout(boolean makeColumnsEqualWidth, int numColumns) {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginTop = 0;
        layout.marginBottom = 0;
        layout.marginLeft = 0;
        int marginRight = 20;
        if (marginRight > 0 && (marginRight /= 2) > 0) {
            --marginRight;
        }
        layout.marginRight = marginRight;
        layout.horizontalSpacing = 20;
        layout.verticalSpacing = 17;
        layout.makeColumnsEqualWidth = makeColumnsEqualWidth;
        layout.numColumns = numColumns;
        return layout;
    }

    public static TableWrapLayout createMasterTableWrapLayout(boolean makeColumnsEqualWidth, int numColumns) {
        TableWrapLayout layout = new TableWrapLayout();
        layout.topMargin = 0;
        layout.bottomMargin = 0;
        layout.leftMargin = 0;
        int rightMargin = 20;
        if (rightMargin > 0 && (rightMargin /= 2) > 0) {
            --rightMargin;
        }
        layout.rightMargin = rightMargin;
        layout.horizontalSpacing = 20;
        layout.verticalSpacing = 17;
        layout.makeColumnsEqualWidth = makeColumnsEqualWidth;
        layout.numColumns = numColumns;
        return layout;
    }

    public static GridLayout createDetailsGridLayout(boolean makeColumnsEqualWidth, int numColumns) {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginTop = 0;
        layout.marginBottom = 0;
        int marginLeft = 20;
        if (marginLeft > 0 && (marginLeft /= 2) > 0) {
            --marginLeft;
        }
        layout.marginLeft = marginLeft;
        layout.marginRight = 1;
        layout.horizontalSpacing = 20;
        layout.verticalSpacing = 17;
        layout.makeColumnsEqualWidth = makeColumnsEqualWidth;
        layout.numColumns = numColumns;
        return layout;
    }

    public static TableWrapLayout createDetailsTableWrapLayout(boolean makeColumnsEqualWidth, int numColumns) {
        TableWrapLayout layout = new TableWrapLayout();
        layout.topMargin = 0;
        layout.bottomMargin = 0;
        int leftMargin = 20;
        if (leftMargin > 0 && (leftMargin /= 2) > 0) {
            --leftMargin;
        }
        layout.leftMargin = leftMargin;
        layout.rightMargin = 1;
        layout.horizontalSpacing = 20;
        layout.verticalSpacing = 17;
        layout.makeColumnsEqualWidth = makeColumnsEqualWidth;
        layout.numColumns = numColumns;
        return layout;
    }

    public static GridLayout createSectionClientGridLayout(boolean makeColumnsEqualWidth, int numColumns) {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginTop = 5;
        layout.marginBottom = 10;
        layout.marginLeft = 2;
        layout.marginRight = 2;
        layout.horizontalSpacing = 8;
        layout.verticalSpacing = 5;
        layout.makeColumnsEqualWidth = makeColumnsEqualWidth;
        layout.numColumns = numColumns;
        return layout;
    }

    public static TableWrapLayout createSectionClientTableWrapLayout(boolean makeColumnsEqualWidth, int numColumns) {
        TableWrapLayout layout = new TableWrapLayout();
        layout.topMargin = 5;
        layout.bottomMargin = 10;
        layout.leftMargin = 2;
        layout.rightMargin = 2;
        layout.horizontalSpacing = 8;
        layout.verticalSpacing = 5;
        layout.makeColumnsEqualWidth = makeColumnsEqualWidth;
        layout.numColumns = numColumns;
        return layout;
    }

    public static void highlightLayoutArea(Composite composite, int color) {
        composite.setBackground(Display.getCurrent().getSystemColor(color));
    }
}

