/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.testutils.integration.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sphinx.emf.metamodel.IMetaModelDescriptor;
import org.eclipse.sphinx.emf.metamodel.MetaModelDescriptorRegistry;
import org.eclipse.sphinx.emf.util.WorkspaceEditingDomainUtil;
import org.eclipse.sphinx.platform.util.ExtendedPlatform;
import org.eclipse.sphinx.testutils.integration.internal.ReferenceModelDescriptor;

public class ReferenceProjectDescriptor {
    private IProject project;
    private Map<IMetaModelDescriptor, Set<IFile>> referenceFiles = new HashMap<IMetaModelDescriptor, Set<IFile>>();
    private Set<ReferenceModelDescriptor> referenceModelDescriptors = new HashSet<ReferenceModelDescriptor>();

    public ReferenceProjectDescriptor(String projectName) {
        Assert.isNotNull((Object)projectName);
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
    }

    public IProject getProject() {
        return this.project;
    }

    public String getProjectName() {
        return this.project.getName();
    }

    public void addFile(String relativeFilePath, IMetaModelDescriptor metaModelDescriptor) {
        this.addFile(this.project.getFullPath().append(relativeFilePath), metaModelDescriptor);
    }

    private void addFile(IPath path, IMetaModelDescriptor metaModelDescriptor) {
        Set<IFile> modelFiles;
        Assert.isNotNull((Object)path);
        if (metaModelDescriptor == null) {
            metaModelDescriptor = MetaModelDescriptorRegistry.NO_MM;
        }
        if ((modelFiles = this.referenceFiles.get(metaModelDescriptor)) == null) {
            modelFiles = new HashSet<IFile>();
            this.referenceFiles.put(metaModelDescriptor, modelFiles);
        }
        for (IFile modelFile : modelFiles) {
            if (!modelFile.getFullPath().equals((Object)path)) continue;
            return;
        }
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        modelFiles.add(file);
    }

    public Set<IFile> getAllFiles() {
        HashSet<IFile> allFiles = new HashSet<IFile>();
        Collection<Set<IFile>> metaModelFiles = this.referenceFiles.values();
        for (Set<IFile> modelFiles : metaModelFiles) {
            allFiles.addAll(modelFiles);
        }
        return allFiles;
    }

    public List<String> getAllFileNames() {
        ArrayList<String> filesNames = new ArrayList<String>();
        Set<IMetaModelDescriptor> metaModelDescriptors = this.referenceFiles.keySet();
        for (IMetaModelDescriptor metaModelDescriptor : metaModelDescriptors) {
            filesNames.addAll(this.getFileNames(metaModelDescriptor));
        }
        return filesNames;
    }

    public Map<IMetaModelDescriptor, Set<IFile>> getFiles() {
        return this.referenceFiles;
    }

    public Set<IFile> getFiles(IMetaModelDescriptor metaModelDescriptor) {
        Set<IFile> modelFiles;
        if (metaModelDescriptor == null) {
            metaModelDescriptor = MetaModelDescriptorRegistry.NO_MM;
        }
        if ((modelFiles = this.referenceFiles.get(metaModelDescriptor)) != null) {
            return modelFiles;
        }
        return Collections.emptySet();
    }

    public List<String> getFileNames(IMetaModelDescriptor metaModelDescriptor) {
        ArrayList<String> filesNames = new ArrayList<String>();
        Set<IFile> modelFiles = this.referenceFiles.get(metaModelDescriptor);
        if (modelFiles != null) {
            for (IFile file : modelFiles) {
                filesNames.add(file.getName());
            }
        }
        return filesNames;
    }

    public IFile getFile(String fileName) {
        if (fileName != null) {
            Collection<Set<IFile>> metaModelFiles = this.referenceFiles.values();
            for (Set<IFile> modelFiles : metaModelFiles) {
                for (IFile modelFile : modelFiles) {
                    if (!modelFile.getName().equals(fileName)) continue;
                    return modelFile;
                }
            }
        }
        return null;
    }

    public IFile getFile(String fileName, IMetaModelDescriptor metaModelDescriptor) {
        if (fileName != null) {
            Set<IFile> modelFiles;
            if (metaModelDescriptor == null) {
                metaModelDescriptor = MetaModelDescriptorRegistry.NO_MM;
            }
            if ((modelFiles = this.referenceFiles.get(metaModelDescriptor)) != null) {
                for (IFile modelFile : modelFiles) {
                    if (!modelFile.getName().equals(fileName)) continue;
                    return modelFile;
                }
            }
        }
        return null;
    }

    public void addReferenceModelDescriptor(ReferenceModelDescriptor referenceModelDescriptor) {
        if (!this.referenceModelDescriptors.contains(referenceModelDescriptor)) {
            this.referenceModelDescriptors.add(referenceModelDescriptor);
        }
    }

    public ReferenceModelDescriptor getReferenceModelDescriptor(ReferenceModelDescriptor referenceModelDescriptor) {
        if (this.referenceModelDescriptors.contains(referenceModelDescriptor)) {
            return referenceModelDescriptor;
        }
        return null;
    }

    public Set<ReferenceModelDescriptor> getReferenceModelDescriptors() {
        return this.referenceModelDescriptors;
    }

    public Set<ReferenceModelDescriptor> getAccessibleReferenceModelDescriptors() {
        HashSet<ReferenceModelDescriptor> accessibleReferenceModelDescriptors = new HashSet<ReferenceModelDescriptor>();
        for (ReferenceModelDescriptor referenceModelDescriptor : this.referenceModelDescriptors) {
            boolean empty = true;
            for (IFile file : ExtendedPlatform.getAllFiles((IProject)this.project, (boolean)true)) {
                TransactionalEditingDomain currentEditingDomain = WorkspaceEditingDomainUtil.getCurrentEditingDomain((IFile)file);
                if (currentEditingDomain == null || !referenceModelDescriptor.getEditingDomainName().equals(currentEditingDomain.getID())) continue;
                empty = false;
                break;
            }
            if (empty) continue;
            accessibleReferenceModelDescriptors.add(referenceModelDescriptor);
        }
        return accessibleReferenceModelDescriptors;
    }

    public String toString() {
        return this.project.getName();
    }
}

