/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.compare.ui.viewer.structuremerge;

import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.ide.ui.internal.configuration.EMFCompareConfiguration;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.EMFCompareStructureMergeViewer;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.sphinx.emf.compare.scope.IModelComparisonScope;
import org.eclipse.sphinx.emf.model.ModelDescriptorRegistry;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.emf.util.EcoreResourceUtil;
import org.eclipse.sphinx.emf.workspace.loading.ModelLoadManager;
import org.eclipse.swt.widgets.Composite;

public class ModelCompareStructureMergeViewer
extends EMFCompareStructureMergeViewer {
    private Resource leftResource;
    private Resource rightResource;

    public ModelCompareStructureMergeViewer(Composite parent, EMFCompareConfiguration config) {
        super(parent, config);
    }

    protected void loadModel(IModelComparisonScope comparisonScope, IProgressMonitor monitor) {
        if (comparisonScope != null && comparisonScope.isFileBasedComparison()) {
            IFile rightFile;
            HashSet<IFile> sphinxModelFiles = new HashSet<IFile>();
            ResourceSetImpl nonSphinxModelResouceSet = new ResourceSetImpl();
            IFile leftFile = comparisonScope.getLeftFile();
            if (leftFile != null) {
                if (ModelDescriptorRegistry.INSTANCE.isModelFile(leftFile)) {
                    sphinxModelFiles.add(leftFile);
                } else {
                    this.leftResource = EcoreResourceUtil.loadResource((ResourceSet)nonSphinxModelResouceSet, (URI)EcorePlatformUtil.createURI((IPath)leftFile.getFullPath()), this.getLoadOptions());
                }
            }
            if ((rightFile = comparisonScope.getRightFile()) != null) {
                if (ModelDescriptorRegistry.INSTANCE.isModelFile(rightFile)) {
                    sphinxModelFiles.add(rightFile);
                } else {
                    this.rightResource = EcoreResourceUtil.loadResource((ResourceSet)nonSphinxModelResouceSet, (URI)EcorePlatformUtil.createURI((IPath)rightFile.getFullPath()), this.getLoadOptions());
                }
            }
            ModelLoadManager.INSTANCE.loadFiles(sphinxModelFiles, false, monitor);
            if (this.leftResource == null) {
                this.leftResource = EcorePlatformUtil.getResource((IFile)leftFile);
            }
            if (this.rightResource == null) {
                this.rightResource = EcorePlatformUtil.getResource((IFile)rightFile);
            }
        }
    }

    protected Map<?, ?> getLoadOptions() {
        return EcoreResourceUtil.getDefaultLoadOptions();
    }
}

