/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.module.script.defaultscope.internal;

import java.io.File;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.smarthome.automation.RuleRegistry;
import org.eclipse.smarthome.automation.module.script.ScriptExtensionProvider;
import org.eclipse.smarthome.automation.module.script.defaultscope.internal.ItemRegistryDelegate;
import org.eclipse.smarthome.automation.module.script.defaultscope.internal.ScriptBusEvent;
import org.eclipse.smarthome.automation.module.script.defaultscope.internal.ScriptThingActions;
import org.eclipse.smarthome.core.events.EventPublisher;
import org.eclipse.smarthome.core.items.ItemRegistry;
import org.eclipse.smarthome.core.library.types.DateTimeType;
import org.eclipse.smarthome.core.library.types.DecimalType;
import org.eclipse.smarthome.core.library.types.HSBType;
import org.eclipse.smarthome.core.library.types.IncreaseDecreaseType;
import org.eclipse.smarthome.core.library.types.NextPreviousType;
import org.eclipse.smarthome.core.library.types.OnOffType;
import org.eclipse.smarthome.core.library.types.OpenClosedType;
import org.eclipse.smarthome.core.library.types.PercentType;
import org.eclipse.smarthome.core.library.types.PlayPauseType;
import org.eclipse.smarthome.core.library.types.PointType;
import org.eclipse.smarthome.core.library.types.QuantityType;
import org.eclipse.smarthome.core.library.types.RawType;
import org.eclipse.smarthome.core.library.types.RewindFastforwardType;
import org.eclipse.smarthome.core.library.types.StopMoveType;
import org.eclipse.smarthome.core.library.types.StringListType;
import org.eclipse.smarthome.core.library.types.StringType;
import org.eclipse.smarthome.core.library.types.UpDownType;
import org.eclipse.smarthome.core.library.unit.ImperialUnits;
import org.eclipse.smarthome.core.library.unit.MetricPrefix;
import org.eclipse.smarthome.core.library.unit.SIUnits;
import org.eclipse.smarthome.core.library.unit.SmartHomeUnits;
import org.eclipse.smarthome.core.thing.ThingRegistry;
import org.eclipse.smarthome.core.thing.binding.ThingActions;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.types.UnDefType;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(immediate=true)
public class DefaultScriptScopeProvider
implements ScriptExtensionProvider {
    private final Queue<ThingActions> queuedBeforeActivation = new LinkedList<ThingActions>();
    private Map<String, Object> elements;
    private ItemRegistry itemRegistry;
    private ThingRegistry thingRegistry;
    private EventPublisher eventPublisher;
    private ScriptBusEvent busEvent;
    private ScriptThingActions thingActions;
    private RuleRegistry ruleRegistry;

    @Reference
    protected void setRuleRegistry(RuleRegistry ruleRegistry) {
        this.ruleRegistry = ruleRegistry;
    }

    protected void unsetRuleRegistry(RuleRegistry ruleRegistry) {
        this.ruleRegistry = null;
    }

    @Reference
    protected void setThingRegistry(ThingRegistry thingRegistry) {
        this.thingRegistry = thingRegistry;
    }

    protected void unsetThingRegistry(ThingRegistry thingRegistry) {
        this.thingRegistry = null;
    }

    @Reference
    protected void setItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = itemRegistry;
    }

    protected void unsetItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = null;
    }

    @Reference
    protected void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    protected void unsetEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = null;
    }

    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE)
    synchronized void addThingActions(ThingActions thingActions) {
        if (this.thingActions == null) {
            this.queuedBeforeActivation.add(thingActions);
        } else {
            this.thingActions.addThingActions(thingActions);
            this.elements.put(thingActions.getClass().getSimpleName(), thingActions.getClass());
        }
    }

    protected void removeThingActions(ThingActions thingActions) {
        this.elements.remove(thingActions.getClass().getSimpleName());
        this.thingActions.removeThingActions(thingActions);
    }

    @Activate
    protected synchronized void activate() {
        this.busEvent = new ScriptBusEvent(this.itemRegistry, this.eventPublisher);
        this.thingActions = new ScriptThingActions(this.thingRegistry);
        this.elements = new HashMap<String, Object>();
        this.elements.put("State", State.class);
        this.elements.put("Command", Command.class);
        this.elements.put("StringUtils", StringUtils.class);
        this.elements.put("URLEncoder", URLEncoder.class);
        this.elements.put("FileUtils", FileUtils.class);
        this.elements.put("FilenameUtils", FilenameUtils.class);
        this.elements.put("File", File.class);
        this.elements.put("IncreaseDecreaseType", IncreaseDecreaseType.class);
        this.elements.put("DECREASE", IncreaseDecreaseType.DECREASE);
        this.elements.put("INCREASE", IncreaseDecreaseType.INCREASE);
        this.elements.put("OnOffType", OnOffType.class);
        this.elements.put("ON", OnOffType.ON);
        this.elements.put("OFF", OnOffType.OFF);
        this.elements.put("OpenClosedType", OpenClosedType.class);
        this.elements.put("CLOSED", OpenClosedType.CLOSED);
        this.elements.put("OPEN", OpenClosedType.OPEN);
        this.elements.put("StopMoveType", StopMoveType.class);
        this.elements.put("MOVE", StopMoveType.MOVE);
        this.elements.put("STOP", StopMoveType.STOP);
        this.elements.put("UpDownType", UpDownType.class);
        this.elements.put("DOWN", UpDownType.DOWN);
        this.elements.put("UP", UpDownType.UP);
        this.elements.put("UnDefType", UnDefType.class);
        this.elements.put("NULL", UnDefType.NULL);
        this.elements.put("UNDEF", UnDefType.UNDEF);
        this.elements.put("NextPreviousType", NextPreviousType.class);
        this.elements.put("NEXT", NextPreviousType.NEXT);
        this.elements.put("PREVIOUS", NextPreviousType.PREVIOUS);
        this.elements.put("PlayPauseType", PlayPauseType.class);
        this.elements.put("PLAY", PlayPauseType.PLAY);
        this.elements.put("PAUSE", PlayPauseType.PAUSE);
        this.elements.put("RewindFastforwardType", RewindFastforwardType.class);
        this.elements.put("REWIND", RewindFastforwardType.REWIND);
        this.elements.put("FASTFORWARD", RewindFastforwardType.FASTFORWARD);
        this.elements.put("QuantityType", QuantityType.class);
        this.elements.put("StringListType", StringListType.class);
        this.elements.put("RawType", RawType.class);
        this.elements.put("DateTimeType", DateTimeType.class);
        this.elements.put("DecimalType", DecimalType.class);
        this.elements.put("HSBType", HSBType.class);
        this.elements.put("PercentType", PercentType.class);
        this.elements.put("PointType", PointType.class);
        this.elements.put("StringType", StringType.class);
        this.elements.put("SIUnits", SIUnits.class);
        this.elements.put("ImperialUnits", ImperialUnits.class);
        this.elements.put("MetricPrefix", MetricPrefix.class);
        this.elements.put("SmartHomeUnits", SmartHomeUnits.class);
        this.elements.put("items", new ItemRegistryDelegate(this.itemRegistry));
        this.elements.put("ir", this.itemRegistry);
        this.elements.put("itemRegistry", this.itemRegistry);
        this.elements.put("things", this.thingRegistry);
        this.elements.put("events", this.busEvent);
        this.elements.put("rules", this.ruleRegistry);
        this.elements.put("actions", this.thingActions);
        this.queuedBeforeActivation.forEach(thingActions -> this.addThingActions((ThingActions)thingActions));
        this.queuedBeforeActivation.clear();
    }

    @Deactivate
    protected void deactivate() {
        this.busEvent.dispose();
        this.busEvent = null;
        this.thingActions.dispose();
        this.thingActions = null;
        this.elements = null;
    }

    public Collection<String> getDefaultPresets() {
        return Collections.singleton("default");
    }

    public Collection<String> getPresets() {
        return Collections.singleton("default");
    }

    public Collection<String> getTypes() {
        return this.elements.keySet();
    }

    public Object get(String scriptIdentifier, String type) {
        return this.elements.get(type);
    }

    public Map<String, Object> importPreset(String scriptIdentifier, String preset) {
        if (preset.equals("default")) {
            return this.elements;
        }
        return null;
    }

    public void unload(String scriptIdentifier) {
    }
}

